/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.editors.zookeeperconnectionform;

import com.fusesource.zk.core.EclipseCoreActivator;
import com.fusesource.zk.core.editors.DataModelFormEditor;
import com.fusesource.zk.core.editors.DataModelFormPage;
import com.fusesource.zk.core.widgets.grid.GridTextInput;
import com.fusesource.zk.zookeeper.ZooKeeperActivator;
import com.fusesource.zk.zookeeper.actions.ZooKeeperOpenAction;
import com.fusesource.zk.zookeeper.data.Znode;
import com.fusesource.zk.zookeeper.data.ZooKeeperConnection;
import com.fusesource.zk.zookeeper.data.ZooKeeperConnectionDescriptor;
import com.fusesource.zk.zookeeper.editors.zookeeperconnectionform.ZooKeeperConnectionModelFormEditor;
import com.fusesource.zk.zookeeper.model.ZnodeModel;
import com.fusesource.zk.zookeeper.model.ZooKeeperConnectionModel;
import com.fusesource.zk.zookeeper.viewers.ZnodeModelElementType;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.zookeeper.ZooKeeper;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public final class ZooKeeperConnectionModelMainFormPage
extends DataModelFormPage<ZooKeeperConnectionModel> {
    public static final String ID = ZooKeeperConnectionModelMainFormPage.class.getName();
    public static final Image IMAGE = EclipseCoreActivator.getManagedImage((String)"IMAGE_KEY_OBJECT_MAIN_TAB");
    public static final String TITLE = "Main";
    protected static final String EDIT_SECTION_TITLE = "Edit";
    protected static final String ZNODE_SECTION_TITLE = "Znode";
    protected static final int[] PROPERTIES_COLUMN_ALIGNMENTS = new int[]{16384, 16384};
    protected static final String[] PROPERTIES_COLUMN_TITLES = new String[]{"Name", "Value"};
    protected static final int[] PROPERTIES_COLUMN_WIDTHS = new int[]{-1, 350};
    protected static final String PROPERTIES_SECTION_TITLE = "Properties";
    protected static final int PROPERTIES_TABLE_STYLE = 66306;
    private Section _EditSection;
    private Section _PropertiesSection;
    private Section _ZnodeSection;
    private Text _RootPathText;
    private Text _SessionTimeoutText;
    private ZnodeModelElementType _ZnodeModelElementType;

    public ZooKeeperConnectionModelMainFormPage(ZooKeeperConnectionModelFormEditor editor) {
        super((DataModelFormEditor)editor, ID, TITLE);
        this.setImage(IMAGE);
        this._ZnodeModelElementType = new ZnodeModelElementType();
    }

    public String getRootPath() {
        String rootPath = this._RootPathText.getText();
        rootPath = !rootPath.trim().isEmpty() ? rootPath : null;
        return rootPath;
    }

    public int getSessionTimeout() {
        int sessionTimeout = -1;
        try {
            sessionTimeout = Integer.parseInt(this._SessionTimeoutText.getText());
        }
        catch (NumberFormatException numberFormatException) {}
        return sessionTimeout;
    }

    public Section getPropertiesSection() {
        return this._PropertiesSection;
    }

    protected Layout createClientLayout() {
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.verticalSpacing = 20;
        gridLayout.marginWidth = 8;
        return gridLayout;
    }

    protected void createModelFormContent(IManagedForm managedForm, Composite client) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        this._EditSection = this.createEditSection(form, client, toolkit);
        GridData editSectionGridData = new GridData(768);
        this._EditSection.setLayoutData((Object)editSectionGridData);
        this._PropertiesSection = this.createPropertiesTableSection(form, client, toolkit);
        GridData propertiesSectionGridData = new GridData(768);
        this._PropertiesSection.setLayoutData((Object)propertiesSectionGridData);
        this._ZnodeSection = this.createZnodeSection(form, client, toolkit);
        GridData znodeSectionGridData = new GridData(768);
        this._ZnodeSection.setLayoutData((Object)znodeSectionGridData);
        Table propertiesSectionTable = this.getPropertiesSectionTable();
        this.initTableEdit(propertiesSectionTable, null, 1);
    }

    protected Section createEditSection(ScrolledForm form, Composite client, FormToolkit toolkit) {
        Section section = this.createSection(form, client, toolkit, EDIT_SECTION_TITLE, EclipseCoreActivator.getManagedImage((String)"IMAGE_KEY_OBJECT_EDIT"));
        Composite sectionClient = this.createSectionClient(section, toolkit);
        Label rootPathLabel = toolkit.createLabel(sectionClient, "&Root Path: ");
        this._RootPathText = toolkit.createText(sectionClient, "", 2052);
        this._RootPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ZooKeeperConnectionModelMainFormPage.this.setDirtyInternal(true);
            }
        });
        Label sessionTimeoutLabel = toolkit.createLabel(sectionClient, "&Session Timeout: ");
        this._SessionTimeoutText = toolkit.createText(sectionClient, "", 2052);
        this._SessionTimeoutText.setTextLimit(10);
        this._SessionTimeoutText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                String text = event.text;
                event.doit = text.length() == 0 || Character.isDigit(text.charAt(0)) && GridTextInput.isValidIntegerText((String)text);
            }
        });
        this._SessionTimeoutText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ZooKeeperConnectionModelMainFormPage.this.setDirtyInternal(true);
            }
        });
        FormData rootPathLabelFormData = new FormData();
        rootPathLabelFormData.top = new FormAttachment((Control)this._RootPathText, 0, 0x1000000);
        rootPathLabelFormData.left = new FormAttachment(0, 0);
        rootPathLabel.setLayoutData((Object)rootPathLabelFormData);
        FormData rootPathTextFormData = new FormData();
        rootPathTextFormData.top = new FormAttachment(0, 0);
        rootPathTextFormData.left = new FormAttachment((Control)this._SessionTimeoutText, 0, 16384);
        rootPathTextFormData.right = new FormAttachment(100, 0);
        this._RootPathText.setLayoutData((Object)rootPathTextFormData);
        FormData sessionTimeoutLabelFormData = new FormData();
        sessionTimeoutLabelFormData.top = new FormAttachment((Control)this._SessionTimeoutText, 0, 0x1000000);
        sessionTimeoutLabelFormData.left = new FormAttachment(0, 0);
        sessionTimeoutLabel.setLayoutData((Object)sessionTimeoutLabelFormData);
        FormData sessionTimeoutTextFormData = new FormData();
        sessionTimeoutTextFormData.top = new FormAttachment((Control)this._RootPathText);
        sessionTimeoutTextFormData.left = new FormAttachment((Control)sessionTimeoutLabel);
        sessionTimeoutTextFormData.right = new FormAttachment(100, 0);
        this._SessionTimeoutText.setLayoutData((Object)sessionTimeoutTextFormData);
        return section;
    }

    protected Section createPropertiesTableSection(ScrolledForm form, Composite client, FormToolkit toolkit) {
        return this.createTableSection(form, client, toolkit, PROPERTIES_SECTION_TITLE, EclipseCoreActivator.getManagedImage((String)"IMAGE_KEY_OBJECT_PROPERTIES"), 66306, PROPERTIES_COLUMN_TITLES, PROPERTIES_COLUMN_ALIGNMENTS);
    }

    protected Section createZnodeSection(ScrolledForm form, Composite client, FormToolkit toolkit) {
        Section section = this.createSection(form, client, toolkit, ZNODE_SECTION_TITLE, ZooKeeperActivator.getManagedImage("IMAGE_KEY_OBJECT_ZNODE_LEAF"));
        Composite sectionClient = this.createSectionClient(section, toolkit);
        Label openZnodeLabel = toolkit.createLabel(sectionClient, "&Open Znode: ");
        final Text znodePathText = toolkit.createText(sectionClient, Znode.ROOT_PATH, 2052);
        final Button openZnodeButton = toolkit.createButton(sectionClient, "Open", 8);
        znodePathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String path = znodePathText.getText();
                openZnodeButton.setEnabled(ZooKeeperConnectionModelMainFormPage.this.canOpenZnode(path));
            }
        });
        znodePathText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    String path = znodePathText.getText();
                    ZooKeeperConnectionModelMainFormPage.this.openZnode(path);
                }
            }
        });
        openZnodeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String path = znodePathText.getText();
                ZooKeeperConnectionModelMainFormPage.this.openZnode(path);
            }
        });
        FormData openZnodeLabelFormData = new FormData();
        openZnodeLabelFormData.top = new FormAttachment((Control)znodePathText, 0, 0x1000000);
        openZnodeLabelFormData.left = new FormAttachment(0, 0);
        openZnodeLabel.setLayoutData((Object)openZnodeLabelFormData);
        FormData znodePathTextFormData = new FormData();
        znodePathTextFormData.top = new FormAttachment(0, 0);
        znodePathTextFormData.left = new FormAttachment((Control)openZnodeLabel);
        znodePathTextFormData.right = new FormAttachment((Control)openZnodeButton, 0, 16384);
        znodePathText.setLayoutData((Object)znodePathTextFormData);
        FormData openZnodeButtonFormData = new FormData();
        openZnodeButtonFormData.top = new FormAttachment((Control)znodePathText, 0, 0x1000000);
        openZnodeButtonFormData.right = new FormAttachment(100, 0);
        openZnodeButton.setLayoutData((Object)openZnodeButtonFormData);
        return section;
    }

    protected final Table getPropertiesSectionTable() {
        return (Table)this.getPropertiesSection().getClient();
    }

    protected final void initFromModelInternal() {
        ZooKeeperConnectionModel model = (ZooKeeperConnectionModel)this.getModel();
        ZooKeeperConnectionDescriptor descriptor = (ZooKeeperConnectionDescriptor)((Object)model.getKey());
        String rootPath = descriptor.getRootPath();
        rootPath = rootPath != null ? rootPath : "/";
        this._RootPathText.setText(rootPath);
        int sessionTimeout = descriptor.getSessionTimeout();
        this._SessionTimeoutText.setText(String.valueOf(sessionTimeout));
        this.initPropertiesSectionFromModel();
        Section propertiesSection = this.getPropertiesSection();
        if (propertiesSection != null) {
            propertiesSection.layout(true);
        }
    }

    protected void initPropertiesSectionFromModel() {
        Table table = this.getPropertiesSectionTable();
        table.removeAll();
        Map<String, String> properties = this.getZooKeeperConnectionProperties();
        for (String key : properties.keySet()) {
            TableItem item = new TableItem(table, 0);
            String value = properties.get(key);
            item.setText(0, key);
            item.setText(1, value);
            Color valueTextColor = table.getForeground();
            if (key.equals("State") && !ZooKeeper.States.CONNECTED.name().equals(value)) {
                valueTextColor = table.getDisplay().getSystemColor(3);
            }
            item.setForeground(1, valueTextColor);
        }
        this.packTable(table, PROPERTIES_COLUMN_WIDTHS);
    }

    private Map<String, String> getZooKeeperConnectionProperties() {
        ZooKeeperConnectionModel model = (ZooKeeperConnectionModel)this.getModel();
        ZooKeeperConnectionDescriptor descriptor = (ZooKeeperConnectionDescriptor)((Object)model.getKey());
        ZooKeeperConnection connection = (ZooKeeperConnection)model.getData();
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        this.putProperty(properties, "State", connection.getState().name());
        this.putProperty(properties, "Connect String", descriptor.getConnectString());
        this.putProperty(properties, "Session Id", connection.getSessionId());
        return properties;
    }

    private void putProperty(Map<String, String> properties, String key, Object value) {
        if (value == null) {
            value = "";
        }
        String stringValue = String.valueOf(value);
        properties.put(key, stringValue);
    }

    private boolean canOpenZnode(String path) {
        boolean validPath;
        boolean bl = validPath = path != null && path.length() > 0;
        if (validPath) {
            try {
                Znode.validatePath(path, false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                validPath = false;
            }
        }
        return validPath;
    }

    private void openZnode(String path) {
        if (!this.canOpenZnode(path)) {
            String title = "Invalid Path";
            String message = "Znode path '" + path + "' is not valid.";
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
            return;
        }
        ZooKeeperConnectionModel zooKeeperConnectionModel = (ZooKeeperConnectionModel)this.getModel();
        ZnodeModel znodeModel = (ZnodeModel)zooKeeperConnectionModel.getRootZnodeModel().getManager().getModel((Comparable)((Object)path));
        if (znodeModel == null) {
            String title = "No Znode";
            String message = "Znode '" + path + "' does not exist.";
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
            return;
        }
        ZooKeeperOpenAction openAction = this._ZnodeModelElementType.getOpenAction();
        if (openAction != null) {
            try {
                openAction.runWithObject((Object)znodeModel);
            }
            catch (Exception ex) {
                ZooKeeperActivator.reportError(ex);
            }
        }
    }
}

