/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.editors.zookeeperconnectionform;

import com.fusesource.zk.core.EclipseCoreActivator;
import com.fusesource.zk.zookeeper.ZooKeeperActivator;
import com.fusesource.zk.zookeeper.data.ZooKeeperConnectionDescriptor;
import com.fusesource.zk.zookeeper.data.ZooKeeperServerDescriptor;
import com.fusesource.zk.zookeeper.editors.zookeeperconnectionform.TableViewerOrchestrationZooKeeperConnectionModelFormPage;
import com.fusesource.zk.zookeeper.editors.zookeeperconnectionform.ZooKeeperConnectionModelFormEditor;
import com.fusesource.zk.zookeeper.model.ZooKeeperConnectionModel;
import com.fusesource.zk.zookeeper.model.ZooKeeperServerModel;
import com.fusesource.zk.zookeeper.viewers.ZooKeeperServerModelElementType;
import com.fusesource.zk.zookeeper.widgets.TableViewerOrchestrationComposite;
import com.fusesource.zk.zookeeper.widgets.ZooKeeperConnectionServerComposite;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IManagedForm;

public final class ZooKeeperConnectionModelServersFormPage
extends TableViewerOrchestrationZooKeeperConnectionModelFormPage<ZooKeeperServerDescriptor> {
    public static final String ID = ZooKeeperConnectionModelServersFormPage.class.getName();
    public static final Image IMAGE = EclipseCoreActivator.getManagedImage((String)"IMAGE_KEY_OBJECT_SERVERS");
    public static final String TITLE = "Servers";
    private ZooKeeperServerModelElementType _ZooKeeperServerModelElementType;

    public ZooKeeperConnectionModelServersFormPage(ZooKeeperConnectionModelFormEditor editor) {
        super(editor, ID, TITLE);
        this.setImage(IMAGE);
        this._ZooKeeperServerModelElementType = new ZooKeeperServerModelElementType();
    }

    public Set<ZooKeeperServerDescriptor> getServersFromTable() {
        return this.getElementSet();
    }

    @Override
    protected void createModelFormContent(IManagedForm managedForm, Composite client) {
        super.createModelFormContent(managedForm, client);
        ZooKeeperConnectionServerComposite composite = (ZooKeeperConnectionServerComposite)this.getTableViewerOrchestrationComposite();
        TableViewer serverDescriptorTableViewer = composite.getTableViewer();
        serverDescriptorTableViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ZooKeeperConnectionModelServersFormPage.this.openSelectedServers(event.getSelection());
            }
        });
    }

    @Override
    protected TableViewerOrchestrationComposite<ZooKeeperServerDescriptor> createTableViewerOrchestrationComposite(Composite client) {
        return new ZooKeeperConnectionServerComposite(client, 0);
    }

    @Override
    protected Collection<ZooKeeperServerDescriptor> getElementsFromModel() {
        return ((ZooKeeperConnectionDescriptor)((Object)((ZooKeeperConnectionModel)this.getModel()).getKey())).getServers();
    }

    private void openSelectedServers(ISelection selection) {
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Iterator selectionIterator = structuredSelection.iterator();
        ZooKeeperConnectionModel connectionModel = (ZooKeeperConnectionModel)this.getModel();
        while (selectionIterator.hasNext()) {
            ZooKeeperServerModel serverModel;
            ZooKeeperServerDescriptor descriptor = (ZooKeeperServerDescriptor)selectionIterator.next();
            if (!((ZooKeeperConnectionDescriptor)((Object)connectionModel.getKey())).getServers().contains(descriptor) || (serverModel = ((ZooKeeperConnectionModel)this.getModel()).getZooKeeperServerModel(descriptor)) == null) continue;
            try {
                this._ZooKeeperServerModelElementType.getOpenAction().runWithObject((Object)serverModel);
            }
            catch (Exception e) {
                ZooKeeperActivator.reportError(e);
                break;
            }
        }
    }
}

