/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.editors.zookeeperserverform;

import com.fusesource.zk.core.EclipseCoreActivator;
import com.fusesource.zk.core.editors.DataModelFormEditor;
import com.fusesource.zk.core.editors.DataModelFormPage;
import com.fusesource.zk.core.model.DataModel;
import com.fusesource.zk.core.viewers.IElementType;
import com.fusesource.zk.core.widgets.ElementTypeDataModelImageHyperlinkView;
import com.fusesource.zk.jmx.actions.JmxOpenAction;
import com.fusesource.zk.jmx.model.JmxConnectionModel;
import com.fusesource.zk.jmx.viewers.JmxConnectionModelElementType;
import com.fusesource.zk.zookeeper.data.ZooKeeperServer;
import com.fusesource.zk.zookeeper.editors.zookeeperserverform.ZooKeeperServerModelFormEditor;
import com.fusesource.zk.zookeeper.model.ZooKeeperServerModel;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public final class ZooKeeperServerModelFormPage
extends DataModelFormPage<ZooKeeperServerModel> {
    public static final String ID = ZooKeeperServerModelFormPage.class.getName();
    public static final Image IMAGE = EclipseCoreActivator.getManagedImage((String)"IMAGE_KEY_OBJECT_SERVER_ADMIN");
    public static final String TITLE = "Administration";

    public ZooKeeperServerModelFormPage(ZooKeeperServerModelFormEditor editor) {
        super((DataModelFormEditor)editor, ID, TITLE);
        this.setImage(IMAGE);
    }

    protected void createModelFormContent(IManagedForm managedForm, Composite client) {
        FormToolkit toolkit = managedForm.getToolkit();
        Label commandLabel = toolkit.createLabel(client, "Command: ");
        final CCombo commandsCombo = new CCombo(client, 2056);
        String[] stringArray = ZooKeeperServer.COMMANDS;
        int n = ZooKeeperServer.COMMANDS.length;
        int n2 = 0;
        while (n2 < n) {
            String command = stringArray[n2];
            commandsCombo.add(command);
            ++n2;
        }
        commandsCombo.setText("ruok");
        toolkit.adapt((Control)commandsCombo, true, false);
        Button executeButton = toolkit.createButton(client, "Execute", 8);
        executeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZooKeeperServerModelFormPage.this.executeCommand(commandsCombo.getText());
            }
        });
        Label jmxConnectionLabel = null;
        ImageHyperlink jmxConnectionImageHyperlink = null;
        final JmxConnectionModel jmxConnectionModel = ((ZooKeeperServerModel)this.getModel()).getJmxConnectionModel();
        if (jmxConnectionModel != null) {
            jmxConnectionLabel = toolkit.createLabel(client, "JMX Connection: ");
            final JmxConnectionModelElementType jmxConnectionModelElementType = new JmxConnectionModelElementType();
            jmxConnectionImageHyperlink = toolkit.createImageHyperlink(client, 192);
            HyperlinkGroup group = new HyperlinkGroup(jmxConnectionImageHyperlink.getDisplay());
            group.setHyperlinkUnderlineMode(2);
            group.add((Hyperlink)jmxConnectionImageHyperlink);
            jmxConnectionImageHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    JmxOpenAction openAction = jmxConnectionModelElementType.getOpenAction();
                    if (openAction != null) {
                        try {
                            openAction.runWithObject((Object)jmxConnectionModel);
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            });
            ElementTypeDataModelImageHyperlinkView view = new ElementTypeDataModelImageHyperlinkView((DataModel)jmxConnectionModel, jmxConnectionImageHyperlink, (IElementType)jmxConnectionModelElementType);
            view.updateView();
        }
        FormData commandsLabelFormData = new FormData();
        commandsLabelFormData.top = new FormAttachment((Control)commandsCombo, 0, 0x1000000);
        commandsLabelFormData.left = new FormAttachment(0, 0);
        commandLabel.setLayoutData((Object)commandsLabelFormData);
        FormData commandsComboFormData = new FormData();
        commandsComboFormData.top = new FormAttachment(0, 0);
        commandsComboFormData.left = new FormAttachment((Control)commandLabel);
        commandsComboFormData.right = new FormAttachment((Control)executeButton, 0, 16384);
        commandsCombo.setLayoutData((Object)commandsComboFormData);
        FormData executeButtonFormData = new FormData();
        executeButtonFormData.top = new FormAttachment((Control)commandsCombo, 0, 0x1000000);
        executeButtonFormData.right = new FormAttachment(100, 0);
        executeButton.setLayoutData((Object)executeButtonFormData);
        if (jmxConnectionImageHyperlink != null) {
            FormData jmxConnectionLabelFormData = new FormData();
            jmxConnectionLabelFormData.top = new FormAttachment((Control)commandLabel, 10);
            jmxConnectionLabelFormData.left = new FormAttachment(0, 0);
            jmxConnectionLabel.setLayoutData((Object)jmxConnectionLabelFormData);
            FormData jmxConnectionImageHyperlinkFormData = new FormData();
            jmxConnectionImageHyperlinkFormData.top = new FormAttachment((Control)jmxConnectionLabel, 0, 0x1000000);
            jmxConnectionImageHyperlinkFormData.left = new FormAttachment((Control)jmxConnectionLabel);
            jmxConnectionImageHyperlinkFormData.right = new FormAttachment(100, 0);
            jmxConnectionImageHyperlink.setLayoutData((Object)jmxConnectionImageHyperlinkFormData);
        }
    }

    private void executeCommand(String command) {
        ZooKeeperServer server = (ZooKeeperServer)((ZooKeeperServerModel)this.getModel()).getData();
        String result = null;
        if (command.equals("dump")) {
            result = server.dump();
        } else if (command.equals("gettracemask")) {
            result = server.getTraceMask();
        } else if (command.equals("ruok")) {
            result = server.ruok();
        } else if (command.equals("stat")) {
            result = server.stat();
        } else {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Bad command", (String)("Command '" + command + "' not supported."));
            return;
        }
        if (result == null) {
            result = "<Command '" + command + "' returned no result>";
        }
        new CommandResultDialog(command, result).open();
    }

    protected void initFromModelInternal() {
    }

    private class CommandResultDialog
    extends Dialog {
        private final String _Command;
        private final String _Result;

        protected CommandResultDialog(String command, String result) {
            super(ZooKeeperServerModelFormPage.this.getSite().getShell());
            this._Command = command;
            this._Result = result;
            this.setBlockOnOpen(true);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        }

        protected Control createContents(Composite parent) {
            this.getShell().setText(this._Command);
            ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 512);
            scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            scrolledComposite.setExpandHorizontal(true);
            Text text = new Text((Composite)scrolledComposite, 74);
            text.setText(this._Result);
            text.pack();
            scrolledComposite.setContent((Control)text);
            return scrolledComposite;
        }

        protected boolean isResizable() {
            return true;
        }

        protected Point getInitialSize() {
            return new Point(600, 300);
        }
    }
}

