/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.model;

import com.fusesource.zk.core.model.DataModel;
import com.fusesource.zk.core.model.DataModelEvent;
import com.fusesource.zk.core.model.DataModelManager;
import com.fusesource.zk.core.model.IDataModelEventListener;
import com.fusesource.zk.zookeeper.data.Znode;
import com.fusesource.zk.zookeeper.data.ZooKeeperConnection;
import com.fusesource.zk.zookeeper.model.ZooKeeperConnectionModel;
import java.util.List;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public final class ZnodeModel
extends DataModel<ZnodeModel, String, Znode> {
    private boolean _DirtyAcl;
    private boolean _DirtyData;
    private final ExistsWatcher _ExistsWatcher;
    private final GetChildrenWatcher _GetChildrenWatcher;
    private final GetDataWatcher _GetDataWatcher;
    private final ZooKeeperConnectionModel _ZooKeeperConnectionModel;
    private final ZooKeeperConnectionModelEventListener _ZooKeeperConnectionModelEventListener;

    ZnodeModel(String path, ZooKeeperConnectionModel zooKeeperConnectionModel) {
        super((Comparable)((Object)path));
        this._ZooKeeperConnectionModel = zooKeeperConnectionModel;
        this._ExistsWatcher = new ExistsWatcher();
        this._GetChildrenWatcher = new GetChildrenWatcher();
        this._GetDataWatcher = new GetDataWatcher();
        this._ZooKeeperConnectionModelEventListener = new ZooKeeperConnectionModelEventListener();
        this._ZooKeeperConnectionModel.addEventListener(this._ZooKeeperConnectionModelEventListener);
    }

    public List<ZnodeModel> getChildModels() {
        Znode znode = (Znode)this.getData();
        DataModelManager manager = this.getManager();
        if (manager.isDestroyed()) {
            return null;
        }
        return manager.findModels((Object)znode);
    }

    public ZooKeeperConnectionModel getOwnerModel() {
        return this._ZooKeeperConnectionModel;
    }

    public ZnodeModel getParentModel() {
        Znode znode = (Znode)this.getData();
        DataModelManager manager = this.getManager();
        if (manager.isDestroyed()) {
            return null;
        }
        String parentPath = znode.getParentPath();
        if (parentPath == null) {
            return null;
        }
        return (ZnodeModel)manager.getModel((Comparable)((Object)parentPath));
    }

    public boolean isDirtyAcl() {
        return this._DirtyAcl;
    }

    public boolean isDirtyData() {
        return this._DirtyData;
    }

    public void setDirtyAcl(boolean dirtyAcl) {
        this._DirtyAcl = dirtyAcl;
    }

    public void setDirtyData(boolean dirtyData) {
        this._DirtyData = dirtyData;
    }

    protected ZnodeModel getThis() {
        return this;
    }

    protected void hookAfterDestroyed() {
        this._ZooKeeperConnectionModel.removeEventListener(this._ZooKeeperConnectionModelEventListener);
    }

    protected void hookBeforeFirstListenerAdded() {
        this.attachWatchers();
    }

    private void attachWatchers() {
        if (!this.getZooKeeperConnection().isConnected()) {
            return;
        }
        Stat stat = this.updateZnodeStat(this._ExistsWatcher);
        if (stat != null) {
            this.updateZnodeAcl(stat);
            this.updateZnodeData(stat, this._GetDataWatcher);
            this.updateZnodeChildren(this._GetChildrenWatcher);
        }
    }

    private ZooKeeperConnection getZooKeeperConnection() {
        return (ZooKeeperConnection)this._ZooKeeperConnectionModel.getData();
    }

    private void updateZnodeAcl(Stat stat) {
        if (this.isDestroyed()) {
            return;
        }
        Znode znode = (Znode)this.getData();
        ZooKeeperConnection zooKeeperConnection = this.getZooKeeperConnection();
        String path = znode.getPath();
        try {
            List<ACL> acl = zooKeeperConnection.getACL(path, stat);
            znode.setAcl(acl);
            znode.setAclReadable(true);
        }
        catch (Exception exception) {
            znode.setAclReadable(false);
        }
    }

    private void updateZnodeChildren(Watcher watcher) {
        if (this.isDestroyed()) {
            return;
        }
        Znode znode = (Znode)this.getData();
        ZooKeeperConnection zooKeeperConnection = this.getZooKeeperConnection();
        String path = znode.getPath();
        try {
            List<String> children = watcher != null ? zooKeeperConnection.getChildren(path, watcher) : zooKeeperConnection.getChildren(path, false);
            znode.setChildren(children);
            znode.setChildrenReadable(true);
        }
        catch (Exception exception) {
            znode.setChildrenReadable(false);
        }
    }

    private void updateZnodeData(Stat stat, Watcher watcher) {
        if (this.isDestroyed()) {
            return;
        }
        Znode znode = (Znode)this.getData();
        ZooKeeperConnection zooKeeperConnection = this.getZooKeeperConnection();
        String path = znode.getPath();
        try {
            byte[] data = watcher != null ? zooKeeperConnection.getData(path, watcher, stat) : zooKeeperConnection.getData(path, false, stat);
            znode.setData(data);
            znode.setDataReadable(true);
        }
        catch (Exception exception) {
            znode.setDataReadable(false);
        }
    }

    private Stat updateZnodeStat(Watcher watcher) {
        if (this.isDestroyed()) {
            return null;
        }
        Znode znode = (Znode)this.getData();
        String path = znode.getPath();
        ZooKeeperConnection zooKeeperConnection = this.getZooKeeperConnection();
        Stat stat = null;
        try {
            stat = watcher != null ? zooKeeperConnection.exists(path, watcher) : zooKeeperConnection.exists(path, false);
            znode.setStat(stat);
        }
        catch (Exception exception) {}
        if (stat == null) {
            this.destroy();
        }
        return stat;
    }

    private abstract class BaseWatcher
    implements Watcher {
        private BaseWatcher() {
        }

        public void process(WatchedEvent event) {
            if (ZnodeModel.this.isDestroyed()) {
                return;
            }
            if (!ZnodeModel.this.getZooKeeperConnection().isConnected()) {
                return;
            }
            String eventPath = event.getPath();
            Watcher.Event.EventType eventType = event.getType();
            Znode znode = (Znode)ZnodeModel.this.getData();
            String path = znode.getPath();
            if (path.equals(eventPath) && eventType.equals((Object)Watcher.Event.EventType.NodeDeleted)) {
                ZnodeModel.this.destroy();
                return;
            }
            this.processUpdate(event);
            ZnodeModel.this.fireDataModelDataChanged();
        }

        protected abstract void processUpdate(WatchedEvent var1);
    }

    private class ExistsWatcher
    extends BaseWatcher {
        private ExistsWatcher() {
        }

        @Override
        protected void processUpdate(WatchedEvent event) {
            Stat stat = ZnodeModel.this.updateZnodeStat(ZnodeModel.this._ExistsWatcher);
            if (stat != null) {
                ZnodeModel.this.updateZnodeData(stat, null);
                ZnodeModel.this.updateZnodeAcl(stat);
            }
        }
    }

    private class GetChildrenWatcher
    extends BaseWatcher {
        private GetChildrenWatcher() {
        }

        @Override
        protected void processUpdate(WatchedEvent event) {
            ZnodeModel.this.updateZnodeStat(null);
            ZnodeModel.this.updateZnodeChildren(ZnodeModel.this._GetChildrenWatcher);
        }
    }

    private class GetDataWatcher
    extends BaseWatcher {
        private GetDataWatcher() {
        }

        @Override
        protected void processUpdate(WatchedEvent event) {
            Znode znode = (Znode)ZnodeModel.this.getData();
            Stat stat = znode.getStat();
            ZnodeModel.this.updateZnodeData(stat, ZnodeModel.this._GetDataWatcher);
            ZnodeModel.this.updateZnodeAcl(stat);
        }
    }

    private class ZooKeeperConnectionModelEventListener
    implements IDataModelEventListener<ZooKeeperConnectionModel> {
        private ZooKeeperConnectionModelEventListener() {
        }

        public void dataModelDataChanged(DataModelEvent<ZooKeeperConnectionModel> event) {
            this.zooKeeperConnectionModelChanged(event);
        }

        public void dataModelDataRefreshed(DataModelEvent<ZooKeeperConnectionModel> event) {
            this.zooKeeperConnectionModelChanged(event);
        }

        public void dataModelDestroyed(DataModelEvent<ZooKeeperConnectionModel> event) {
        }

        private void zooKeeperConnectionModelChanged(DataModelEvent<ZooKeeperConnectionModel> event) {
            if (ZnodeModel.this.hasListeners()) {
                ZnodeModel.this.attachWatchers();
            }
        }
    }
}

