/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.model;

import com.fusesource.zk.core.model.DataModelSource;
import com.fusesource.zk.core.model.DataModelSourceException;
import com.fusesource.zk.core.model.OperationNotSupportedException;
import com.fusesource.zk.zookeeper.data.Znode;
import com.fusesource.zk.zookeeper.data.ZooKeeperConnection;
import com.fusesource.zk.zookeeper.model.ZnodeModel;
import com.fusesource.zk.zookeeper.model.ZooKeeperConnectionModel;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.ACL;

public class ZnodeModelSource
extends DataModelSource<ZnodeModel, String, Znode> {
    private final ZooKeeperConnectionModel _ZooKeeperConnectionModel;
    private final Set<String> EMPTY_KEYS = Collections.emptySet();

    public ZnodeModelSource(ZooKeeperConnectionModel zooKeeperConnectionModel) {
        this._ZooKeeperConnectionModel = zooKeeperConnectionModel;
    }

    public void deleteData(String path) throws DataModelSourceException {
        ZooKeeperConnection zooKeeperConnection = this.getZooKeeperConnection();
        try {
            Znode znode = this.getData(path);
            zooKeeperConnection.delete(path, znode.getStat().getVersion());
        }
        catch (Exception e) {
            throw new DataModelSourceException((Throwable)e);
        }
    }

    public Set<String> findKeys(Object criteria) throws DataModelSourceException {
        if (!(criteria instanceof Znode)) {
            throw new OperationNotSupportedException();
        }
        Znode znode = (Znode)criteria;
        List<String> childRelativePaths = znode.getChildren();
        if (childRelativePaths == null) {
            return this.EMPTY_KEYS;
        }
        String pathPrefix = znode.getPath();
        if (!pathPrefix.endsWith(Znode.PATH_SEPARATOR_STRING)) {
            pathPrefix = String.valueOf(pathPrefix) + Znode.PATH_SEPARATOR_STRING;
        }
        TreeSet<String> keySet = new TreeSet<String>();
        for (String childRelativePath : childRelativePaths) {
            String childFullPath = String.valueOf(pathPrefix) + childRelativePath;
            keySet.add(childFullPath);
        }
        return keySet;
    }

    public Znode getData(String path) throws DataModelSourceException {
        try {
            return this.getZooKeeperConnection().getZnode(path);
        }
        catch (Exception e) {
            throw new DataModelSourceException((Throwable)e);
        }
    }

    public String insertData(String path, Znode znode) throws DataModelSourceException {
        ZooKeeperConnection zooKeeperConnection = this.getZooKeeperConnection();
        CreateMode createMode = CreateMode.PERSISTENT;
        if (znode.isEphemeral()) {
            createMode = CreateMode.EPHEMERAL;
        }
        if (znode.isSequential()) {
            createMode = CreateMode.PERSISTENT_SEQUENTIAL;
        }
        if (znode.isEphemeral() && znode.isSequential()) {
            createMode = CreateMode.EPHEMERAL_SEQUENTIAL;
        }
        byte[] data = znode.getData();
        List<ACL> acl = znode.getAcl();
        try {
            zooKeeperConnection.create(path, data, acl, createMode);
        }
        catch (Exception e) {
            throw new DataModelSourceException((Throwable)e);
        }
        return path;
    }

    public boolean isDeleteDataSupported() {
        return true;
    }

    public boolean isFindKeysSupported(Object criteria) {
        return criteria instanceof Znode;
    }

    public boolean isInsertDataSupported() {
        return true;
    }

    public boolean isUpdateDataSupported() {
        return true;
    }

    public void updateData(ZnodeModel model) throws DataModelSourceException {
        ZooKeeperConnection zooKeeperConnection = this.getZooKeeperConnection();
        Znode znode = (Znode)model.getData();
        String path = (String)((Object)model.getKey());
        try {
            if (model.isDirtyAcl()) {
                List<ACL> acl = znode.getAcl();
                zooKeeperConnection.setACL(path, acl, -1);
                model.setDirtyAcl(false);
            }
            if (model.isDirtyData()) {
                byte[] data = znode.getData();
                zooKeeperConnection.setData(path, data, -1);
                model.setDirtyData(false);
            }
        }
        catch (Exception e) {
            throw new DataModelSourceException((Throwable)e);
        }
    }

    protected ZnodeModel createModelInternal(String path) {
        return new ZnodeModel(path, this._ZooKeeperConnectionModel);
    }

    private ZooKeeperConnection getZooKeeperConnection() {
        return (ZooKeeperConnection)this._ZooKeeperConnectionModel.getData();
    }
}

