/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.model;

import com.fusesource.rider.commons.ui.actions.IConnectable;
import com.fusesource.zk.core.model.DataModel;
import com.fusesource.zk.core.model.DataModelManager;
import com.fusesource.zk.core.model.IDataModelSource;
import com.fusesource.zk.zookeeper.data.IZooKeeperConnectionEventListener;
import com.fusesource.zk.zookeeper.data.Znode;
import com.fusesource.zk.zookeeper.data.ZooKeeperConnection;
import com.fusesource.zk.zookeeper.data.ZooKeeperConnectionDescriptor;
import com.fusesource.zk.zookeeper.data.ZooKeeperConnectionEvent;
import com.fusesource.zk.zookeeper.data.ZooKeeperServer;
import com.fusesource.zk.zookeeper.data.ZooKeeperServerDescriptor;
import com.fusesource.zk.zookeeper.model.ZnodeModel;
import com.fusesource.zk.zookeeper.model.ZnodeModelSource;
import com.fusesource.zk.zookeeper.model.ZooKeeperServerModel;
import com.fusesource.zk.zookeeper.model.ZooKeeperServerModelSource;
import com.fusesource.zk.zookeeper.model.ZooKeeperServersModelCategory;
import java.io.IOException;
import java.util.List;
import java.util.Set;

public final class ZooKeeperConnectionModel
extends DataModel<ZooKeeperConnectionModel, ZooKeeperConnectionDescriptor, ZooKeeperConnection>
implements IConnectable {
    private DataModelManager<ZnodeModel, String, Znode> _ZnodeModelManager;
    private ZooKeeperConnectionEventListener _ZooKeeperConnectionEventListener;
    private DataModelManager<ZooKeeperServerModel, ZooKeeperServerDescriptor, ZooKeeperServer> _ZooKeeperServerModelManager;
    private final ZooKeeperServersModelCategory _ZooKeeperServersModelCategory = new ZooKeeperServersModelCategory(this);
    private boolean triedConnect;

    ZooKeeperConnectionModel(ZooKeeperConnectionDescriptor descriptor) {
        super((Comparable)((Object)descriptor));
        this._ZooKeeperConnectionEventListener = new ZooKeeperConnectionEventListener();
    }

    public ZnodeModel getRootZnodeModel() {
        return (ZnodeModel)this._ZnodeModelManager.getModel((Comparable)((Object)Znode.ROOT_PATH));
    }

    public Set<ZooKeeperServerDescriptor> getZooKeeperServerDescriptors() {
        return this._ZooKeeperServerModelManager.getKeys();
    }

    public ZooKeeperServerModel getZooKeeperServerModel(ZooKeeperServerDescriptor descriptor) {
        return (ZooKeeperServerModel)this._ZooKeeperServerModelManager.getModel((Comparable)descriptor);
    }

    public List<ZooKeeperServerModel> getZooKeeperServerModels() {
        return this._ZooKeeperServerModelManager.getModels();
    }

    public ZooKeeperServersModelCategory getZooKeeperServersModelCategory() {
        return this._ZooKeeperServersModelCategory;
    }

    public boolean isConnected() {
        ZooKeeperConnection zooKeeperConnection = (ZooKeeperConnection)this.getData();
        return zooKeeperConnection != null && zooKeeperConnection.isConnected();
    }

    public boolean shouldConnect() {
        return !this.isConnected() && !this.triedConnect;
    }

    public void connect() throws Exception {
        ZooKeeperConnection zooKeeperConnection = (ZooKeeperConnection)this.getData();
        if (zooKeeperConnection != null) {
            this.doConnect(zooKeeperConnection);
        }
    }

    public void disconnect() throws Exception {
        ZooKeeperConnection zooKeeperConnection = (ZooKeeperConnection)this.getData();
        if (zooKeeperConnection != null) {
            this.doClose(zooKeeperConnection);
        }
    }

    protected ZooKeeperConnectionModel getThis() {
        return this;
    }

    protected void hookAfterDestroyed() {
        ZooKeeperConnection zooKeeperConnection;
        if (this._ZnodeModelManager != null) {
            this._ZnodeModelManager.destroy();
        }
        if (this._ZooKeeperServerModelManager != null) {
            this._ZooKeeperServerModelManager.destroy();
        }
        if ((zooKeeperConnection = (ZooKeeperConnection)this.getData()) != null) {
            zooKeeperConnection.removeEventListener(this._ZooKeeperConnectionEventListener);
            this.doClose(zooKeeperConnection);
        }
    }

    protected void hookAfterSetData() {
        ZooKeeperConnection zooKeeperConnection = (ZooKeeperConnection)this.getData();
        if (zooKeeperConnection != null) {
            zooKeeperConnection.addEventListener(this._ZooKeeperConnectionEventListener);
            if (this.hasListeners()) {
                this.shouldConnect(zooKeeperConnection);
            }
        }
        if (this._ZooKeeperServerModelManager == null) {
            ZooKeeperServerModelSource zooKeeperServerModelSource = new ZooKeeperServerModelSource(this);
            this._ZooKeeperServerModelManager = new DataModelManager((IDataModelSource)zooKeeperServerModelSource);
        } else {
            this._ZooKeeperServerModelManager.refreshManagedModels();
        }
        if (this._ZnodeModelManager == null) {
            ZnodeModelSource znodeModelSource = new ZnodeModelSource(this);
            this._ZnodeModelManager = new DataModelManager((IDataModelSource)znodeModelSource);
        }
    }

    protected void hookBeforeFirstListenerAdded() {
        super.hookBeforeFirstListenerAdded();
        ZooKeeperConnection zooKeeperConnection = (ZooKeeperConnection)this.getData();
        this.shouldConnect(zooKeeperConnection);
    }

    protected void shouldConnect(ZooKeeperConnection zooKeeperConnection) {
        boolean autoConnect = false;
        if (autoConnect) {
            this.doConnect(zooKeeperConnection);
        }
    }

    protected void doConnect(ZooKeeperConnection zooKeeperConnection) {
        if (!zooKeeperConnection.isConnected()) {
            this.triedConnect = true;
            try {
                zooKeeperConnection.connect();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void doClose(ZooKeeperConnection zooKeeperConnection) {
        if (zooKeeperConnection.isConnected() || this.triedConnect) {
            try {
                try {
                    zooKeeperConnection.close();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    this.triedConnect = false;
                }
            }
            finally {
                this.triedConnect = false;
            }
        }
    }

    protected void hookBeforeSetData() {
        ZooKeeperConnection zooKeeperConnection = (ZooKeeperConnection)this.getData();
        if (zooKeeperConnection != null) {
            this.doClose(zooKeeperConnection);
            zooKeeperConnection.removeEventListener(this._ZooKeeperConnectionEventListener);
        }
    }

    private class ZooKeeperConnectionEventListener
    implements IZooKeeperConnectionEventListener {
        private ZooKeeperConnectionEventListener() {
        }

        @Override
        public void connectionStateChanged(ZooKeeperConnectionEvent event) {
            ZooKeeperConnection zooKeeperConnection = event.getZooKeeperConnection();
            if (zooKeeperConnection.isConnected() && ZooKeeperConnectionModel.this._ZnodeModelManager != null) {
                ZooKeeperConnectionModel.this._ZnodeModelManager.refreshManagedModels();
            }
            ZooKeeperConnectionModel.this.fireDataModelDataChanged();
        }
    }
}

