/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.model;

import com.fusesource.zk.core.model.DataModel;
import com.fusesource.zk.core.model.DataModelManager;
import com.fusesource.zk.core.model.IDataModelSource;
import com.fusesource.zk.core.runtime.ConnectionDescriptorFiles;
import com.fusesource.zk.jmx.data.JmxConnection;
import com.fusesource.zk.jmx.data.JmxConnectionDescriptor;
import com.fusesource.zk.jmx.model.JmxConnectionModel;
import com.fusesource.zk.jmx.model.JmxConnectionModelSource;
import com.fusesource.zk.jmx.runtime.JmxConnectionDescriptorFiles;
import com.fusesource.zk.zookeeper.ZooKeeperActivator;
import com.fusesource.zk.zookeeper.data.ZooKeeperServer;
import com.fusesource.zk.zookeeper.data.ZooKeeperServerDescriptor;
import com.fusesource.zk.zookeeper.model.ZooKeeperConnectionModel;

public final class ZooKeeperServerModel
extends DataModel<ZooKeeperServerModel, ZooKeeperServerDescriptor, ZooKeeperServer> {
    private final DataModelManager<JmxConnectionModel, JmxConnectionDescriptor, JmxConnection> _JmxConnectionModelManager;
    private final ZooKeeperConnectionModel _ZooKeeperConnectionModel;

    ZooKeeperServerModel(ZooKeeperServerDescriptor descriptor, ZooKeeperConnectionModel zooKeeperConnectionModel) {
        super((Comparable)descriptor);
        this._ZooKeeperConnectionModel = zooKeeperConnectionModel;
        JmxConnectionDescriptorFiles jmxConnectionDescriptorFiles = ZooKeeperActivator.getDefault().getZooKeeperConnectionDescriptorFiles().getJmxConnectionDescriptorFiles();
        JmxConnectionModelSource jmxConnectionModelSource = new JmxConnectionModelSource((ConnectionDescriptorFiles)jmxConnectionDescriptorFiles, (Object)this);
        this._JmxConnectionModelManager = new DataModelManager((IDataModelSource)jmxConnectionModelSource);
    }

    public JmxConnectionModel getJmxConnectionModel() {
        ZooKeeperServer zooKeeperServer = (ZooKeeperServer)this.getData();
        JmxConnectionDescriptor jmxConnectionDescriptor = zooKeeperServer.getDescriptor().getJmxConnectionDescriptor();
        if (jmxConnectionDescriptor == null) {
            return null;
        }
        return (JmxConnectionModel)this._JmxConnectionModelManager.getModel((Comparable)jmxConnectionDescriptor);
    }

    public ZooKeeperConnectionModel getOwnerModel() {
        return this._ZooKeeperConnectionModel;
    }

    public ZooKeeperConnectionModel getParentModel() {
        return this.getOwnerModel();
    }

    protected ZooKeeperServerModel getThis() {
        return this;
    }

    protected void hookAfterDestroyed() {
        this._JmxConnectionModelManager.destroy();
    }
}

