/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.runtime;

import com.fusesource.zk.core.data.AbstractConnectionDescriptor;
import com.fusesource.zk.core.runtime.ConnectionDescriptorFiles;
import com.fusesource.zk.core.runtime.IConnectionDescriptorXmlSerializer;
import com.fusesource.zk.jmx.data.JmxConnectionDescriptor;
import com.fusesource.zk.jmx.runtime.JmxConnectionDescriptorFiles;
import com.fusesource.zk.zookeeper.data.AuthInfo;
import com.fusesource.zk.zookeeper.data.Znode;
import com.fusesource.zk.zookeeper.data.ZooKeeperConnectionDescriptor;
import com.fusesource.zk.zookeeper.data.ZooKeeperServerDescriptor;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public final class ZooKeeperConnectionDescriptorFiles
extends ConnectionDescriptorFiles<ZooKeeperConnectionDescriptor> {
    public static final String XML_VERSION_1 = "1";
    public static final String XML_WRITE_VERSION = "1";
    private static final String XML_TAG_AUTH_INFO = "AuthInfo";
    private static final String XML_TAG_AUTH_INFO_AUTH = "Auth";
    private static final String XML_TAG_AUTH_INFO_SCHEME = "Scheme";
    private static final String XML_TAG_AUTH_INFO_TYPE = "Type";
    private static final String XML_TAG_AUTH_INFOS = "AuthInfos";
    private static final String XML_TAG_ROOT_PATH = "RootPath";
    private static final String XML_TAG_SESSION_TIMEOUT = "SessionTimeout";
    private static final String XML_TAG_ZOO_KEEPER_SERVER = "ZooKeeperServer";
    private static final String XML_TAG_ZOO_KEEPER_SERVER_HOST = "Host";
    private static final String XML_TAG_ZOO_KEEPER_SERVER_JMX_CONNECTION = "JmxConnection";
    private static final String XML_TAG_ZOO_KEEPER_SERVER_PORT = "Port";
    private static final String XML_TAG_ZOO_KEEPER_SERVERS = "ZooKeeperServers";
    private final JmxConnectionDescriptorFiles _JmxConnectionDescriptorFiles;

    public ZooKeeperConnectionDescriptorFiles(File directory) {
        super(directory, "1");
        this.addSerializer("1", new Version1Serializer());
        this._JmxConnectionDescriptorFiles = new JmxConnectionDescriptorFiles(new File(directory, "JMX"));
    }

    public boolean delete(ZooKeeperConnectionDescriptor connectionDescriptor) {
        boolean result = super.delete((AbstractConnectionDescriptor)connectionDescriptor);
        if (result) {
            for (ZooKeeperServerDescriptor serverDescriptor : connectionDescriptor.getServers()) {
                JmxConnectionDescriptor jmxConnectionDescriptor = serverDescriptor.getJmxConnectionDescriptor();
                if (jmxConnectionDescriptor == null) continue;
                this._JmxConnectionDescriptorFiles.delete((AbstractConnectionDescriptor)jmxConnectionDescriptor);
            }
        }
        return result;
    }

    public JmxConnectionDescriptorFiles getJmxConnectionDescriptorFiles() {
        return this._JmxConnectionDescriptorFiles;
    }

    private class Version1Serializer
    implements IConnectionDescriptorXmlSerializer<ZooKeeperConnectionDescriptor> {
        private Version1Serializer() {
        }

        public ZooKeeperConnectionDescriptor fromXml(XMLMemento memento) {
            IMemento[] serverMementos;
            String name = memento.getString("Name");
            int sessionTimeout = Integer.parseInt(memento.getString(ZooKeeperConnectionDescriptorFiles.XML_TAG_SESSION_TIMEOUT));
            String rootPath = memento.getString(ZooKeeperConnectionDescriptorFiles.XML_TAG_ROOT_PATH);
            ZooKeeperConnectionDescriptor connectionDescriptor = new ZooKeeperConnectionDescriptor(name, sessionTimeout);
            if (rootPath != null && (rootPath = rootPath.trim()).length() > 0 && !rootPath.equals(Znode.ROOT_PATH)) {
                connectionDescriptor.setRootPath(rootPath);
            }
            IMemento[] iMementoArray = serverMementos = memento.getChild(ZooKeeperConnectionDescriptorFiles.XML_TAG_ZOO_KEEPER_SERVERS).getChildren(ZooKeeperConnectionDescriptorFiles.XML_TAG_ZOO_KEEPER_SERVER);
            int n = serverMementos.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento serverMemento = iMementoArray[n2];
                String host = serverMemento.getString(ZooKeeperConnectionDescriptorFiles.XML_TAG_ZOO_KEEPER_SERVER_HOST);
                int port = Integer.parseInt(serverMemento.getString(ZooKeeperConnectionDescriptorFiles.XML_TAG_ZOO_KEEPER_SERVER_PORT));
                ZooKeeperServerDescriptor severDescriptor = new ZooKeeperServerDescriptor(host, port);
                String jmxConnectionDescriptorName = serverMemento.getString(ZooKeeperConnectionDescriptorFiles.XML_TAG_ZOO_KEEPER_SERVER_JMX_CONNECTION);
                if (jmxConnectionDescriptorName != null) {
                    JmxConnectionDescriptor jmxConnectionDescriptor = (JmxConnectionDescriptor)ZooKeeperConnectionDescriptorFiles.this._JmxConnectionDescriptorFiles.load(jmxConnectionDescriptorName);
                    severDescriptor.setJmxConnectionDescriptor(jmxConnectionDescriptor);
                }
                connectionDescriptor.getServers().add(severDescriptor);
                ++n2;
            }
            IMemento authInfosMemento = memento.getChild(ZooKeeperConnectionDescriptorFiles.XML_TAG_AUTH_INFOS);
            if (authInfosMemento != null) {
                IMemento[] authInfoMementos = authInfosMemento.getChildren(ZooKeeperConnectionDescriptorFiles.XML_TAG_AUTH_INFO);
                ArrayList<AuthInfo> authInfos = new ArrayList<AuthInfo>(authInfoMementos.length);
                IMemento[] iMementoArray2 = authInfoMementos;
                int n3 = authInfoMementos.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemento authInfoMemento = iMementoArray2[n4];
                    String typeName = authInfoMemento.getString(ZooKeeperConnectionDescriptorFiles.XML_TAG_AUTH_INFO_TYPE);
                    String scheme = authInfoMemento.getString(ZooKeeperConnectionDescriptorFiles.XML_TAG_AUTH_INFO_SCHEME);
                    String authString = authInfoMemento.getString(ZooKeeperConnectionDescriptorFiles.XML_TAG_AUTH_INFO_AUTH);
                    AuthInfo authInfo = new AuthInfo(AuthInfo.Type.valueOf(typeName), scheme, authString);
                    authInfos.add(authInfo);
                    ++n4;
                }
                if (authInfos.size() > 0) {
                    connectionDescriptor.setAuthInfos(authInfos);
                }
            }
            return connectionDescriptor;
        }

        public void toXml(ZooKeeperConnectionDescriptor connectionDescriptor, XMLMemento memento) {
            memento.putString(ZooKeeperConnectionDescriptorFiles.XML_TAG_SESSION_TIMEOUT, String.valueOf(connectionDescriptor.getSessionTimeout()));
            String rootPath = connectionDescriptor.getRootPath();
            if (rootPath != null) {
                memento.putString(ZooKeeperConnectionDescriptorFiles.XML_TAG_ROOT_PATH, rootPath);
            }
            IMemento serversMemento = memento.createChild(ZooKeeperConnectionDescriptorFiles.XML_TAG_ZOO_KEEPER_SERVERS);
            for (ZooKeeperServerDescriptor serverDescriptor : connectionDescriptor.getServers()) {
                IMemento serverMemento = serversMemento.createChild(ZooKeeperConnectionDescriptorFiles.XML_TAG_ZOO_KEEPER_SERVER);
                serverMemento.putString(ZooKeeperConnectionDescriptorFiles.XML_TAG_ZOO_KEEPER_SERVER_HOST, serverDescriptor.getHost());
                serverMemento.putString(ZooKeeperConnectionDescriptorFiles.XML_TAG_ZOO_KEEPER_SERVER_PORT, String.valueOf(serverDescriptor.getPort()));
                JmxConnectionDescriptor jmxConnectionDescriptor = serverDescriptor.getJmxConnectionDescriptor();
                if (jmxConnectionDescriptor == null) continue;
                serverMemento.putString(ZooKeeperConnectionDescriptorFiles.XML_TAG_ZOO_KEEPER_SERVER_JMX_CONNECTION, jmxConnectionDescriptor.getName());
                ZooKeeperConnectionDescriptorFiles.this._JmxConnectionDescriptorFiles.save((AbstractConnectionDescriptor)jmxConnectionDescriptor);
            }
            IMemento authInfosMemento = memento.createChild(ZooKeeperConnectionDescriptorFiles.XML_TAG_AUTH_INFOS);
            for (AuthInfo authInfo : connectionDescriptor.getAuthInfos()) {
                IMemento authInfoMemento = authInfosMemento.createChild(ZooKeeperConnectionDescriptorFiles.XML_TAG_AUTH_INFO);
                authInfoMemento.putString(ZooKeeperConnectionDescriptorFiles.XML_TAG_AUTH_INFO_TYPE, authInfo.getType().name());
                authInfoMemento.putString(ZooKeeperConnectionDescriptorFiles.XML_TAG_AUTH_INFO_SCHEME, authInfo.getScheme());
                authInfoMemento.putString(ZooKeeperConnectionDescriptorFiles.XML_TAG_AUTH_INFO_AUTH, authInfo.getAuthString());
            }
        }
    }
}

