/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.viewers;

import com.fusesource.zk.core.viewers.BaseElementType;
import com.fusesource.zk.zookeeper.ZooKeeperActivator;
import com.fusesource.zk.zookeeper.data.AuthInfo;
import java.util.Arrays;
import org.eclipse.swt.graphics.Image;

public class AuthInfoElementType
extends BaseElementType {
    public static final String COLUMN_TITLE_TYPE = "Type";
    public static final String COLUMN_TITLE_SCHEME = "Scheme";
    public static final String COLUMN_TITLE_AUTH = "Auth";
    private static final int[] COLUMN_ALIGNMENTS = new int[]{16384, 16384, 16384};
    private static final String[] COLUMN_TITLES = new String[]{"Type", "Scheme", "Auth"};
    private static final int[] COLUMN_WIDTHS = new int[]{-1, -1, -1};

    public int getChildCount(Object parent) {
        return 0;
    }

    public String getColumnText(Object element, int columnIndex) {
        AuthInfo authInfo = (AuthInfo)element;
        switch (columnIndex) {
            case 0: {
                return authInfo.getType().name();
            }
            case 1: {
                return authInfo.getScheme();
            }
            case 2: {
                AuthInfo.Type type = authInfo.getType();
                String authString = authInfo.getAuthString();
                if (type == AuthInfo.Type.File) {
                    return authString;
                }
                if (type != AuthInfo.Type.Text) break;
                char[] hiddenText = new char[authString.length()];
                Arrays.fill(hiddenText, '*');
                return new String(hiddenText);
            }
        }
        return null;
    }

    public int[] getColumnAlignments() {
        return COLUMN_ALIGNMENTS;
    }

    public String[] getColumnTitles() {
        return COLUMN_TITLES;
    }

    public int[] getColumnWidths() {
        return COLUMN_WIDTHS;
    }

    public Object getChildElement(Object parent, int index) {
        return null;
    }

    public Image getImage(Object element) {
        return ZooKeeperActivator.getManagedImage("IMAGE_KEY_OBJECT_AUTH");
    }

    public Object getParent(Object element) {
        return null;
    }

    public String getText(Object element) {
        AuthInfo authInfo = (AuthInfo)element;
        String text = String.valueOf(authInfo.getScheme()) + ":" + authInfo.getAuthString();
        return text;
    }
}

