/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.viewers;

import com.fusesource.zk.core.actions.BaseAction;
import com.fusesource.zk.core.actions.RefreshAction;
import com.fusesource.zk.zookeeper.ZooKeeperActivator;
import com.fusesource.zk.zookeeper.actions.NewZnodeAction;
import com.fusesource.zk.zookeeper.actions.TableEditAction;
import com.fusesource.zk.zookeeper.actions.TableEditChildrenAction;
import com.fusesource.zk.zookeeper.actions.ZooKeeperDeleteAction;
import com.fusesource.zk.zookeeper.actions.ZooKeeperOpenAction;
import com.fusesource.zk.zookeeper.data.Znode;
import com.fusesource.zk.zookeeper.data.ZooKeeperConnection;
import com.fusesource.zk.zookeeper.model.ZnodeModel;
import com.fusesource.zk.zookeeper.viewers.AbstractZooKeeperDataModelElementType;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.zookeeper.data.Stat;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Image;

public class ZnodeModelElementType
extends AbstractZooKeeperDataModelElementType {
    public static final String COLUMN_TITLE_CONNECTION = "Connection";
    public static final String COLUMN_TITLE_DATA = "Data";
    public static final String COLUMN_TITLE_DATE_CREATED = "Date Created";
    public static final String COLUMN_TITLE_DATE_MODIFIED = "Date Modified";
    public static final String COLUMN_TITLE_PARENT = "Parent";
    public static final String COLUMN_TITLE_PATH = "Path";
    public static final String COLUMN_TITLE_SIZE = "Size";
    public static final String COLUMN_TITLE_VERSION = "Version";
    private static final int[] COLUMN_ALIGNMENTS_DEFAULT = new int[]{16384, 16384, 131072, 131072, 16384, 16384};
    private static final int[] COLUMN_ALIGNMENTS_WITH_PARENT_CONTEXT = new int[]{16384, 16384, 131072, 131072, 16384, 16384, 16384, 16384};
    private static final String[] COLUMN_TITLES_DEFAULT = new String[]{"Path", "Data", "Version", "Size", "Date Modified", "Date Created"};
    private static final String[] COLUMN_TITLES_WITH_PARENT_CONTEXT = new String[]{"Path", "Data", "Version", "Size", "Date Modified", "Date Created", "Parent", "Connection"};
    private static final int[] COLUMN_WIDTHS_DEFAULT = new int[]{-1, 150, -1, -1, -1, -1};
    private static final int[] COLUMN_WIDTHS_WITH_PARENT_CONTEXT = new int[]{-1, 150, -1, -1, -1, -1, -1, -1};
    private NewZnodeAction _NewZnodeAction;
    private final boolean _ParentContextColumnsDisplayed;
    private TableEditAction _TableEditAction;
    private TableEditChildrenAction _TableEditChildrenAction;

    public ZnodeModelElementType() {
        this(false);
    }

    public ZnodeModelElementType(boolean parentContextColumnsDisplayed) {
        this._ParentContextColumnsDisplayed = parentContextColumnsDisplayed;
    }

    @Override
    public void fillContextMenu(IMenuManager manager) {
        RefreshAction refreshAction;
        ZooKeeperDeleteAction deleteAction;
        TableEditChildrenAction tableEditChildrenAction;
        TableEditAction tableEditAction;
        ZooKeeperOpenAction openAction;
        NewZnodeAction newZnodeAction = this.getNewZnodeAction();
        if (newZnodeAction != null && newZnodeAction.isEnabled()) {
            manager.add((IAction)newZnodeAction);
        }
        if ((openAction = this.getOpenAction()) != null && openAction.isEnabled()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)openAction);
        }
        if ((tableEditAction = this.getTableEditAction()) != null && tableEditAction.isEnabled()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)tableEditAction);
        }
        if ((tableEditChildrenAction = this.getTableEditChildrenAction()) != null && tableEditChildrenAction.isEnabled()) {
            manager.add((IAction)tableEditChildrenAction);
        }
        if ((deleteAction = this.getDeleteAction()) != null && deleteAction.isEnabled()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)deleteAction);
        }
        if ((refreshAction = this.getRefreshAction()) != null && refreshAction.isEnabled()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)refreshAction);
        }
    }

    public int getChildCount(Object parent) {
        ZnodeModel model = (ZnodeModel)((Object)parent);
        if (!model.getOwnerModel().isConnected()) {
            return 0;
        }
        List<String> children = ((Znode)model.getData()).getChildren();
        if (children == null) {
            return 0;
        }
        return children.size();
    }

    public Object getChildElement(Object parent, int index) {
        ZnodeModel model = (ZnodeModel)((Object)parent);
        if (!model.getOwnerModel().isConnected()) {
            return null;
        }
        List<ZnodeModel> childModels = model.getChildModels();
        if (childModels != null && index < childModels.size()) {
            return childModels.get(index);
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        List<Object> childModels;
        ZnodeModel model = (ZnodeModel)((Object)parent);
        if (!model.getOwnerModel().isConnected()) {
            childModels = Collections.emptyList();
        } else {
            childModels = model.getChildModels();
            if (childModels == null) {
                childModels = Collections.emptyList();
            }
        }
        return childModels.toArray();
    }

    public int[] getColumnAlignments() {
        if (this.isParentContextColumnsDisplayed()) {
            return COLUMN_ALIGNMENTS_WITH_PARENT_CONTEXT;
        }
        return COLUMN_ALIGNMENTS_DEFAULT;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return super.getColumnImage(element, columnIndex);
        }
        if (columnIndex == 6) {
            ZnodeModel model = (ZnodeModel)((Object)element);
            ZnodeModel parentModel = model.getParentModel();
            return this.getColumnImage((Object)parentModel, 0);
        }
        if (columnIndex == 7) {
            return ZooKeeperActivator.getManagedImage("IMAGE_KEY_OBJECT_ZOO_KEEPER_CONNECTION");
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        ZnodeModel model = (ZnodeModel)((Object)element);
        Znode znode = (Znode)model.getData();
        Stat stat = znode.getStat();
        switch (columnIndex) {
            case 0: {
                return znode.getRelativePath();
            }
            case 1: {
                return znode.getDataAsString();
            }
            case 2: {
                return String.valueOf(stat.getVersion());
            }
            case 3: {
                int dataLength = stat.getDataLength();
                String size = dataLength > 1024 ? String.valueOf(String.valueOf(dataLength / 1024)) + " KB" : String.valueOf(String.valueOf(dataLength)) + " bytes";
                return size;
            }
            case 4: {
                return DEFAULT_DATE_FORMAT.format(new Date(stat.getMtime()));
            }
            case 5: {
                return DEFAULT_DATE_FORMAT.format(new Date(stat.getCtime()));
            }
            case 6: {
                return ((Znode)model.getData()).getParentPath();
            }
            case 7: {
                return ((ZooKeeperConnection)model.getOwnerModel().getData()).getDescriptor().getName();
            }
        }
        return null;
    }

    public String[] getColumnTitles() {
        if (this.isParentContextColumnsDisplayed()) {
            return COLUMN_TITLES_WITH_PARENT_CONTEXT;
        }
        return COLUMN_TITLES_DEFAULT;
    }

    public int[] getColumnWidths() {
        if (this.isParentContextColumnsDisplayed()) {
            return COLUMN_WIDTHS_WITH_PARENT_CONTEXT;
        }
        return COLUMN_WIDTHS_DEFAULT;
    }

    public Image getImage(Object element) {
        ZnodeModel model = (ZnodeModel)((Object)element);
        if (model == null) {
            return null;
        }
        return ZooKeeperActivator.getZnodeSmallImage((Znode)model.getData());
    }

    public Image getLargeImage(Object element) {
        ZnodeModel model = (ZnodeModel)((Object)element);
        if (model == null) {
            return null;
        }
        return ZooKeeperActivator.getZnodeLargeImage((Znode)model.getData());
    }

    public final NewZnodeAction getNewZnodeAction() {
        return this._NewZnodeAction;
    }

    public Object getParent(Object element) {
        ZnodeModel model = (ZnodeModel)((Object)element);
        if (!model.getOwnerModel().isConnected() && !((String)((Object)model.getKey())).equals(Znode.ROOT_PATH)) {
            return null;
        }
        return super.getParent(element);
    }

    public final TableEditAction getTableEditAction() {
        return this._TableEditAction;
    }

    public final TableEditChildrenAction getTableEditChildrenAction() {
        return this._TableEditChildrenAction;
    }

    public String getText(Object element) {
        ZnodeModel model = (ZnodeModel)((Object)element);
        return ((Znode)model.getData()).getRelativePath();
    }

    public String getToolTipText(Object element) {
        ZnodeModel model = (ZnodeModel)((Object)element);
        return ((Znode)model.getData()).getPath();
    }

    public boolean isParentContextColumnsDisplayed() {
        return this._ParentContextColumnsDisplayed;
    }

    @Override
    protected List<BaseAction> createActions() {
        List<BaseAction> tableActions = super.createActions();
        this._NewZnodeAction = new NewZnodeAction(BaseAction.InputType.SINGLE_STRUCTURED_SELECTION);
        tableActions.add((BaseAction)this._NewZnodeAction);
        this._TableEditAction = new TableEditAction();
        tableActions.add(this._TableEditAction);
        this._TableEditChildrenAction = new TableEditChildrenAction();
        tableActions.add(this._TableEditChildrenAction);
        return tableActions;
    }
}

