/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.viewers;

import com.fusesource.zk.zookeeper.ZooKeeperActivator;
import com.fusesource.zk.zookeeper.data.ZooKeeperConnection;
import com.fusesource.zk.zookeeper.data.ZooKeeperConnectionDescriptor;
import com.fusesource.zk.zookeeper.model.ZooKeeperConnectionModel;
import com.fusesource.zk.zookeeper.viewers.AbstractZooKeeperDataModelElementType;
import org.eclipse.swt.graphics.Image;

public class ZooKeeperConnectionModelElementType
extends AbstractZooKeeperDataModelElementType {
    public static final String PROPERTY_NAME_CONNECT_STRING = "Connect String";
    public static final String PROPERTY_NAME_NAME = "Name";
    public static final String PROPERTY_NAME_ROOT_PATH = "Root Path";
    public static final String PROPERTY_NAME_SESSION_ID = "Session Id";
    public static final String PROPERTY_NAME_SESSION_TIMEOUT = "Session Timeout";
    public static final String PROPERTY_NAME_STATE = "State";

    public int getChildCount(Object parent) {
        ZooKeeperConnectionModel model = (ZooKeeperConnectionModel)((Object)parent);
        if (!model.isConnected()) {
            return 1;
        }
        return 2;
    }

    public Object getChildElement(Object parent, int index) {
        ZooKeeperConnectionModel model = (ZooKeeperConnectionModel)((Object)parent);
        if (index == 0) {
            return model.getZooKeeperServersModelCategory();
        }
        if (index == 1 && model.isConnected()) {
            return model.getRootZnodeModel();
        }
        return null;
    }

    public Image getImage(Object element) {
        ZooKeeperConnectionModel model = (ZooKeeperConnectionModel)((Object)element);
        if (model != null && !model.isConnected()) {
            return ZooKeeperActivator.getManagedImage("IMAGE_KEY_OBJECT_ZOO_KEEPER_CONNECTION_NOT_CONNECTED");
        }
        return ZooKeeperActivator.getManagedImage("IMAGE_KEY_OBJECT_ZOO_KEEPER_CONNECTION");
    }

    public Image getLargeImage(Object element) {
        ZooKeeperConnectionModel model = (ZooKeeperConnectionModel)((Object)element);
        if (model != null && !model.isConnected()) {
            return ZooKeeperActivator.getManagedImage("IMAGE_KEY_OBJECT_ZOO_KEEPER_CONNECTION_NOT_CONNECTED_LARGE");
        }
        return ZooKeeperActivator.getManagedImage("IMAGE_KEY_OBJECT_ZOO_KEEPER_CONNECTION_LARGE");
    }

    public String getText(Object element) {
        ZooKeeperConnectionModel model = (ZooKeeperConnectionModel)((Object)element);
        return ((ZooKeeperConnection)model.getData()).getDescriptor().getName();
    }

    public String getToolTipText(Object element) {
        ZooKeeperConnectionModel model = (ZooKeeperConnectionModel)((Object)element);
        ZooKeeperConnectionDescriptor descriptor = ((ZooKeeperConnection)model.getData()).getDescriptor();
        return String.valueOf(this.getText(element)) + " [" + descriptor.getConnectString() + "]";
    }
}

