/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.viewers;

import com.fusesource.zk.core.EclipseCoreActivator;
import com.fusesource.zk.core.viewers.BaseElementType;
import com.fusesource.zk.jmx.data.JmxConnectionDescriptor;
import com.fusesource.zk.zookeeper.data.ZooKeeperServerDescriptor;
import org.eclipse.swt.graphics.Image;

public class ZooKeeperServerDescriptorElementType
extends BaseElementType {
    public static final String COLUMN_TITLE_HOST = "Host";
    public static final String COLUMN_TITLE_PORT = "Port";
    public static final String COLUMN_TITLE_JMX_URL = "JMX URL";
    private static final int[] COLUMN_ALIGNMENTS = new int[]{16384, 131072, 16384};
    private static final String[] COLUMN_TITLES = new String[]{"Host", "Port", "JMX URL"};
    private static final int[] COLUMN_WIDTHS = new int[]{-1, 50, -1};

    public String getColumnText(Object element, int columnIndex) {
        ZooKeeperServerDescriptor server = (ZooKeeperServerDescriptor)element;
        switch (columnIndex) {
            case 0: {
                return server.getHost();
            }
            case 1: {
                return String.valueOf(server.getPort());
            }
            case 2: {
                JmxConnectionDescriptor jmxConnectionDescriptor = server.getJmxConnectionDescriptor();
                if (jmxConnectionDescriptor == null) {
                    return "";
                }
                return String.valueOf(jmxConnectionDescriptor.getJmxServiceUrl());
            }
        }
        return null;
    }

    public int[] getColumnAlignments() {
        return COLUMN_ALIGNMENTS;
    }

    public String[] getColumnTitles() {
        return COLUMN_TITLES;
    }

    public int[] getColumnWidths() {
        return COLUMN_WIDTHS;
    }

    public Image getImage(Object element) {
        return EclipseCoreActivator.getManagedImage((String)"IMAGE_KEY_OBJECT_SERVER");
    }

    public String getText(Object element) {
        ZooKeeperServerDescriptor server = (ZooKeeperServerDescriptor)element;
        return String.valueOf(server.getHost()) + ":" + server.getPort();
    }
}

