/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.views.explorer;

import com.fusesource.rider.commons.ui.Selections;
import com.fusesource.rider.commons.ui.actions.ConnectDisconnectAction;
import com.fusesource.zk.core.actions.BaseAction;
import com.fusesource.zk.core.actions.RefreshAction;
import com.fusesource.zk.core.model.DataModelManager;
import com.fusesource.zk.core.viewers.DataModelManagerElementType;
import com.fusesource.zk.core.viewers.ElementTypes;
import com.fusesource.zk.core.viewers.IElementType;
import com.fusesource.zk.core.viewers.ViewerFactory;
import com.fusesource.zk.jmx.model.DomainModel;
import com.fusesource.zk.jmx.model.JmxConnectionModel;
import com.fusesource.zk.jmx.model.MBeanAttributeModel;
import com.fusesource.zk.jmx.model.MBeanAttributesModelCategory;
import com.fusesource.zk.jmx.model.MBeanModel;
import com.fusesource.zk.jmx.model.MBeanOperationModel;
import com.fusesource.zk.jmx.model.MBeanOperationsModelCategory;
import com.fusesource.zk.jmx.model.ObjectNameKeyValueModel;
import com.fusesource.zk.jmx.viewers.DomainModelElementType;
import com.fusesource.zk.jmx.viewers.JmxConnectionModelElementType;
import com.fusesource.zk.jmx.viewers.MBeanAttributeModelElementType;
import com.fusesource.zk.jmx.viewers.MBeanAttributesModelCategoryElementType;
import com.fusesource.zk.jmx.viewers.MBeanModelElementType;
import com.fusesource.zk.jmx.viewers.MBeanOperationModelElementType;
import com.fusesource.zk.jmx.viewers.MBeanOperationsModelCategoryElementType;
import com.fusesource.zk.jmx.viewers.ObjectNameKeyValueModelElementType;
import com.fusesource.zk.zookeeper.ZooKeeperActivator;
import com.fusesource.zk.zookeeper.actions.NewZnodeAction;
import com.fusesource.zk.zookeeper.actions.NewZooKeeperConnectionAction;
import com.fusesource.zk.zookeeper.actions.TableEditAction;
import com.fusesource.zk.zookeeper.actions.TableEditChildrenAction;
import com.fusesource.zk.zookeeper.actions.ZooKeeperDeleteAction;
import com.fusesource.zk.zookeeper.actions.ZooKeeperOpenAction;
import com.fusesource.zk.zookeeper.data.ZooKeeperConnection;
import com.fusesource.zk.zookeeper.data.ZooKeeperConnectionDescriptor;
import com.fusesource.zk.zookeeper.model.ZnodeModel;
import com.fusesource.zk.zookeeper.model.ZooKeeperConnectionModel;
import com.fusesource.zk.zookeeper.model.ZooKeeperServerModel;
import com.fusesource.zk.zookeeper.model.ZooKeeperServersModelCategory;
import com.fusesource.zk.zookeeper.viewers.ZnodeModelElementType;
import com.fusesource.zk.zookeeper.viewers.ZooKeeperConnectionModelElementType;
import com.fusesource.zk.zookeeper.viewers.ZooKeeperServerModelElementType;
import com.fusesource.zk.zookeeper.viewers.ZooKeeperServersModelCategoryElementType;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class ZooKeeperExplorerView
extends ViewPart {
    public static final String ID = String.valueOf(ZooKeeperExplorerView.class.getName());
    private ZooKeeperDeleteAction _DeleteAction;
    private NewZnodeAction _NewZnodeAction;
    private NewZooKeeperConnectionAction _NewZooKeeperConnectionAction;
    private ZooKeeperOpenAction _OpenAction;
    private RefreshAction _RefreshAction;
    private TableEditAction _TableEditAction;
    private TableEditChildrenAction _TableEditChildrenAction;
    private ConnectDisconnectAction connectAction;
    private TreeViewer _TreeViewer;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        ZooKeeperActivator plugin = ZooKeeperActivator.getDefault();
        plugin.getZooKeeperConnectionModelManager().getModels();
    }

    public void createPartControl(Composite parent) {
        DataModelManager<ZooKeeperConnectionModel, ZooKeeperConnectionDescriptor, ZooKeeperConnection> zooKeeperConnectionModelManager = ZooKeeperActivator.getDefault().getZooKeeperConnectionModelManager();
        ElementTypes elementTypes = new ElementTypes();
        elementTypes.add(zooKeeperConnectionModelManager.getClass(), (IElementType)new DataModelManagerElementType());
        elementTypes.add(ZooKeeperConnectionModel.class, (IElementType)new ZooKeeperConnectionModelElementType());
        elementTypes.add(ZooKeeperServersModelCategory.class, (IElementType)new ZooKeeperServersModelCategoryElementType());
        elementTypes.add(ZooKeeperServerModel.class, (IElementType)new ZooKeeperServerModelElementType());
        elementTypes.add(ZnodeModel.class, (IElementType)new ZnodeModelElementType());
        elementTypes.add(JmxConnectionModel.class, (IElementType)new JmxConnectionModelElementType());
        elementTypes.add(DomainModel.class, (IElementType)new DomainModelElementType());
        elementTypes.add(ObjectNameKeyValueModel.class, (IElementType)new ObjectNameKeyValueModelElementType());
        elementTypes.add(MBeanModel.class, (IElementType)new MBeanModelElementType());
        elementTypes.add(MBeanAttributesModelCategory.class, (IElementType)new MBeanAttributesModelCategoryElementType());
        elementTypes.add(MBeanAttributeModel.class, (IElementType)new MBeanAttributeModelElementType());
        elementTypes.add(MBeanOperationsModelCategory.class, (IElementType)new MBeanOperationsModelCategoryElementType());
        elementTypes.add(MBeanOperationModel.class, (IElementType)new MBeanOperationModelElementType());
        this._TreeViewer = ViewerFactory.createDataModelTreeViewer((Composite)parent, (int)268436226, (ElementTypes)elementTypes, zooKeeperConnectionModelManager);
        this._TreeViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ZooKeeperExplorerView.this.getSite().getWorkbenchWindow().getActivePage().activate((IWorkbenchPart)ZooKeeperExplorerView.this);
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this._TreeViewer);
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
    }

    public void setFocus() {
        this._TreeViewer.getControl().setFocus();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillContextMenu(IMenuManager manager) {
        Object firstSelection = Selections.getFirstSelection((Viewer)this._TreeViewer);
        IStructuredSelection structuredSelection = (IStructuredSelection)this._TreeViewer.getSelection();
        boolean emptySelection = false;
        boolean znodeSelected = false;
        if (structuredSelection != null && !structuredSelection.isEmpty()) {
            for (Object selectedObject : structuredSelection) {
                if (!(selectedObject instanceof ZnodeModel)) continue;
                znodeSelected = true;
                break;
            }
        } else {
            emptySelection = true;
        }
        if (this.connectAction.isEnabled()) {
            this.connectAction.refresh();
            manager.add((IAction)this.connectAction);
        }
        if (firstSelection == null) {
            manager.add((IAction)this._NewZooKeeperConnectionAction);
        }
        if (emptySelection) {
            return;
        }
        if (znodeSelected) {
            manager.add((IAction)this._NewZnodeAction);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this._OpenAction);
        manager.add((IContributionItem)new Separator());
        if (znodeSelected) {
            manager.add((IAction)this._TableEditAction);
            manager.add((IAction)this._TableEditChildrenAction);
            manager.add((IContributionItem)new Separator());
        }
        if (this._DeleteAction.isEnabled()) {
            manager.add((IAction)this._DeleteAction);
            manager.add((IContributionItem)new Separator());
        }
        manager.add((IAction)this._RefreshAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this._NewZooKeeperConnectionAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this._NewZooKeeperConnectionAction);
        manager.add((IAction)this._NewZnodeAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this._TableEditAction);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ZooKeeperExplorerView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this._TreeViewer.getControl());
        this._TreeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this._TreeViewer);
    }

    private void makeActions() {
        this.connectAction = new ConnectDisconnectAction((StructuredViewer)this._TreeViewer);
        this._DeleteAction = new ZooKeeperDeleteAction();
        this._DeleteAction.setSelectionProvider((ISelectionProvider)this._TreeViewer);
        this._TableEditChildrenAction = new TableEditChildrenAction();
        this._TableEditChildrenAction.setSelectionProvider((ISelectionProvider)this._TreeViewer);
        this._TableEditAction = new TableEditAction();
        this._TableEditAction.setSelectionProvider((ISelectionProvider)this._TreeViewer);
        this._NewZnodeAction = new NewZnodeAction(BaseAction.InputType.SINGLE_STRUCTURED_SELECTION);
        this._NewZnodeAction.setSelectionProvider((ISelectionProvider)this._TreeViewer);
        this._NewZooKeeperConnectionAction = new NewZooKeeperConnectionAction();
        this._NewZooKeeperConnectionAction.setSelectionProvider((ISelectionProvider)this._TreeViewer);
        this._OpenAction = new ZooKeeperOpenAction();
        this._OpenAction.setSelectionProvider((ISelectionProvider)this._TreeViewer);
        this._RefreshAction = new RefreshAction(BaseAction.InputType.STRUCTURED_SELECTION);
        this._RefreshAction.setSelectionProvider((ISelectionProvider)this._TreeViewer);
    }
}

