/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.widgets;

import com.fusesource.zk.core.viewers.CollectionElementType;
import com.fusesource.zk.core.viewers.IElementType;
import com.fusesource.zk.core.viewers.ViewerFactory;
import com.fusesource.zk.zookeeper.widgets.TableOrchestrationComposite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public abstract class TableViewerOrchestrationComposite<E>
extends TableOrchestrationComposite {
    private final Set<E> _Elements;
    private TableViewer _TableViewer;
    private final Class<?> _ElementClass;
    private final IElementType _ElementType;

    public TableViewerOrchestrationComposite(Composite parent, int style, Class<?> elementClass, IElementType elementType) {
        super(parent, style);
        this._ElementClass = elementClass;
        this._ElementType = elementType;
        this._Elements = new LinkedHashSet();
    }

    public final List<E> getElementList() {
        return new ArrayList<E>(this._Elements);
    }

    public final Set<E> getElementSet() {
        return new LinkedHashSet<E>(this._Elements);
    }

    public final TableViewer getTableViewer() {
        return this._TableViewer;
    }

    @Override
    public void init() {
        IElementType elementType = this.getElementType();
        Table table = this.getTable();
        this._TableViewer = ViewerFactory.createTableViewer((Table)table, this.getElementClass(), (IElementType)elementType, this._Elements, (IElementType)new CollectionElementType(), null);
        Button addButton = this.getAddButton();
        final Button removeButton = this.getRemoveButton();
        removeButton.setEnabled(false);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object element = TableViewerOrchestrationComposite.this.addElement();
                if (element != null) {
                    TableViewerOrchestrationComposite.this._Elements.add(element);
                    TableViewerOrchestrationComposite.this.elementsChanged();
                }
            }
        });
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)TableViewerOrchestrationComposite.this._TableViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                TableViewerOrchestrationComposite.this._Elements.remove(selection.getFirstElement());
                TableViewerOrchestrationComposite.this.elementsChanged();
            }
        });
        this._TableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)TableViewerOrchestrationComposite.this._TableViewer.getSelection();
                removeButton.setEnabled(!selection.isEmpty());
            }
        });
    }

    public final Class<?> getElementClass() {
        return this._ElementClass;
    }

    public final IElementType getElementType() {
        return this._ElementType;
    }

    public void setElements(Collection<E> elements) {
        this._Elements.clear();
        this._Elements.addAll(elements);
        this.elementsChanged();
    }

    protected abstract E addElement();

    private void elementsChanged() {
        TableViewer tableViewer = this.getTableViewer();
        tableViewer.refresh();
        IElementType elementType = this.getElementType();
        elementType.packTable(this.getTable());
        this.layout(true);
        this.fireOrchestrationChange();
    }
}

