/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.widgets;

import com.fusesource.zk.core.dialogs.GridDialog;
import com.fusesource.zk.core.widgets.grid.GridComposite;
import com.fusesource.zk.core.widgets.grid.GridTextInput;
import com.fusesource.zk.zookeeper.data.Znode;
import com.fusesource.zk.zookeeper.widgets.TableOrchestrationComposite;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ZnodeAclComposite
extends TableOrchestrationComposite {
    public static final String ID_ANYONE = ZooDefs.Ids.ANYONE_ID_UNSAFE.getId();
    public static final String ID_AUTH = ZooDefs.Ids.AUTH_IDS.getId();
    public static final int[] PERMS = new int[]{31, 16, 4, 8, 1, 2};
    public static final String SCHEME_AUTH = ZooDefs.Ids.AUTH_IDS.getScheme();
    public static final String SCHEME_DIGEST = "digest";
    public static final String SCHEME_IP = "ip";
    public static final String SCHEME_WORLD = ZooDefs.Ids.ANYONE_ID_UNSAFE.getScheme();
    public static final String[] SCHEMES = new String[]{SCHEME_WORLD, SCHEME_AUTH, "digest", "ip"};
    public static final int TABLE_COLUMN_ID = 1;
    public static final int TABLE_COLUMN_SCHEME = 0;
    public static final String[] TABLE_COLUMN_TITLES = new String[]{"Scheme", "Id", "ALL", "ADMIN", "CREATE", "DELETE", "READ", "WRITE"};
    public static final int[] TABLE_COLUMN_WIDTHS = new int[]{100, 150, -1, -1, -1, -1, -1, -1};
    private static final String LOCAL_IP_ADDRESS;
    private TableEditor _IdTableEditor;
    private TableEditor _SchemeTableEditor;
    private Button _SetIdButton;

    static {
        InetAddress address = null;
        try {
            address = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {}
        String ipString = null;
        if (address != null) {
            ipString = address.getHostAddress();
        }
        LOCAL_IP_ADDRESS = ipString;
    }

    public static int getPermissionColumnIndex(int zooDefPerm) {
        switch (zooDefPerm) {
            case 31: {
                return 2;
            }
            case 16: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 8: {
                return 5;
            }
            case 1: {
                return 6;
            }
            case 2: {
                return 7;
            }
        }
        return -1;
    }

    private static String base64Encode(byte[] b) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < b.length) {
            int pad = 0;
            int v = (b[i++] & 0xFF) << 16;
            if (i < b.length) {
                v |= (b[i++] & 0xFF) << 8;
            } else {
                ++pad;
            }
            if (i < b.length) {
                v |= b[i++] & 0xFF;
            } else {
                ++pad;
            }
            sb.append(ZnodeAclComposite.encode(v >> 18));
            sb.append(ZnodeAclComposite.encode(v >> 12));
            if (pad < 2) {
                sb.append(ZnodeAclComposite.encode(v >> 6));
            } else {
                sb.append('=');
            }
            if (pad < 1) {
                sb.append(ZnodeAclComposite.encode(v));
                continue;
            }
            sb.append('=');
        }
        return sb.toString();
    }

    private static char encode(int i) {
        if ((i &= 0x3F) < 26) {
            return (char)(65 + i);
        }
        if (i < 52) {
            return (char)(97 + i - 26);
        }
        if (i < 62) {
            return (char)(48 + i - 52);
        }
        return i == 62 ? (char)'+' : '/';
    }

    private static String generateDigest(String idPassword) {
        String[] parts = idPassword.split(":", 2);
        try {
            byte[] digest = MessageDigest.getInstance("SHA1").digest(idPassword.getBytes());
            return String.valueOf(parts[0]) + ":" + ZnodeAclComposite.base64Encode(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return idPassword;
        }
    }

    public ZnodeAclComposite(Composite parent, int style) {
        super(parent, style);
    }

    public TableItem addAclTableItem(ACL acl) {
        Table table = this.getTable();
        final TableItem item = new TableItem(table, 0);
        item.setData("ACL", (Object)acl);
        Id id = acl.getId();
        int aclPerms = acl.getPerms();
        boolean hasAll = (aclPerms & 0x1F) == 31;
        item.setText(0, id.getScheme());
        item.setText(1, id.getId());
        int[] nArray = PERMS;
        int n = PERMS.length;
        int n2 = 0;
        while (n2 < n) {
            final int perm = nArray[n2];
            int permColumnIndex = ZnodeAclComposite.getPermissionColumnIndex(perm);
            TableEditor permCheckBoxTableEditor = new TableEditor(table);
            this.setItemPermTableEditor(item, perm, permCheckBoxTableEditor);
            final Button permCheckBox = new Button((Composite)table, 32);
            boolean hasPerm = (aclPerms & perm) == perm;
            permCheckBox.setSelection(hasPerm);
            permCheckBox.setEnabled(!hasAll || hasAll && perm == 31);
            permCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (perm == 31) {
                        int[] nArray = PERMS;
                        int n = PERMS.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int subPerm = nArray[n2];
                            if (subPerm != 31) {
                                Button subPermCheckBox = ZnodeAclComposite.this.getItemPermCheckBox(item, subPerm);
                                boolean allIsSelected = permCheckBox.getSelection();
                                if (allIsSelected) {
                                    subPermCheckBox.setSelection(true);
                                }
                                subPermCheckBox.setEnabled(!allIsSelected);
                            }
                            ++n2;
                        }
                    }
                    ZnodeAclComposite.this.fireOrchestrationChange();
                }
            });
            permCheckBox.pack();
            permCheckBoxTableEditor.minimumWidth = permCheckBox.getSize().x;
            permCheckBoxTableEditor.horizontalAlignment = 0x1000000;
            permCheckBoxTableEditor.setEditor((Control)permCheckBox, item, permColumnIndex);
            ++n2;
        }
        return item;
    }

    public Button getSetIdButton() {
        return this._SetIdButton;
    }

    public List<ACL> getZnodeAclFromTable() {
        Table table = this.getTable();
        TableItem[] items = table.getItems();
        HashSet<ACL> aclSet = new HashSet<ACL>(items.length);
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            int perms = this.getItemPerms(item);
            Id id = this.getItemId(item);
            ACL acl = new ACL(perms, id);
            aclSet.add(acl);
            ++n2;
        }
        return new ArrayList<ACL>(aclSet);
    }

    @Override
    public void init() {
        Table table = this.getTable();
        this._SchemeTableEditor = new TableEditor(table);
        this._SchemeTableEditor.horizontalAlignment = 16384;
        this._SchemeTableEditor.grabHorizontal = true;
        this._IdTableEditor = new TableEditor(table);
        this._IdTableEditor.horizontalAlignment = 16384;
        this._IdTableEditor.grabHorizontal = true;
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZnodeAclComposite.this.tableSelectionChanged((TableItem)e.item);
            }
        });
        Button addButton = this.getAddButton();
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZnodeAclComposite.this.addNewItem();
            }
        });
        Button removeButton = this.getRemoveButton();
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZnodeAclComposite.this.removeSelectedItems();
            }
        });
        Button setIdButton = this.getSetIdButton();
        setIdButton.setEnabled(false);
        setIdButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZnodeAclComposite.this.setId();
            }
        });
    }

    public void initTableItemsFromZnode(Znode znode) {
        Table table = this.getTable();
        this.removeItems(table.getItems());
        List<ACL> aclList = znode.getAcl();
        if (aclList == null || aclList.isEmpty()) {
            return;
        }
        for (ACL acl : aclList) {
            this.addAclTableItem(acl);
        }
    }

    public void setSetIdButton(Button setIdButton) {
        this._SetIdButton = setIdButton;
    }

    private void addNewItem() {
        ACL acl = new ACL();
        acl.setId(ZooDefs.Ids.ANYONE_ID_UNSAFE);
        acl.setPerms(31);
        TableItem newItem = this.addAclTableItem(acl);
        Table table = this.getTable();
        table.setSelection(newItem);
        this.tableSelectionChanged(newItem);
        this.fireOrchestrationChange();
    }

    private void fixLayout() {
        Table table = this.getTable();
        table.pack();
        this.layout(true);
        int[] columnWidths = TABLE_COLUMN_WIDTHS;
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            if (columnWidths == null) {
                columns[i].pack();
            } else {
                int columnWidth = columnWidths[i];
                if (columnWidth == -1) {
                    columns[i].pack();
                } else {
                    columns[i].setWidth(columnWidth);
                }
            }
            ++i;
        }
    }

    private String getIpId() {
        String[] parts;
        String ipId = "";
        if (LOCAL_IP_ADDRESS != null && (parts = LOCAL_IP_ADDRESS.split("\\.", -1)).length == 4) {
            ipId = String.valueOf(parts[0]) + "." + parts[1] + ".0.0";
        }
        return ipId;
    }

    private void tableSelectionChanged(TableItem item) {
        Button setIdButton = this.getSetIdButton();
        setIdButton.setEnabled(SCHEME_DIGEST.equals(item.getText(0)));
        Button removeButton = this.getRemoveButton();
        removeButton.setEnabled(item != null);
        this.initSchemeTableEditor(item);
        this.initIdTableEditor(item);
        Control idEditor = this._IdTableEditor.getEditor();
        if (idEditor != null && !idEditor.isDisposed()) {
            idEditor.setFocus();
        }
    }

    private Id getItemId(TableItem item) {
        String scheme = item.getText(0).trim();
        String id = item.getText(1);
        Id itemId = new Id(scheme, id);
        return itemId;
    }

    private Button getItemPermCheckBox(TableItem item, int zooDefPerm) {
        return (Button)this.getItemPermTableEditor(item, zooDefPerm).getEditor();
    }

    private int getItemPerms(TableItem item) {
        int perms = 0;
        Button allCheckBox = this.getItemPermCheckBox(item, 31);
        if (allCheckBox.getSelection()) {
            perms = 31;
        } else {
            int[] nArray = PERMS;
            int n = PERMS.length;
            int n2 = 0;
            while (n2 < n) {
                int perm = nArray[n2];
                Button permCheckBox = this.getItemPermCheckBox(item, perm);
                if (permCheckBox.getSelection()) {
                    perms |= perm;
                }
                ++n2;
            }
        }
        return perms;
    }

    private TableEditor getItemPermTableEditor(TableItem item, int zooDefPerm) {
        return (TableEditor)item.getData(String.valueOf(zooDefPerm));
    }

    private void initIdTableEditor(TableItem item) {
        Control oldEditor = this._IdTableEditor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
        if (item == null) {
            return;
        }
        Table table = this.getTable();
        Text newEditor = new Text((Composite)table, 4);
        newEditor.setText(item.getText(1));
        newEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text editor = (Text)ZnodeAclComposite.this._IdTableEditor.getEditor();
                ZnodeAclComposite.this._IdTableEditor.getItem().setText(1, editor.getText());
                ZnodeAclComposite.this.fireOrchestrationChange();
            }
        });
        this._IdTableEditor.setEditor((Control)newEditor, item, 1);
    }

    private void initSchemeTableEditor(TableItem item) {
        Control oldEditor = this._SchemeTableEditor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
        if (item == null) {
            return;
        }
        Table table = this.getTable();
        CCombo newEditor = new CCombo((Composite)table, 0x800000);
        String[] stringArray = SCHEMES;
        int n = SCHEMES.length;
        int n2 = 0;
        while (n2 < n) {
            String scheme = stringArray[n2];
            newEditor.add(scheme);
            ++n2;
        }
        newEditor.setText(item.getText(0));
        newEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CCombo editor = (CCombo)ZnodeAclComposite.this._SchemeTableEditor.getEditor();
                String text = editor.getText();
                TableItem item = ZnodeAclComposite.this._SchemeTableEditor.getItem();
                item.setText(0, text);
                Text idText = (Text)ZnodeAclComposite.this._IdTableEditor.getEditor();
                if (SCHEME_WORLD.equals(text)) {
                    idText.setText(ID_ANYONE);
                } else if (SCHEME_AUTH.equals(text)) {
                    idText.setText(ID_AUTH);
                } else if (ZnodeAclComposite.SCHEME_IP.equals(text)) {
                    String ipId = ZnodeAclComposite.this.getIpId();
                    idText.setText(ipId);
                } else {
                    idText.setText("");
                }
                ZnodeAclComposite.this.getSetIdButton().setEnabled(ZnodeAclComposite.SCHEME_DIGEST.equals(text));
                ZnodeAclComposite.this.fireOrchestrationChange();
            }
        });
        this._SchemeTableEditor.setEditor((Control)newEditor, item, 0);
    }

    private void removeItems(TableItem[] items) {
        Table table = this.getTable();
        table.setRedraw(false);
        try {
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                Control schemeTableEditorControl = this._SchemeTableEditor.getEditor();
                if (schemeTableEditorControl != null) {
                    schemeTableEditorControl.dispose();
                }
                this._SchemeTableEditor.setEditor(null, item, 0);
                Control idTableEditorControl = this._IdTableEditor.getEditor();
                if (idTableEditorControl != null) {
                    idTableEditorControl.dispose();
                }
                this._IdTableEditor.setEditor(null, item, 1);
                int[] nArray = PERMS;
                int n3 = PERMS.length;
                int n4 = 0;
                while (n4 < n3) {
                    int perm = nArray[n4];
                    TableEditor tableEditor = this.getItemPermTableEditor(item, perm);
                    Button checkBox = (Button)tableEditor.getEditor();
                    tableEditor.dispose();
                    checkBox.dispose();
                    ++n4;
                }
                item.dispose();
                ++n2;
            }
        }
        finally {
            table.setRedraw(true);
        }
    }

    private void removeSelectedItems() {
        Table table = this.getTable();
        this.removeItems(table.getSelection());
        this.fixLayout();
        this.fireOrchestrationChange();
    }

    private void setId() {
        Text idEditor;
        SetDigestIdDialog dialog = new SetDigestIdDialog(this.getShell());
        dialog.setBlockOnOpen(true);
        if (dialog.open() == 0 && (idEditor = (Text)this._IdTableEditor.getEditor()) != null && !idEditor.isDisposed()) {
            idEditor.setText(dialog.getDigestId());
            idEditor.forceFocus();
        }
    }

    private void setItemPermTableEditor(TableItem item, int zooDefPerm, TableEditor tableEditor) {
        item.setData(String.valueOf(zooDefPerm), (Object)tableEditor);
    }

    private class SetDigestIdDialog
    extends GridDialog {
        private static final String CONTROL_NAME_PASSWORD_TEXT = "Password";
        private static final String CONTROL_NAME_USER_NAME_TEXT = "User name";
        private static final String MESSAGE = "Generates the MD5 hash of the user name and password which is then used as an ACL ID.";
        private static final String TITLE = "Set Digest ACL ID.";
        private String _DigestId;

        SetDigestIdDialog(Shell parentShell) {
            super(parentShell);
        }

        public void create() {
            super.create();
            this.setTitle(TITLE);
            this.setMessage(MESSAGE);
            Shell shell = this.getShell();
            shell.setText(TITLE);
        }

        public String getDigestId() {
            return this._DigestId;
        }

        protected GridComposite createGridComposite(Composite parent) {
            GridComposite gridComposite = new GridComposite(parent){

                protected void createContents() {
                    GridTextInput userNameGridTextInput = new GridTextInput((Composite)this, GridTextInput.Type.VALUE_REQUIRED, SetDigestIdDialog.CONTROL_NAME_USER_NAME_TEXT, "&User name: ", null);
                    this.addGridTextInput(userNameGridTextInput);
                    GridTextInput passwordGridTextInput = new GridTextInput((Composite)this, GridTextInput.Type.VALUE_REQUIRED, SetDigestIdDialog.CONTROL_NAME_PASSWORD_TEXT, "&Password:     ", null);
                    this.addGridTextInput(passwordGridTextInput);
                    passwordGridTextInput.getText().setEchoChar('*');
                    final Button showPasswordTextCheckBox = new Button((Composite)this, 32);
                    showPasswordTextCheckBox.setText("Show password text");
                    showPasswordTextCheckBox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
                    showPasswordTextCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            Text passwordText = (Text)this.getControl(SetDigestIdDialog.CONTROL_NAME_PASSWORD_TEXT);
                            char echoChar = showPasswordTextCheckBox.getSelection() ? (char)'\u0000' : '*';
                            passwordText.setEchoChar(echoChar);
                        }
                    });
                }
            };
            return gridComposite;
        }

        protected void okPressed() {
            GridComposite gridComposite = this.getGridComposite();
            Text userNameText = (Text)gridComposite.getControl(CONTROL_NAME_USER_NAME_TEXT);
            Text passwordText = (Text)gridComposite.getControl(CONTROL_NAME_PASSWORD_TEXT);
            String userName = userNameText.getText();
            String password = passwordText.getText();
            this._DigestId = ZnodeAclComposite.generateDigest(String.valueOf(userName) + ":" + password);
            super.okPressed();
        }
    }
}

