/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.wizards.newznode;

import com.fusesource.zk.core.wizards.AbstractWizard;
import com.fusesource.zk.zookeeper.ZooKeeperActivator;
import com.fusesource.zk.zookeeper.data.Znode;
import com.fusesource.zk.zookeeper.model.ZnodeModel;
import com.fusesource.zk.zookeeper.views.explorer.ZooKeeperExplorerView;
import com.fusesource.zk.zookeeper.wizards.newznode.ZnodeNewWizardPage1;
import com.fusesource.zk.zookeeper.wizards.newznode.ZnodeNewWizardPage2;
import java.util.List;
import org.apache.zookeeper.data.ACL;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class ZnodeNewWizard
extends AbstractWizard
implements INewWizard {
    public static final String ID = String.valueOf(ZnodeNewWizard.class.getName());
    public static final String DESCRIPTION = "This wizard creates a new Znode.";
    public static final String TITLE = "New Znode Wizard";
    private ZnodeModel _ParentZnodeModel;
    private ZnodeNewWizardPage1 _Page1;
    private ZnodeNewWizardPage2 _Page2;

    public ZnodeNewWizard() {
        super(TITLE, DESCRIPTION, ZooKeeperActivator.getManagedImageDescriptor("IMAGE_KEY_WIZARD_BANNER_NEW_ZNODE"));
    }

    public void addPages() {
        this._Page1 = new ZnodeNewWizardPage1(this, this._ParentZnodeModel);
        this._Page2 = new ZnodeNewWizardPage2(this, this._ParentZnodeModel);
        this.addPage((IWizardPage)this._Page1);
        this.addPage((IWizardPage)this._Page2);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object firstElement = selection.getFirstElement();
        this._ParentZnodeModel = (ZnodeModel)((Object)firstElement);
    }

    public boolean performFinish() {
        if (this._ParentZnodeModel.isDestroyed()) {
            return false;
        }
        ZooKeeperActivator plugin = ZooKeeperActivator.getDefault();
        Znode znode = null;
        try {
            znode = this._Page1.getZnode();
            List<ACL> acl = this._Page2.getAcl();
            znode.setAcl(acl);
            this._ParentZnodeModel.getManager().insertData((Comparable)((Object)znode.getPath()), (Object)znode);
        }
        catch (Exception e) {
            ZooKeeperActivator.reportError(e);
            return false;
        }
        IWorkbenchPage page = plugin.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            page.showView(ZooKeeperExplorerView.ID);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        return true;
    }
}

