/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.wizards.newznode;

import com.fusesource.zk.core.model.GenericDataModelEvent;
import com.fusesource.zk.core.model.IGenericDataModelEventListener;
import com.fusesource.zk.core.reflect.SwtThreadSafeDelegatingInvocationHandler;
import com.fusesource.zk.core.widgets.grid.GridComposite;
import com.fusesource.zk.core.widgets.grid.GridCompositeStatus;
import com.fusesource.zk.zookeeper.ZooKeeperActivator;
import com.fusesource.zk.zookeeper.data.Znode;
import com.fusesource.zk.zookeeper.data.ZooKeeperConnectionDescriptor;
import com.fusesource.zk.zookeeper.model.ZnodeModel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;

public abstract class ZnodeNewWizardComposite
extends GridComposite {
    protected static final String CONTROL_NAME_CONNECTION_LABEL = "ZooKeeper Connection";
    protected static final String CONTROL_NAME_PARENT_IMAGE_LABEL = "Parent Znode Image";
    protected static final String CONTROL_NAME_PARENT_PATH_LABEL = "Parent Znode";
    private final ZnodeModel _ParentZnodeModel;

    public ZnodeNewWizardComposite(Composite parent, ZnodeModel parentZnodeModel) {
        super(parent);
        this._ParentZnodeModel = parentZnodeModel;
        ParentZnodeModelEventListener delegate = new ParentZnodeModelEventListener();
        final IGenericDataModelEventListener parentZnodeModelEventListener = (IGenericDataModelEventListener)SwtThreadSafeDelegatingInvocationHandler.createProxyInstance((SwtThreadSafeDelegatingInvocationHandler.IWidgetProvider)delegate, IGenericDataModelEventListener.class, (boolean)true);
        this._ParentZnodeModel.addGenericEventListener(parentZnodeModelEventListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ZnodeNewWizardComposite.this._ParentZnodeModel.removeGenericEventListener(parentZnodeModelEventListener);
            }
        });
        this.setNumColumns(3);
    }

    public ZnodeModel getParentZnodeModel() {
        return this._ParentZnodeModel;
    }

    protected void createContents() {
        ZnodeModel parentZnodeModel = this.getParentZnodeModel();
        Label connectionLabel = new Label((Composite)this, 16384);
        connectionLabel.setText("Connection:");
        connectionLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Label connectionImageLabel = new Label((Composite)this, 16384);
        connectionImageLabel.setImage(ZooKeeperActivator.getManagedImage("IMAGE_KEY_OBJECT_ZOO_KEEPER_CONNECTION"));
        connectionImageLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Label connectionValueLabel = new Label((Composite)this, 16384);
        connectionValueLabel.setText(((ZooKeeperConnectionDescriptor)((Object)parentZnodeModel.getOwnerModel().getKey())).getName());
        connectionValueLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addControl(CONTROL_NAME_CONNECTION_LABEL, (Control)connectionValueLabel);
        this.addControlDecoration(CONTROL_NAME_CONNECTION_LABEL, (Control)connectionValueLabel);
        Label parentLabel = new Label((Composite)this, 16384);
        parentLabel.setText("Parent:");
        parentLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Label parentImageLabel = new Label((Composite)this, 16384);
        parentImageLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.addControl(CONTROL_NAME_PARENT_IMAGE_LABEL, (Control)parentImageLabel);
        this.updateParentZnodeImage();
        Label parentValueLabel = new Label((Composite)this, 16384);
        parentValueLabel.setText(((Znode)parentZnodeModel.getData()).getPath());
        parentValueLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addControl(CONTROL_NAME_PARENT_PATH_LABEL, (Control)parentValueLabel);
        this.addControlDecoration(CONTROL_NAME_PARENT_PATH_LABEL, (Control)parentValueLabel);
    }

    protected GridCompositeStatus updateStatus(Object source) {
        GridCompositeStatus status = super.updateStatus(source);
        if (status.getType().isError()) {
            return status;
        }
        if (source instanceof Label) {
            ZnodeModel parentZnodeModel = this.getParentZnodeModel();
            Label parentValueLabel = (Label)this.getControl(CONTROL_NAME_PARENT_PATH_LABEL);
            if (parentValueLabel == source && parentZnodeModel.isDestroyed()) {
                Znode parentZnode = (Znode)parentZnodeModel.getData();
                String parentZnodePath = parentZnode.getPath();
                String message = "Parent Znode '" + parentZnodePath + "' not available.";
                return new GridCompositeStatus(CONTROL_NAME_PARENT_PATH_LABEL, message, GridCompositeStatus.Type.ERROR_INVALID);
            }
        }
        return GridCompositeStatus.OK_STATUS;
    }

    private void updateParentZnodeImage() {
        ZnodeModel parentZnodeModel = this.getParentZnodeModel();
        Label parentImageLabel = (Label)this.getControl(CONTROL_NAME_PARENT_IMAGE_LABEL);
        if (parentImageLabel != null && !parentImageLabel.isDisposed()) {
            parentImageLabel.setImage(ZooKeeperActivator.getZnodeSmallImage((Znode)parentZnodeModel.getData()));
        }
    }

    public class ParentZnodeModelEventListener
    implements IGenericDataModelEventListener,
    SwtThreadSafeDelegatingInvocationHandler.IWidgetProvider {
        public void dataModelDataChanged(GenericDataModelEvent event) {
            this.parentZnodeModelChanged();
        }

        public void dataModelDataRefreshed(GenericDataModelEvent event) {
            this.parentZnodeModelChanged();
        }

        public void dataModelDestroyed(GenericDataModelEvent event) {
            this.parentZnodeModelChanged();
        }

        public Widget getWidget() {
            return ZnodeNewWizardComposite.this;
        }

        private void parentZnodeModelChanged() {
            if (!this.getWidget().isDisposed()) {
                if (!ZnodeNewWizardComposite.this._ParentZnodeModel.isDestroyed()) {
                    ZnodeNewWizardComposite.this.updateParentZnodeImage();
                }
                ZnodeNewWizardComposite.this.modified(null);
            }
        }
    }
}

