/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.wizards.newznode;

import com.fusesource.zk.core.ui.FileEditor;
import com.fusesource.zk.core.widgets.grid.GridComposite;
import com.fusesource.zk.core.widgets.grid.GridCompositeStatus;
import com.fusesource.zk.core.widgets.grid.GridTextInput;
import com.fusesource.zk.zookeeper.data.Znode;
import com.fusesource.zk.zookeeper.model.ZnodeModel;
import com.fusesource.zk.zookeeper.wizards.newznode.ZnodeNewWizardComposite;
import java.io.File;
import java.io.IOException;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ZnodeNewWizardComposite1
extends ZnodeNewWizardComposite {
    private static final String CONTROL_NAME_DATA_FILE_BUTTON = "File";
    private static final String CONTROL_NAME_DATA_FILE_COMPOSITE = "Data File Composite";
    private static final String CONTROL_NAME_DATA_FILE_TEXT = "Data (File)";
    private static final String CONTROL_NAME_DATA_SINGLE_LINE_COMPOSITE = "Data Single Line Text Composite";
    private static final String CONTROL_NAME_DATA_SINGLE_LINE_TEXT = "Data (Text)";
    private static final String CONTROL_NAME_DATA_SINGLE_LINE_TEXT_BUTTON = "Text";
    private static final String CONTROL_NAME_DATA_STACK_COMPOSITE = "Data Stack Composite";
    private static final String CONTROL_NAME_CREATE_MODE_EPHEMERAL_BUTTON = "Ephemeral";
    private static final String CONTROL_NAME_PATH_TEXT = "Path";
    private static final String CONTROL_NAME_CREATE_MODE_PERSISTENT_BUTTON = "Persistent";
    private static final String CONTROL_NAME_CREATE_MODE_SEQUENTIAL_BUTTON = "Sequential";

    public ZnodeNewWizardComposite1(Composite parent, ZnodeModel parentZnodeModel) {
        super(parent, parentZnodeModel);
    }

    public Znode getZnode() throws Exception {
        byte[] data = this.getZnodeData();
        ZnodeModel parentZnodeModel = this.getParentZnodeModel();
        Text pathText = (Text)this.getControl(CONTROL_NAME_PATH_TEXT);
        String relativePath = pathText.getText();
        Znode parentZnode = (Znode)parentZnodeModel.getData();
        String parentPath = parentZnode.getPath();
        String absolutePath = Znode.getAbsolutePath(parentPath, relativePath);
        Button sequentialCheckbox = (Button)this.getControl(CONTROL_NAME_CREATE_MODE_SEQUENTIAL_BUTTON);
        boolean isSequential = sequentialCheckbox.getSelection();
        Button ephemeralRadioButton = (Button)this.getControl(CONTROL_NAME_CREATE_MODE_EPHEMERAL_BUTTON);
        boolean isEphemeral = ephemeralRadioButton.getSelection();
        Znode znode = new Znode(absolutePath);
        znode.setSequential(isSequential);
        znode.setEphemeral(isEphemeral);
        znode.setData(data);
        return znode;
    }

    @Override
    protected void createContents() {
        super.createContents();
        GridTextInput pathGridTextInput = new GridTextInput((Composite)this, GridTextInput.Type.VALUE_REQUIRED, CONTROL_NAME_PATH_TEXT, "&Path:", null, 2);
        this.addGridTextInput(pathGridTextInput);
        Group createModeGroup = new Group((Composite)this, 0);
        createModeGroup.setText("Create Mode");
        createModeGroup.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        createModeGroup.setLayout(this.getLayout());
        Button persistentButton = new Button((Composite)createModeGroup, 16);
        persistentButton.setText("Pe&rsistent");
        persistentButton.setSelection(true);
        this.addControl(CONTROL_NAME_CREATE_MODE_PERSISTENT_BUTTON, (Control)persistentButton);
        Button ephemeralButton = new Button((Composite)createModeGroup, 16);
        ephemeralButton.setText("&Ephemeral");
        ephemeralButton.setSelection(false);
        this.addControl(CONTROL_NAME_CREATE_MODE_EPHEMERAL_BUTTON, (Control)ephemeralButton);
        Button sequentialButton = new Button((Composite)createModeGroup, 32);
        sequentialButton.setText("&Sequential");
        sequentialButton.setSelection(false);
        this.addControl(CONTROL_NAME_CREATE_MODE_SEQUENTIAL_BUTTON, (Control)sequentialButton);
        sequentialButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZnodeNewWizardComposite1.this.modified(e.item);
            }
        });
        Group dataGroup = new Group((Composite)this, 0);
        dataGroup.setText("Data");
        dataGroup.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        dataGroup.setLayout(this.getLayout());
        Button singleLineTextDataButton = new Button((Composite)dataGroup, 16);
        singleLineTextDataButton.setText("&Text");
        singleLineTextDataButton.setSelection(true);
        singleLineTextDataButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.addControl(CONTROL_NAME_DATA_SINGLE_LINE_TEXT_BUTTON, (Control)singleLineTextDataButton);
        singleLineTextDataButton.addSelectionListener((SelectionListener)new DataTypeRadioButtonSelectionListener(CONTROL_NAME_DATA_SINGLE_LINE_COMPOSITE));
        Button fileDataButton = new Button((Composite)dataGroup, 16);
        fileDataButton.setText("&File");
        fileDataButton.setSelection(false);
        fileDataButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.addControl(CONTROL_NAME_DATA_FILE_BUTTON, (Control)fileDataButton);
        fileDataButton.addSelectionListener((SelectionListener)new DataTypeRadioButtonSelectionListener(CONTROL_NAME_DATA_FILE_COMPOSITE));
        Composite dataStackComposite = new Composite((Composite)dataGroup, 0);
        dataStackComposite.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        StackLayout dataStackLayout = new StackLayout();
        dataStackComposite.setLayout((Layout)dataStackLayout);
        this.addControl(CONTROL_NAME_DATA_STACK_COMPOSITE, (Control)dataStackComposite);
        SingleLineZnodeTextDataGridComposite singleLineTextGridComposite = new SingleLineZnodeTextDataGridComposite(dataStackComposite);
        singleLineTextGridComposite.init();
        this.addControl(CONTROL_NAME_DATA_SINGLE_LINE_COMPOSITE, (Control)singleLineTextGridComposite);
        FileZnodeDataGridComposite fileGridComposite = new FileZnodeDataGridComposite(dataStackComposite);
        fileGridComposite.init();
        this.addControl(CONTROL_NAME_DATA_FILE_COMPOSITE, (Control)fileGridComposite);
        dataStackLayout.topControl = singleLineTextGridComposite;
    }

    @Override
    protected GridCompositeStatus updateStatus(Object source) {
        GridTextInput gridTextInput;
        GridCompositeStatus status = super.updateStatus(source);
        if (status.getType().isError()) {
            return status;
        }
        if (source instanceof GridTextInput && (gridTextInput = (GridTextInput)source).getName().equals(CONTROL_NAME_PATH_TEXT)) {
            Text pathText = gridTextInput.getText();
            String relativePath = pathText.getText();
            if (relativePath.indexOf(47) >= 0) {
                String message = "Path should not contain the '/' character.";
                return new GridCompositeStatus(CONTROL_NAME_PATH_TEXT, message, GridCompositeStatus.Type.ERROR_INVALID);
            }
            ZnodeModel parentZnodeModel = this.getParentZnodeModel();
            Znode parentZnode = (Znode)parentZnodeModel.getData();
            String parentPath = parentZnode.getPath();
            String absolutePath = Znode.getAbsolutePath(parentPath, relativePath);
            Button sequentialCheckbox = (Button)this.getControl(CONTROL_NAME_CREATE_MODE_SEQUENTIAL_BUTTON);
            boolean isSequential = sequentialCheckbox.getSelection();
            if (!isSequential && parentZnodeModel.getManager().findKeys((Object)parentZnode).contains(absolutePath)) {
                String message = "Znode '" + absolutePath + "' already exists.";
                return new GridCompositeStatus(CONTROL_NAME_PATH_TEXT, message, GridCompositeStatus.Type.ERROR_INVALID);
            }
            try {
                Znode.validatePath(absolutePath, isSequential);
            }
            catch (IllegalArgumentException e) {
                String message = e.getMessage();
                return new GridCompositeStatus(CONTROL_NAME_PATH_TEXT, message, GridCompositeStatus.Type.ERROR_INVALID);
            }
        }
        return GridCompositeStatus.OK_STATUS;
    }

    private byte[] getZnodeData() throws Exception {
        Composite dataStackComposite = (Composite)this.getControl(CONTROL_NAME_DATA_STACK_COMPOSITE);
        ZnodeDataGridComposite znodeDataGridComposite = (ZnodeDataGridComposite)((StackLayout)dataStackComposite.getLayout()).topControl;
        return znodeDataGridComposite.getZnodeData();
    }

    private class DataTypeRadioButtonSelectionListener
    extends SelectionAdapter {
        private final String _DataCompositeName;

        public DataTypeRadioButtonSelectionListener(String dataCompositeName) {
            this._DataCompositeName = dataCompositeName;
        }

        public void widgetSelected(SelectionEvent e) {
            Control composite = ZnodeNewWizardComposite1.this.getControl(this._DataCompositeName);
            Composite dataStackComposite = (Composite)ZnodeNewWizardComposite1.this.getControl(ZnodeNewWizardComposite1.CONTROL_NAME_DATA_STACK_COMPOSITE);
            ((StackLayout)dataStackComposite.getLayout()).topControl = composite;
            dataStackComposite.layout();
            ZnodeNewWizardComposite1.this.modified(composite);
        }
    }

    private class FileZnodeDataGridComposite
    extends ZnodeDataGridComposite {
        public FileZnodeDataGridComposite(Composite parent) {
            super(parent);
            this.setNumColumns(2);
        }

        @Override
        public byte[] getZnodeData() throws Exception {
            Text filePathText = (Text)this.getControl(ZnodeNewWizardComposite1.CONTROL_NAME_DATA_FILE_TEXT);
            String filePath = filePathText.getText();
            File file = new File(filePath);
            String fileName = file.getName();
            if (!file.exists()) {
                throw new IOException("File '" + fileName + "' does not exist.");
            }
            if (!file.isFile()) {
                throw new IOException("Path '" + filePath + "' is not a valid file.");
            }
            long length = file.length();
            if (length > 0x100000L) {
                throw new Exception("File '" + fileName + "' size is greater than the maximum allowed Znode data size (" + 0x100000L + " bytes).");
            }
            FileEditor fileEditor = new FileEditor(file);
            return fileEditor.read();
        }

        protected void createContents() {
            GridTextInput fileGridTextInput = new GridTextInput((Composite)this, GridTextInput.Type.DEFAULT, ZnodeNewWizardComposite1.CONTROL_NAME_DATA_FILE_TEXT, null, null);
            this.addGridTextInput(fileGridTextInput);
            Button browseButton = new Button((Composite)this, 8);
            browseButton.setText("&Browse...");
            browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Text filePathText = (Text)FileZnodeDataGridComposite.this.getControl(ZnodeNewWizardComposite1.CONTROL_NAME_DATA_FILE_TEXT);
                    FileDialog fileDialog = new FileDialog(FileZnodeDataGridComposite.this.getShell());
                    fileDialog.setFileName(filePathText.getText());
                    String newPath = fileDialog.open();
                    if (newPath != null) {
                        filePathText.setText(newPath);
                    }
                }
            });
        }
    }

    private class SingleLineZnodeTextDataGridComposite
    extends TextZnodeDataGridComposite {
        public SingleLineZnodeTextDataGridComposite(Composite parent) {
            super(parent);
        }

        @Override
        public Text getText() {
            return (Text)this.getControl(ZnodeNewWizardComposite1.CONTROL_NAME_DATA_SINGLE_LINE_TEXT);
        }

        @Override
        protected void createContents() {
            GridTextInput dataSingleLineGridTextInput = new GridTextInput((Composite)this, GridTextInput.Type.DEFAULT, ZnodeNewWizardComposite1.CONTROL_NAME_DATA_SINGLE_LINE_TEXT, null, null);
            this.addGridTextInput(dataSingleLineGridTextInput);
        }
    }

    private abstract class TextZnodeDataGridComposite
    extends ZnodeDataGridComposite {
        protected TextZnodeDataGridComposite(Composite parent) {
            super(parent);
        }

        public abstract Text getText();

        @Override
        public byte[] getZnodeData() throws Exception {
            return this.getZnodeData(this.getText());
        }

        protected byte[] getZnodeData(Text text) throws Exception {
            String stringValue = text.getText();
            if (stringValue.isEmpty()) {
                return null;
            }
            byte[] data = stringValue.getBytes();
            return data;
        }

        protected void createContents() {
        }

        public void init() {
            super.init();
            this.getText().setFont(JFaceResources.getTextFont());
        }
    }

    private abstract class ZnodeDataGridComposite
    extends GridComposite {
        protected ZnodeDataGridComposite(Composite parent) {
            super(parent);
            this.setNumColumns(1);
        }

        public abstract byte[] getZnodeData() throws Exception;
    }
}

