/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.wizards.newzookeeperconnection;

import com.fusesource.zk.core.widgets.grid.GridComposite;
import com.fusesource.zk.core.widgets.grid.GridCompositeStatus;
import com.fusesource.zk.core.widgets.grid.GridTextInput;
import com.fusesource.zk.zookeeper.ZooKeeperActivator;
import com.fusesource.zk.zookeeper.data.Znode;
import com.fusesource.zk.zookeeper.data.ZooKeeperConnectionDescriptor;
import com.fusesource.zk.zookeeper.runtime.ZooKeeperConnectionDescriptorFiles;
import com.fusesource.zk.zookeeper.widgets.OrchestrationComposite;
import com.fusesource.zk.zookeeper.widgets.ZooKeeperConnectionServerComposite;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class ZooKeeperConnectionComposite1
extends GridComposite {
    private static final String CONTROL_NAME_CONNECT_STRING_VALUE_LABEL = "Connect String";
    private static final String CONTROL_NAME_NAME_TEXT = "Name";
    private static final String CONTROL_NAME_ROOT_PATH_TEXT = "Root Path";
    private static final String CONTROL_NAME_SERVERS_TABLE = "Servers";
    private static final String CONTROL_NAME_SESSION_TIMEOUT_TEXT = "Session Timeout";
    private final Set<String> _ZooKeeperConnectionNames;
    private ZooKeeperConnectionServerComposite _ServerComposite;

    public ZooKeeperConnectionComposite1(Composite parent) {
        super(parent);
        ZooKeeperConnectionDescriptorFiles files = ZooKeeperActivator.getDefault().getZooKeeperConnectionDescriptorFiles();
        this._ZooKeeperConnectionNames = new HashSet<String>(files.getNames());
    }

    public ZooKeeperConnectionDescriptor getConnectionDescriptor() {
        Text nameText = (Text)this.getControl(CONTROL_NAME_NAME_TEXT);
        Text sessionTimeoutText = (Text)this.getControl(CONTROL_NAME_SESSION_TIMEOUT_TEXT);
        String name = nameText.getText();
        int sessionTimeout = Integer.parseInt(sessionTimeoutText.getText());
        ZooKeeperConnectionDescriptor connection = new ZooKeeperConnectionDescriptor(name, sessionTimeout);
        connection.getServers().addAll(this._ServerComposite.getElementList());
        connection.setRootPath(this.getRootPath());
        return connection;
    }

    protected void createContents() {
        int margin;
        GridTextInput nameGridTextInput = new GridTextInput((Composite)this, GridTextInput.Type.VALUE_REQUIRED, CONTROL_NAME_NAME_TEXT, "&Name:", "My ZooKeeper");
        this.addGridTextInput(nameGridTextInput);
        Text nameText = nameGridTextInput.getText();
        nameText.selectAll();
        nameText.setTextLimit(100);
        GridTextInput rootPathTextInput = new GridTextInput((Composite)this, GridTextInput.Type.DEFAULT, CONTROL_NAME_ROOT_PATH_TEXT, "&Root Path:", null);
        this.addGridTextInput(rootPathTextInput);
        GridTextInput sessionTimeoutGridTextInput = new GridTextInput((Composite)this, GridTextInput.Type.INTEGER_VALUE_REQUIRED, CONTROL_NAME_SESSION_TIMEOUT_TEXT, "Session &Timeout:", String.valueOf(5000));
        this.addGridTextInput(sessionTimeoutGridTextInput);
        Group serversGroup = new Group((Composite)this, 0);
        serversGroup.setText(CONTROL_NAME_SERVERS_TABLE);
        serversGroup.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        GridLayout serversGroupLayout = new GridLayout(this.getNumColumns(), false);
        serversGroupLayout.horizontalSpacing = margin = this.getMargin();
        serversGroupLayout.verticalSpacing = margin;
        serversGroupLayout.marginWidth = margin;
        serversGroupLayout.marginHeight = margin;
        serversGroup.setLayout((Layout)serversGroupLayout);
        this._ServerComposite = new ZooKeeperConnectionServerComposite((Composite)serversGroup, 0);
        this._ServerComposite.setLayoutData(new GridData(4, 4, true, true));
        GridLayout serverCompositeLayout = new GridLayout(2, false);
        serverCompositeLayout.marginWidth = 0;
        serverCompositeLayout.marginHeight = 0;
        serverCompositeLayout.horizontalSpacing = ((GridLayout)this.getLayout()).horizontalSpacing;
        this._ServerComposite.setLayout((Layout)serverCompositeLayout);
        final Table table = new Table((Composite)this._ServerComposite, 68356);
        GridData tableLayoutData = new GridData(4, 4, true, true, 1, 2);
        tableLayoutData.heightHint = 100;
        table.setLayoutData((Object)tableLayoutData);
        this.addControl(CONTROL_NAME_SERVERS_TABLE, (Control)table);
        this.addControlDecoration(CONTROL_NAME_SERVERS_TABLE, (Control)table, 16512, this._ServerComposite);
        this._ServerComposite.setTable(table);
        Button addServerButton = new Button((Composite)this._ServerComposite, 0);
        addServerButton.setText("Add...");
        addServerButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this._ServerComposite.setAddButton(addServerButton);
        Button removeServerButton = new Button((Composite)this._ServerComposite, 0);
        removeServerButton.setText("Remove");
        removeServerButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this._ServerComposite.setRemoveButton(removeServerButton);
        this._ServerComposite.addOrchestrationCompositeListener(new OrchestrationComposite.IOrchestrationCompositeListener(){

            @Override
            public void orchestrationChange(EventObject e) {
                ZooKeeperConnectionComposite1.this.connectStringChanged();
                ZooKeeperConnectionComposite1.this.modified(table);
            }
        });
        this._ServerComposite.init();
        Label connectStringLabel = new Label((Composite)this, 16384);
        connectStringLabel.setText("Connect String:   ");
        connectStringLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        Label connectStringValueLabel = new Label((Composite)this, 64);
        connectStringValueLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        this.addControl(CONTROL_NAME_CONNECT_STRING_VALUE_LABEL, (Control)connectStringValueLabel);
        this.connectStringChanged();
    }

    protected String getRootPath() {
        Text rootPathText = (Text)this.getControl(CONTROL_NAME_ROOT_PATH_TEXT);
        String rootPath = rootPathText.getText();
        if (rootPath.trim().length() == 0) {
            rootPath = null;
        }
        return rootPath;
    }

    protected GridCompositeStatus updateStatus(Object source) {
        Table serversTable;
        GridCompositeStatus status = super.updateStatus(source);
        if (status.getType().isError()) {
            return status;
        }
        if (source instanceof GridTextInput) {
            String rootPath;
            GridTextInput gridTextInput = (GridTextInput)source;
            if (gridTextInput.getName().equals(CONTROL_NAME_NAME_TEXT)) {
                Text nameText = gridTextInput.getText();
                String name = nameText.getText();
                if (this._ZooKeeperConnectionNames.contains(name)) {
                    String message = "Name must be unique.";
                    return new GridCompositeStatus(CONTROL_NAME_NAME_TEXT, message, GridCompositeStatus.Type.ERROR_INVALID);
                }
            } else if (gridTextInput.getName().equals(CONTROL_NAME_ROOT_PATH_TEXT) && (rootPath = this.getRootPath()) != null) {
                try {
                    Znode.validatePath(rootPath, false);
                }
                catch (IllegalArgumentException e) {
                    String message = e.getMessage();
                    return new GridCompositeStatus(CONTROL_NAME_ROOT_PATH_TEXT, message, GridCompositeStatus.Type.ERROR_INVALID);
                }
            }
        } else if (source instanceof Table && (serversTable = (Table)source).getItemCount() == 0) {
            String message = "At least one server must be added.";
            return new GridCompositeStatus(CONTROL_NAME_SERVERS_TABLE, message, GridCompositeStatus.Type.ERROR_REQUIRED);
        }
        return GridCompositeStatus.OK_STATUS;
    }

    private void connectStringChanged() {
        String connectString = ZooKeeperConnectionDescriptor.buildConnectString(this._ServerComposite.getElementSet(), this.getRootPath());
        connectString = connectString != null ? connectString : "";
        Label connectStringValueLabel = (Label)this.getControl(CONTROL_NAME_CONNECT_STRING_VALUE_LABEL);
        connectStringValueLabel.setText(connectString);
    }
}

