/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.wizards.newzookeeperconnection;

import com.fusesource.zk.core.model.DataModelManager;
import com.fusesource.zk.core.wizards.AbstractWizard;
import com.fusesource.zk.zookeeper.ZooKeeperActivator;
import com.fusesource.zk.zookeeper.data.AuthInfo;
import com.fusesource.zk.zookeeper.data.ZooKeeperConnection;
import com.fusesource.zk.zookeeper.data.ZooKeeperConnectionDescriptor;
import com.fusesource.zk.zookeeper.model.ZooKeeperConnectionModel;
import com.fusesource.zk.zookeeper.views.explorer.ZooKeeperExplorerView;
import com.fusesource.zk.zookeeper.wizards.newzookeeperconnection.ZooKeeperConnectionNewWizardPage1;
import com.fusesource.zk.zookeeper.wizards.newzookeeperconnection.ZooKeeperConnectionNewWizardPage2;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class ZooKeeperConnectionNewWizard
extends AbstractWizard
implements INewWizard {
    public static final String ID = String.valueOf(ZooKeeperConnectionNewWizard.class.getName());
    public static final String DESCRIPTION = "This wizard creates a new ZooKeeper connection.";
    public static final String TITLE = "New ZooKeeper Connection Wizard";
    private ZooKeeperConnectionNewWizardPage1 _Page1;
    private ZooKeeperConnectionNewWizardPage2 _Page2;

    public ZooKeeperConnectionNewWizard() {
        super(TITLE, DESCRIPTION, ZooKeeperActivator.getManagedImageDescriptor("IMAGE_KEY_WIZARD_BANNER_NEW_ZOO_KEEPER_CONNECTION"));
    }

    public void addPages() {
        this._Page1 = new ZooKeeperConnectionNewWizardPage1(this);
        this.addPage((IWizardPage)this._Page1);
        this._Page2 = new ZooKeeperConnectionNewWizardPage2(this);
        this.addPage((IWizardPage)this._Page2);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        ZooKeeperConnectionDescriptor connectionDescriptor = this._Page1.getConnectionDescriptor();
        List<AuthInfo> authInfos = this._Page2.getAuthInfos();
        if (authInfos != null && authInfos.size() > 0) {
            connectionDescriptor.setAuthInfos(authInfos);
        }
        ZooKeeperActivator plugin = ZooKeeperActivator.getDefault();
        DataModelManager<ZooKeeperConnectionModel, ZooKeeperConnectionDescriptor, ZooKeeperConnection> zooKeeperConnectionModelManager = plugin.getZooKeeperConnectionModelManager();
        zooKeeperConnectionModelManager.insertData((Comparable)((Object)connectionDescriptor), null);
        zooKeeperConnectionModelManager.getModel((Comparable)((Object)connectionDescriptor));
        IWorkbenchPage page = plugin.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            page.showView(ZooKeeperExplorerView.ID);
        }
        catch (PartInitException e) {
            ZooKeeperActivator.reportError(e);
        }
        return true;
    }
}

