/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.wizards.newzookeeperserver;

import com.fusesource.zk.core.EclipseCoreActivator;
import com.fusesource.zk.core.wizards.AbstractWizard;
import com.fusesource.zk.jmx.data.JmxConnectionDescriptor;
import com.fusesource.zk.zookeeper.data.ZooKeeperServerDescriptor;
import com.fusesource.zk.zookeeper.wizards.newzookeeperserver.ZooKeeperServerNewWizardPage1;
import com.fusesource.zk.zookeeper.wizards.newzookeeperserver.ZooKeeperServerNewWizardPage2;
import java.util.UUID;
import javax.management.remote.JMXServiceURL;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ZooKeeperServerNewWizard
extends AbstractWizard
implements INewWizard {
    public static final String ID = String.valueOf(ZooKeeperServerNewWizard.class.getName());
    public static final String DESCRIPTION = "This wizard adds a new ZooKeeper server to the connection.";
    public static final String TITLE = "Add ZooKeeper Server Wizard";
    private static final String JMX_CONNECTION_NAME_PREFIX = "ZooKeeper Server - ";
    private ZooKeeperServerNewWizardPage1 _Page1;
    private ZooKeeperServerNewWizardPage2 _Page2;
    private ZooKeeperServerDescriptor _ServerDescriptor;

    public ZooKeeperServerNewWizard() {
        super(TITLE, DESCRIPTION, EclipseCoreActivator.getManagedImageDescriptor((String)"IMAGE_KEY_WIZARD_BANNER_ADD_SERVER"));
    }

    public void addPages() {
        this._Page1 = new ZooKeeperServerNewWizardPage1(this);
        this.addPage((IWizardPage)this._Page1);
        this._Page2 = new ZooKeeperServerNewWizardPage2(this);
        this.addPage((IWizardPage)this._Page2);
    }

    public ZooKeeperServerDescriptor getServerDescriptor() {
        return this._ServerDescriptor;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        String host = this._Page1.getHost();
        int port = this._Page1.getPort();
        this._ServerDescriptor = new ZooKeeperServerDescriptor(host, port);
        if (this._Page2.isJmxEnabled()) {
            JMXServiceURL jmxServiceUrl = this._Page2.getServiceUrl();
            String userName = this._Page2.getUserName();
            String password = this._Page2.getPassword();
            String name = JMX_CONNECTION_NAME_PREFIX + UUID.randomUUID().toString();
            JmxConnectionDescriptor jmxConnectionDescriptor = new JmxConnectionDescriptor(name, jmxServiceUrl, userName, password);
            this._ServerDescriptor.setJmxConnectionDescriptor(jmxConnectionDescriptor);
        }
        return true;
    }
}

