/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.zookeeper.wizards.newzookeeperserver;

import com.fusesource.zk.core.widgets.grid.GridComposite;
import com.fusesource.zk.core.widgets.grid.GridCompositeStatus;
import com.fusesource.zk.core.widgets.grid.GridTextInput;
import com.fusesource.zk.core.wizards.AbstractWizard;
import com.fusesource.zk.core.wizards.GridWizardPage;
import com.fusesource.zk.zookeeper.wizards.newzookeeperserver.ZooKeeperServerNewWizard;
import java.net.MalformedURLException;
import javax.management.remote.JMXServiceURL;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ZooKeeperServerNewWizardPage2
extends GridWizardPage {
    public static final String CONTROL_NAME_ENABLED_BUTTON = "Enabled";
    public static final String CONTROL_NAME_JMX_URL_TEXT = "JMX URL";
    public static final String CONTROL_NAME_USER_NAME_TEXT = "User Name";
    public static final String CONTROL_NAME_PASSWORD_TEXT = "Password";

    public ZooKeeperServerNewWizardPage2(ZooKeeperServerNewWizard wizard) {
        super((AbstractWizard)wizard);
    }

    public boolean isJmxEnabled() {
        Button enableCheckBox = (Button)this.getGridComposite().getControl(CONTROL_NAME_ENABLED_BUTTON);
        return enableCheckBox.getSelection();
    }

    public JMXServiceURL getServiceUrl() {
        Text jmxUrlText = (Text)this.getGridComposite().getControl(CONTROL_NAME_JMX_URL_TEXT);
        String jmxServiceUrlString = jmxUrlText.getText();
        try {
            return new JMXServiceURL(jmxServiceUrlString);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public String getUserName() {
        Text userNameText = (Text)this.getGridComposite().getControl(CONTROL_NAME_USER_NAME_TEXT);
        String userName = userNameText.getText().trim();
        if (userName.isEmpty()) {
            return null;
        }
        return userName;
    }

    public String getPassword() {
        Text passwordText = (Text)this.getGridComposite().getControl(CONTROL_NAME_PASSWORD_TEXT);
        String password = passwordText.getText();
        if (password.isEmpty()) {
            return null;
        }
        return password;
    }

    protected GridComposite createGridComposite(Composite parent) {
        GridComposite gridComposite = new GridComposite(parent){

            protected void createContents() {
                final Button enableCheckBox = new Button((Composite)this, 32);
                enableCheckBox.setText("Establish JMX connection");
                enableCheckBox.setSelection(false);
                enableCheckBox.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
                this.addControl(ZooKeeperServerNewWizardPage2.CONTROL_NAME_ENABLED_BUTTON, (Control)enableCheckBox);
                final GridTextInput jmxUrlGridTextInput = new GridTextInput((Composite)this, GridTextInput.Type.VALUE_REQUIRED, ZooKeeperServerNewWizardPage2.CONTROL_NAME_JMX_URL_TEXT, "&Service URL:", null);
                this.addGridTextInput(jmxUrlGridTextInput);
                final GridTextInput userNameGridTextInput = new GridTextInput((Composite)this, GridTextInput.Type.DEFAULT, ZooKeeperServerNewWizardPage2.CONTROL_NAME_USER_NAME_TEXT, "&User Name:", null);
                this.addGridTextInput(userNameGridTextInput);
                final GridTextInput passwordGridTextInput = new GridTextInput((Composite)this, GridTextInput.Type.DEFAULT, ZooKeeperServerNewWizardPage2.CONTROL_NAME_PASSWORD_TEXT, "&Password:           ", null);
                this.addGridTextInput(passwordGridTextInput);
                passwordGridTextInput.getText().setEchoChar('*');
                final Label passwordLabel = new Label((Composite)this, 16448);
                passwordLabel.setText("NOTE:  Password will be stored unencrypted in a file.");
                passwordLabel.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
                SelectionAdapter enableCheckBoxSelectionAdapter = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        boolean enabled = enableCheckBox.getSelection();
                        jmxUrlGridTextInput.setEnabled(enabled);
                        userNameGridTextInput.setEnabled(enabled);
                        passwordGridTextInput.setEnabled(enabled);
                        passwordLabel.setEnabled(enabled);
                        this.modified(enableCheckBox);
                    }
                };
                enableCheckBox.addSelectionListener((SelectionListener)enableCheckBoxSelectionAdapter);
                enableCheckBoxSelectionAdapter.widgetSelected(null);
            }

            protected GridCompositeStatus updateStatus(Object source) {
                GridTextInput gridTextInput;
                Button enableCheckBox = (Button)this.getControl(ZooKeeperServerNewWizardPage2.CONTROL_NAME_ENABLED_BUTTON);
                if (!enableCheckBox.getSelection()) {
                    return GridCompositeStatus.OK_STATUS;
                }
                GridCompositeStatus status = super.updateStatus(source);
                if (status.getType().isError()) {
                    return status;
                }
                if (source instanceof GridTextInput && (gridTextInput = (GridTextInput)source).getName().equals(ZooKeeperServerNewWizardPage2.CONTROL_NAME_JMX_URL_TEXT)) {
                    String jmxUrlString = gridTextInput.getText().getText().trim();
                    try {
                        new JMXServiceURL(jmxUrlString);
                    }
                    catch (MalformedURLException e) {
                        String message = e.getMessage();
                        return new GridCompositeStatus(ZooKeeperServerNewWizardPage2.CONTROL_NAME_JMX_URL_TEXT, message, GridCompositeStatus.Type.ERROR_INVALID);
                    }
                }
                return GridCompositeStatus.OK_STATUS;
            }
        };
        return gridComposite;
    }
}

