/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.wsdl11.xsd;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.xerces.impl.xs.XSDDescription;
import org.apache.xerces.parsers.XMLGrammarPreparser;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.grammars.XSGrammar;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSModel;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.xsd.InlineXSDResolver;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.xsd.ValidateErrorHandler;

public class XSDValidator {
    protected final String HONOUR_ALL_SCHEMA_LOCATIONS_FEATURE_ID = "http://apache.org/xml/features/honour-all-schemaLocations";
    protected final String FILE_PREFIX = "file:";
    protected final String XMLNS = "xmlns";
    protected final String TARGETNAMESPACE = "targetNamespace";
    protected final String NAMESPACE = "namespace";
    protected final String IMPORT = "import";
    protected final String SCHEMALOCATION = "schemaLocation";
    protected final String TYPE = "type";
    protected final String[] ignoreNamespaces = new String[]{"http://www.w3.org/2001/XMLSchema", "http://www.w3.org/1999/XMLSchema"};
    protected XSModel xsModel = null;
    protected boolean isValidXSD = false;
    protected List errors = null;
    protected String filelocation;

    public void validateInlineSchema(String schema, String targetNamespace, String fileloc) {
        this.validateInlineSchema(schema, targetNamespace, fileloc, null, null, null);
    }

    public void validateInlineSchema(String schema, String targetNamespace, String fileloc, XMLEntityResolver entityResolverChain, XMLEntityResolver inlineSchemaEntityResolver, XMLGrammarPool grammarPool) {
        this.filelocation = fileloc;
        this.validateXSD(schema, true, entityResolverChain, targetNamespace, inlineSchemaEntityResolver, grammarPool);
    }

    public void validate(String uri, XMLEntityResolver entityResolver, XMLGrammarPool grammarPool) {
        this.validateXSD(uri, false, entityResolver, null, null, grammarPool);
    }

    protected void validateXSD(String schema, boolean inlineXSD, XMLEntityResolver entityResolver, String targetNamespace, XMLEntityResolver inlineSchemaEntityResolver, XMLGrammarPool grammarPool) {
        ValidateErrorHandler errorHandler = new ValidateErrorHandler();
        try {
            XMLGrammarPreparser grammarPreparser = new XMLGrammarPreparser();
            grammarPreparser.registerPreparser("http://www.w3.org/2001/XMLSchema", null);
            grammarPreparser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
            grammarPreparser.setFeature("http://apache.org/xml/features/namespaces", true);
            grammarPreparser.setFeature("http://apache.org/xml/features/namespace-prefixes", true);
            grammarPreparser.setFeature("http://apache.org/xml/features/validation", true);
            grammarPreparser.setFeature("http://apache.org/xml/features/validation/schema", true);
            grammarPreparser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", false);
            grammarPreparser.setFeature("http://apache.org/xml/features/external-general-entities", true);
            grammarPreparser.setFeature("http://apache.org/xml/features/external-parameter-entities", true);
            grammarPreparser.setFeature("http://apache.org/xml/features/validation/warn-on-duplicate-attdef", true);
            try {
                grammarPreparser.setFeature("http://apache.org/xml/features/honour-all-schemaLocations", true);
            }
            catch (Exception exception) {}
            grammarPreparser.setGrammarPool((XMLGrammarPool)(grammarPool != null ? grammarPool : new XMLGrammarPoolImpl()));
            grammarPreparser.setErrorHandler((XMLErrorHandler)errorHandler);
            if (entityResolver != null) {
                grammarPreparser.setEntityResolver(entityResolver);
            }
            try {
                XMLGrammarDescription desc;
                XMLInputSource is = null;
                ArrayList<Grammar> oldGrammars = null;
                XMLGrammarPoolImpl pool = null;
                if (inlineXSD) {
                    StringReader reader = new StringReader(schema);
                    is = new XMLInputSource(null, this.filelocation, this.filelocation, (Reader)reader, null);
                    ((InlineXSDResolver)inlineSchemaEntityResolver).addReferringSchema(is, targetNamespace);
                    pool = (XMLGrammarPoolImpl)grammarPreparser.getGrammarPool();
                    oldGrammars = new ArrayList<Grammar>();
                    Grammar[] grammars = pool.retrieveInitialGrammarSet("http://www.w3.org/2001/XMLSchema");
                    int numGrammars = grammars.length;
                    int i = 0;
                    while (i < numGrammars) {
                        XSGrammar grammar;
                        StringList namespaces;
                        desc = grammars[i].getGrammarDescription();
                        if (targetNamespace.equals(desc.getNamespace())) {
                            oldGrammars.add(pool.removeGrammar(desc));
                        } else if (grammars[i] instanceof XSGrammar && (namespaces = (grammar = (XSGrammar)grammars[i]).toXSModel().getNamespaces()).contains(targetNamespace)) {
                            oldGrammars.add(pool.removeGrammar(desc));
                        }
                        ++i;
                    }
                    Set inlineNSs = ((InlineXSDResolver)inlineSchemaEntityResolver).getInlineSchemaNSs();
                    Iterator nsiter = inlineNSs.iterator();
                    while (nsiter.hasNext()) {
                        XSDDescription desc2 = new XSDDescription();
                        desc2.setNamespace((String)nsiter.next());
                        Grammar oldGrammar = pool.removeGrammar((XMLGrammarDescription)desc2);
                        if (oldGrammar == null) continue;
                        oldGrammars.add(oldGrammar);
                    }
                } else {
                    is = new XMLInputSource(null, schema, schema);
                }
                XSGrammar grammar = (XSGrammar)grammarPreparser.preparseGrammar("http://www.w3.org/2001/XMLSchema", is);
                this.xsModel = grammar.toXSModel();
                if (inlineXSD && oldGrammars != null) {
                    XSDDescription description = new XSDDescription();
                    description.setNamespace(targetNamespace);
                    pool.removeGrammar((XMLGrammarDescription)description);
                    Set inlineNSs = ((InlineXSDResolver)inlineSchemaEntityResolver).getInlineSchemaNSs();
                    Iterator nsiter = inlineNSs.iterator();
                    while (nsiter.hasNext()) {
                        desc = new XSDDescription();
                        desc.setNamespace((String)nsiter.next());
                        pool.removeGrammar(desc);
                    }
                    Iterator oldGIter = oldGrammars.iterator();
                    while (oldGIter.hasNext()) {
                        Grammar oldGrammar = (Grammar)oldGIter.next();
                        if (oldGrammar == null) continue;
                        pool.putGrammar(oldGrammar);
                    }
                }
            }
            catch (Exception exception) {}
            this.errors = errorHandler.getErrorMessages();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        if (this.errors.isEmpty()) {
            this.isValidXSD = true;
        }
    }

    public XSModel getXSModel() {
        return this.xsModel;
    }

    public boolean isValid() {
        return this.isValidXSD;
    }

    public List getErrors() {
        return this.errors;
    }
}

