/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.dialog;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.core.commands.DeleteCommand;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.IDialogHelper;
import org.eclipse.birt.report.designer.internal.ui.dialogs.helper.IDialogHelperProvider;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.util.WidgetUtil;
import org.eclipse.birt.report.designer.ui.cubebuilder.nls.Messages;
import org.eclipse.birt.report.designer.ui.cubebuilder.provider.CubeExpressionProvider;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.OlapUtil;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.UIHelper;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularDimensionHandle;
import org.eclipse.birt.report.model.api.olap.TabularHierarchyHandle;
import org.eclipse.birt.report.model.api.olap.TabularLevelHandle;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

public class GroupDialog
extends TitleAreaDialog {
    protected ResultSetColumnHandle dataField;
    protected TabularCubeHandle cube;
    protected TabularHierarchyHandle hierarchy;
    private IDialogHelper helper;
    private List levelList = new ArrayList();
    private List dateTypeSelectedList = new ArrayList();
    private Text nameText;
    protected CheckboxTreeViewer levelViewer;
    protected Button regularButton;
    protected Button dateButton;
    private boolean isRegularButton = false;
    protected DimensionHandle dimension;
    protected Composite contents;

    public GroupDialog(TabularHierarchyHandle hierarchy) {
        this();
        this.dimension = (DimensionHandle)hierarchy.getContainer();
        this.hierarchy = hierarchy;
        TabularLevelHandle[] levels = hierarchy.getContents("levels").toArray(new TabularLevelHandle[0]);
        int i = 0;
        while (i < levels.length) {
            if (levels[i].getDateTimeLevelType() != null) {
                this.levelList.add(levels[i].getDateTimeLevelType());
            }
            ++i;
        }
        this.dateTypeSelectedList.addAll(this.levelList);
    }

    public GroupDialog() {
        super(UIUtil.getDefaultShell());
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    public void setInput(TabularCubeHandle cube, ResultSetColumnHandle dataField) {
        this.dataField = dataField;
        this.cube = cube;
    }

    protected Control createDialogArea(Composite parent) {
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.CubeBuilderGroupDialog_ID");
        this.setTitle(Messages.getString("DateGroupDialog.Title"));
        this.getShell().setText(Messages.getString("DateGroupDialog.Shell.Title"));
        this.setMessage(Messages.getString("DateGroupDialog.Message"));
        Composite area = (Composite)super.createDialogArea(parent);
        this.contents = this.createDialogContentComposite(area);
        this.createGroupTypeArea(this.contents);
        this.createContentArea(this.contents);
        WidgetUtil.createGridPlaceholder((Composite)this.contents, (int)1, (boolean)true);
        this.initDialog();
        parent.layout();
        return this.contents;
    }

    protected Composite createDialogContentComposite(Composite area) {
        Composite content = new Composite(area, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 20;
        content.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(80);
        data.heightHint = 300;
        content.setLayoutData((Object)data);
        return content;
    }

    private void createGroupTypeArea(Composite contents) {
        this.regularButton = new Button(contents, 16);
        this.regularButton.setText(Messages.getString("GroupDialog.Button.RegularGroup"));
        this.regularButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroupDialog.this.handleButtonSelection(GroupDialog.this.regularButton);
            }
        });
        this.dateButton = new Button(contents, 16);
        this.dateButton.setText(Messages.getString("GroupDialog.Button.DateGroup"));
        this.dateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GroupDialog.this.handleButtonSelection(GroupDialog.this.dateButton);
            }
        });
    }

    protected void handleButtonSelection(Button button) {
        if (button == this.regularButton) {
            this.regularButton.setSelection(true);
            this.dateButton.setSelection(false);
            WidgetUtil.setExcludeGridData((Control)this.levelViewer.getTree(), (boolean)true);
            this.setMessage("");
            this.isRegularButton = true;
        } else {
            this.regularButton.setSelection(false);
            this.dateButton.setSelection(true);
            if (this.dataField != null) {
                WidgetUtil.setExcludeGridData((Control)this.levelViewer.getTree(), (boolean)false);
                this.setMessage(Messages.getString("DateGroupDialog.Message"));
            } else {
                WidgetUtil.setExcludeGridData((Control)this.levelViewer.getTree(), (boolean)true);
                this.setMessage("");
            }
            this.isRegularButton = false;
        }
        this.levelViewer.getTree().getParent().layout();
        this.checkOKButtonStatus();
    }

    protected void initDialog() {
        if (this.hierarchy != null) {
            this.nameText.setText(this.hierarchy.getContainer().getName());
        } else {
            TabularDimensionHandle dimension = DesignElementFactory.getInstance().newTabularDimension(null);
            this.nameText.setText(dimension.getName());
        }
        if (this.dimension != null) {
            if (this.isTimeType(this.dimension)) {
                this.dateButton.setSelection(true);
                this.handleButtonSelection(this.dateButton);
            } else {
                this.regularButton.setSelection(true);
                this.handleButtonSelection(this.regularButton);
            }
        } else {
            this.dateButton.setSelection(true);
            this.handleButtonSelection(this.dateButton);
        }
        if (this.dimension != null) {
            WidgetUtil.setExcludeGridData((Control)this.regularButton, (boolean)true);
            WidgetUtil.setExcludeGridData((Control)this.dateButton, (boolean)true);
        }
        if (this.dimension != null && !this.isTimeType(this.dimension)) {
            this.levelViewer.getTree().setVisible(false);
        }
        this.levelViewer.setInput((Object)this.getDateTypeNames(this.getLevelTypesByDateType()));
        this.levelViewer.expandAll();
        if (this.levelViewer.getTree().getItemCount() > 0) {
            TreeItem topNode = this.levelViewer.getTree().getItem(0);
            do {
                if (!this.levelList.contains(topNode.getData())) continue;
                topNode.setChecked(true);
            } while ((topNode = topNode.getItem(0)).getItemCount() > 0);
            if (this.levelList.contains(topNode.getData())) {
                topNode.setChecked(true);
            }
        }
        this.checkOKButtonStatus();
    }

    protected boolean isTimeType(DimensionHandle dimension) {
        return dimension.isTimeType();
    }

    private TreeItem getItem(String text) {
        TreeItem topNode = this.levelViewer.getTree().getItem(0);
        do {
            if (!text.equals(topNode.getData())) continue;
            return topNode;
        } while ((topNode = topNode.getItem(0)).getItemCount() > 0);
        if (text.equals(topNode.getData())) {
            return topNode;
        }
        return null;
    }

    private List getDateTypeNames(IChoice[] choices) {
        ArrayList<String> dateTypeList = new ArrayList<String>();
        if (choices == null) {
            return dateTypeList;
        }
        int i = 0;
        while (i < choices.length) {
            dateTypeList.add(choices[i].getName());
            ++i;
        }
        return dateTypeList;
    }

    private String getDateTypeDisplayName(String name) {
        return ChoiceSetFactory.getDisplayNameFromChoiceSet((String)name, (IChoiceSet)OlapUtil.getDateTimeLevelTypeChoiceSet());
    }

    protected void okPressed() {
        this.saveResult();
        super.okPressed();
    }

    /*
     * Unable to fully structure code
     */
    protected void saveResult() {
        v0 = isNew = this.hierarchy == null;
        if (isNew) {
            this.dimension = this.createDimension();
            this.hierarchy = (TabularHierarchyHandle)this.dimension.getDefaultHierarchy();
            if (this.dataField != null) {
                dataset = (DataSetHandle)this.dataField.getElementHandle();
                if (this.hierarchy.getDataSet() == null && this.hierarchy.getLevelCount() == 0 && this.cube != null && dataset != null && dataset != this.cube.getDataSet()) {
                    try {
                        this.hierarchy.setDataSet(dataset);
                    }
                    catch (SemanticException e) {
                        ExceptionUtil.handle((Throwable)e);
                    }
                }
            }
        }
        try {
            this.dimension.setName(this.nameText.getText().trim());
        }
        catch (NameException e1) {
            ExceptionUtil.handle((Throwable)e1);
        }
        if (this.helper != null) {
            try {
                this.helper.validate();
                this.dimension.setExpressionProperty("ACLExpression", (Expression)this.helper.getProperty("Security Expression Property"));
            }
            catch (SemanticException e) {
                ExceptionUtil.handle((Throwable)e);
            }
        }
        if (this.regularButton.getSelection()) {
            try {
                if (this.isTimeType((DimensionHandle)this.hierarchy.getContainer())) {
                    while (this.hierarchy.getContentCount("levels") > 0) {
                        this.hierarchy.dropAndClear("levels", 0);
                    }
                }
                ((DimensionHandle)this.hierarchy.getContainer()).setTimeType(false);
                if (!isNew) ** GOTO lbl119
                level = DesignElementFactory.getInstance().newTabularLevel((DimensionHandle)this.hierarchy.getContainer(), OlapUtil.getDataFieldDisplayName(this.dataField));
                level.setColumnName(this.dataField.getColumnName());
                dataset = this.hierarchy.getDataSet();
                if (dataset == null && this.cube != null) {
                    dataset = this.cube.getDataSet();
                }
                level.setDataType(this.dataField.getDataType());
                column = OlapUtil.getColumnHintHandle(this.dataField);
                if (column != null) {
                    level.setAlignment(column.getHorizontalAlign());
                    level.setFormat(column.getValueFormat());
                }
                this.hierarchy.add("levels", (DesignElementHandle)level);
            }
            catch (SemanticException e) {
                ExceptionUtil.handle((Throwable)e);
                return;
            }
        } else {
            try {
                if (!this.isTimeType((DimensionHandle)this.hierarchy.getContainer())) {
                    while (this.hierarchy.getContentCount("levels") > 0) {
                        this.hierarchy.dropAndClear("levels", 0);
                    }
                }
                ((DimensionHandle)this.hierarchy.getContainer()).setTimeType(true);
            }
            catch (SemanticException e) {
                ExceptionUtil.handle((Throwable)e);
            }
            if (this.levelList.size() > 0) {
                i = 0;
                while (i < OlapUtil.getDateTimeLevelTypeChoices().length) {
                    dateType = OlapUtil.getDateTimeLevelTypeChoices()[i].getName();
                    if (this.levelList.contains(dateType) && !this.dateTypeSelectedList.contains(dateType) && (hasExecuted = OlapUtil.enableDrop(level = this.hierarchy.getLevel(this.levelList.indexOf(dateType))))) {
                        new DeleteCommand((Object)level).execute();
                        this.levelList.remove(dateType);
                    }
                    ++i;
                }
            }
            if (this.levelList.size() == 0) {
                this.sortDataType();
                i = 0;
                while (i < this.dateTypeSelectedList.size()) {
                    dateType = (String)this.dateTypeSelectedList.get(i);
                    level = DesignElementFactory.getInstance().newTabularLevel((DimensionHandle)this.hierarchy.getContainer(), this.getDateTypeDisplayName(dateType));
                    try {
                        this.hierarchy.add("levels", (DesignElementHandle)level);
                        level.setColumnName(this.dataField.getColumnName());
                        level.setDataType("integer");
                        level.setDateTimeLevelType(dateType);
                    }
                    catch (SemanticException e) {
                        ExceptionUtil.handle((Throwable)e);
                    }
                    ++i;
                }
            } else {
                j = 0;
                this.sortDataType();
                i = 0;
                while (i < this.dateTypeSelectedList.size()) {
                    dateType = (String)this.dateTypeSelectedList.get(i);
                    if (!this.levelList.contains(dateType)) {
                        exit = false;
                        while (j < this.levelList.size()) {
                            if (this.getDateTypeNames(this.getLevelTypesByDateType()).indexOf(dateType) < this.getDateTypeNames(this.getLevelTypesByDateType()).indexOf(this.levelList.get(j))) {
                                level = DesignElementFactory.getInstance().newTabularLevel((DimensionHandle)this.hierarchy.getContainer(), this.getDateTypeDisplayName(dateType));
                                try {
                                    this.hierarchy.add("levels", (DesignElementHandle)level, j);
                                    level.setColumnName(this.dataField.getColumnName());
                                    level.setDataType("integer");
                                    level.setDateTimeLevelType(dateType);
                                    this.levelList.add(j, dateType);
                                    exit = true;
                                    break;
                                }
                                catch (SemanticException e) {
                                    ExceptionUtil.handle((Throwable)e);
                                }
                            }
                            ++j;
                        }
                        if (!exit) {
                            level = DesignElementFactory.getInstance().newTabularLevel((DimensionHandle)this.hierarchy.getContainer(), this.getDateTypeDisplayName(dateType));
                            try {
                                this.hierarchy.add("levels", (DesignElementHandle)level);
                                level.setColumnName(this.dataField.getColumnName());
                                level.setDataType("integer");
                                level.setDateTimeLevelType(dateType);
                                this.levelList.add(j++, dateType);
                            }
                            catch (SemanticException e) {
                                ExceptionUtil.handle((Throwable)e);
                            }
                        }
                    }
                    ++i;
                }
            }
        }
lbl119:
        // 4 sources

        if (isNew) {
            this.insertDimension();
        }
    }

    protected void insertDimension() {
        try {
            if (this.cube != null) {
                this.cube.add("dimensions", (DesignElementHandle)this.dimension);
            }
        }
        catch (SemanticException e) {
            e.printStackTrace();
        }
    }

    protected DimensionHandle createDimension() {
        return DesignElementFactory.getInstance().newTabularDimension(null);
    }

    private void sortDataType() {
        ArrayList list = new ArrayList();
        List typeNames = this.getDateTypeNames(this.getLevelTypesByDateType());
        int i = 0;
        while (i < typeNames.size()) {
            Object typeName = typeNames.get(i);
            int j = 0;
            while (j < this.dateTypeSelectedList.size()) {
                if (this.dateTypeSelectedList.get(j).equals(typeName)) {
                    list.add(typeName);
                    break;
                }
                ++j;
            }
            ++i;
        }
        this.dateTypeSelectedList.clear();
        this.dateTypeSelectedList.addAll(list);
    }

    protected void createContentArea(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        content.setLayout((Layout)layout);
        this.createNamePart(content);
        this.createLevelViewerPart(content);
        this.createSecurityPart(content);
    }

    protected void createLevelViewerPart(Composite content) {
        this.levelViewer = new CheckboxTreeViewer(content, 2052);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        this.levelViewer.getTree().setLayoutData((Object)gd);
        DateLevelProvider provider = new DateLevelProvider();
        this.levelViewer.setContentProvider((IContentProvider)provider);
        this.levelViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.levelViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                String itemText = (String)event.getElement();
                TreeItem item = GroupDialog.this.getItem(itemText);
                GroupDialog.this.checkItem(item);
            }
        });
        this.levelViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TreeItem item = GroupDialog.this.levelViewer.getTree().getItem(new Point(e.x, e.y));
                GroupDialog.this.checkItem(item);
            }
        });
        this.levelViewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                TreeItem[] item;
                if (e.character == ' ' && (item = GroupDialog.this.levelViewer.getTree().getSelection()) != null && item.length == 1) {
                    GroupDialog.this.checkItem(item[0]);
                }
            }
        });
    }

    protected Composite createNamePart(Composite content) {
        Composite nameContainer = new Composite(content, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        nameContainer.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        nameContainer.setLayoutData((Object)gd);
        new Label(nameContainer, 0).setText(Messages.getString("DateGroupDialog.Name"));
        this.nameText = new Text(nameContainer, 2048);
        gd = new GridData(768);
        this.nameText.setLayoutData((Object)gd);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GroupDialog.this.checkOKButtonStatus();
            }
        });
        return nameContainer;
    }

    protected void createSecurityPart(Composite parent) {
        if (this.dimension == null) {
            return;
        }
        Object[] helperProviders = ElementAdapterManager.getAdapters((Object)this.dimension, IDialogHelperProvider.class);
        if (helperProviders != null) {
            int i = 0;
            while (i < helperProviders.length) {
                IDialogHelperProvider helperProvider = (IDialogHelperProvider)helperProviders[i];
                if (helperProvider != null && this.helper == null) {
                    this.helper = helperProvider.createHelper((Object)this, "Security Helper");
                    if (this.helper != null) {
                        this.helper.setProperty("Security Label", (Object)Messages.getString("GroupDialog.Access.Control.List.Expression"));
                        this.helper.setProperty("Security Expression Context", (Object)this.dimension);
                        this.helper.setProperty("Security Expression Provider", (Object)new CubeExpressionProvider((DesignElementHandle)this.dimension));
                        this.helper.setProperty("Security Expression Property", (Object)this.dimension.getACLExpression());
                        this.helper.createContent(parent);
                        this.helper.addListener(24, new Listener(){

                            public void handleEvent(Event event) {
                                GroupDialog.this.helper.update(false);
                            }
                        });
                        this.helper.update(true);
                    }
                }
                ++i;
            }
        }
    }

    protected void checkOKButtonStatus() {
        if (this.nameText.getText().trim().length() == 0) {
            if (this.getButton(0) != null) {
                this.getButton(0).setEnabled(false);
            }
            this.setMessage(null);
            this.setErrorMessage(Messages.getString("DateGroupDialog.Message.BlankName"));
        } else if (!UIUtil.validateDimensionName((String)this.nameText.getText())) {
            if (this.getButton(0) != null) {
                this.getButton(0).setEnabled(false);
            }
            this.setMessage(null);
            this.setErrorMessage(Messages.getString("DateGroupDialog.Message.NumericName"));
        } else if (this.checkDuplicateName(this.nameText.getText())) {
            if (this.getButton(0) != null) {
                this.getButton(0).setEnabled(false);
            }
            this.setMessage(null);
            this.setErrorMessage(Messages.getString("DateGroupDialog.Message.DuplicateName"));
        } else if (this.dateButton.getSelection() && this.dateTypeSelectedList.size() == 0 && (this.dimension == null || this.dataField != null)) {
            if (this.getButton(0) != null) {
                this.getButton(0).setEnabled(false);
            }
            this.setErrorMessage(null);
            this.setMessage(Messages.getString("DateGroupDialog.Message"));
        } else if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(true);
            if (this.isRegularButton) {
                this.setErrorMessage(null);
                this.setMessage(Messages.getString("DateGroupDialog.Message.Regular"));
            } else {
                this.setErrorMessage(null);
                this.setMessage(Messages.getString("DateGroupDialog.Message"));
            }
        }
    }

    protected boolean checkDuplicateName(String name) {
        try {
            DimensionHandle dimension = SessionHandleAdapter.getInstance().getReportDesignHandle().findDimension(name);
            DimensionHandle input = null;
            if (this.hierarchy != null) {
                input = (DimensionHandle)this.hierarchy.getContainer();
            }
            if (dimension != null && dimension != input) {
                return true;
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return false;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.checkOKButtonStatus();
    }

    public void setInput(TabularHierarchyHandle hierarchy) {
        if (hierarchy.getLevelCount() == 0) {
            this.setInput(hierarchy, null);
        } else if (!this.isDateType(hierarchy, ((TabularLevelHandle)hierarchy.getLevel(0)).getColumnName())) {
            this.setInput(hierarchy, null);
        } else {
            DataSetHandle dataset = this.getDataSet(hierarchy);
            this.setInput(hierarchy, OlapUtil.getDataField(dataset, ((TabularLevelHandle)hierarchy.getLevel(0)).getColumnName()));
        }
    }

    protected DataSetHandle getDataSet(TabularHierarchyHandle hierarchy) {
        DataSetHandle dataset = hierarchy.getDataSet();
        if (dataset == null) {
            dataset = ((TabularCubeHandle)hierarchy.getContainer().getContainer()).getDataSet();
        }
        return dataset;
    }

    private void setInput(TabularHierarchyHandle hierarchy, ResultSetColumnHandle dataField) {
        this.dimension = (DimensionHandle)hierarchy.getContainer();
        this.dataField = dataField;
        this.hierarchy = hierarchy;
        TabularLevelHandle[] levels = hierarchy.getContents("levels").toArray(new TabularLevelHandle[0]);
        int i = 0;
        while (i < levels.length) {
            if (levels[i].getDateTimeLevelType() != null) {
                this.levelList.add(levels[i].getDateTimeLevelType());
            }
            ++i;
        }
        this.dateTypeSelectedList.addAll(this.levelList);
    }

    private IChoice[] getLevelTypesByDateType() {
        if (this.dataField == null) {
            return null;
        }
        String dataType = this.dataField.getDataType();
        if (dataType.equals("date-time")) {
            return OlapUtil.getDateTimeLevelTypeChoices();
        }
        if (dataType.equals("date")) {
            return OlapUtil.getDateLevelTypeChoices();
        }
        return OlapUtil.getTimeLevelTypeChoices();
    }

    private boolean isDateType(TabularHierarchyHandle hierarchy, String columnName) {
        ResultSetColumnHandle column = OlapUtil.getDataField(OlapUtil.getHierarchyDataset(hierarchy), columnName);
        if (column == null) {
            return false;
        }
        String dataType = column.getDataType();
        return dataType.equals("date-time") || dataType.equals("date") || dataType.equals("time");
    }

    private void checkItem(TreeItem item) {
        if (item != null) {
            item.setChecked(!item.getChecked());
            this.levelViewer.getTree().setSelection(item);
            if (item.getChecked()) {
                if (!this.dateTypeSelectedList.contains(item.getData())) {
                    this.dateTypeSelectedList.add(item.getData());
                }
            } else if (this.dateTypeSelectedList.contains(item.getData())) {
                this.dateTypeSelectedList.remove(item.getData());
            }
            this.checkOKButtonStatus();
        }
    }

    public DimensionHandle getResult() {
        return this.dimension;
    }

    class DateLevelProvider
    extends LabelProvider
    implements ITreeContentProvider {
        DateLevelProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            int index = GroupDialog.this.getDateTypeNames(GroupDialog.this.getLevelTypesByDateType()).indexOf(parentElement);
            return new Object[]{GroupDialog.this.getDateTypeNames(GroupDialog.this.getLevelTypesByDateType()).get(index + 1)};
        }

        public Object getParent(Object element) {
            int index = GroupDialog.this.getDateTypeNames(GroupDialog.this.getLevelTypesByDateType()).indexOf(element);
            if (index == 0) {
                return null;
            }
            return GroupDialog.this.getDateTypeNames(GroupDialog.this.getLevelTypesByDateType()).get(index - 1);
        }

        public boolean hasChildren(Object element) {
            int index = GroupDialog.this.getDateTypeNames(GroupDialog.this.getLevelTypesByDateType()).indexOf(element);
            return index < GroupDialog.this.getDateTypeNames(GroupDialog.this.getLevelTypesByDateType()).size() - 1;
        }

        public Object[] getElements(Object inputElement) {
            if (GroupDialog.this.getLevelTypesByDateType() != null && GroupDialog.this.getLevelTypesByDateType().length > 0) {
                return new Object[]{GroupDialog.this.getDateTypeNames(GroupDialog.this.getLevelTypesByDateType()).get(0)};
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getImage(Object element) {
            return UIHelper.getImage("icons/obj16/data_column.gif");
        }

        public String getText(Object element) {
            return GroupDialog.this.getDateTypeDisplayName(element.toString());
        }
    }
}

