/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.repository;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.Authentication;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataStoreException;
import org.apache.maven.repository.Proxy;
import org.apache.maven.repository.legacy.metadata.ArtifactMetadata;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.metadata.Metadata;
import org.sonatype.aether.repository.LocalArtifactRegistration;
import org.sonatype.aether.repository.LocalArtifactRequest;
import org.sonatype.aether.repository.LocalArtifactResult;
import org.sonatype.aether.repository.LocalMetadataRegistration;
import org.sonatype.aether.repository.LocalMetadataRequest;
import org.sonatype.aether.repository.LocalMetadataResult;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.LocalRepositoryManager;
import org.sonatype.aether.repository.RemoteRepository;

public class LegacyLocalRepositoryManager
implements LocalRepositoryManager {
    private final ArtifactRepository delegate;
    private final LocalRepository repo;

    public static LocalRepositoryManager wrap(ArtifactRepository repository, RepositorySystem system) {
        ArtifactRepositoryLayout layout = repository.getLayout();
        if (layout != null && layout.getClass().equals(DefaultRepositoryLayout.class)) {
            return system.newLocalRepositoryManager(new LocalRepository(repository.getBasedir()));
        }
        return new LegacyLocalRepositoryManager(repository);
    }

    private LegacyLocalRepositoryManager(ArtifactRepository delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("local repository delegate missing");
        }
        this.delegate = delegate;
        ArtifactRepositoryLayout layout = delegate.getLayout();
        this.repo = new LocalRepository(new File(delegate.getBasedir()), layout != null ? layout.getClass().getSimpleName() : "legacy");
    }

    public LocalRepository getRepository() {
        return this.repo;
    }

    public String getPathForLocalArtifact(org.sonatype.aether.artifact.Artifact artifact) {
        return this.delegate.pathOf(RepositoryUtils.toArtifact((org.sonatype.aether.artifact.Artifact)artifact));
    }

    public String getPathForRemoteArtifact(org.sonatype.aether.artifact.Artifact artifact, RemoteRepository repository, String context) {
        return this.getPathForLocalArtifact(artifact);
    }

    public String getPathForLocalMetadata(Metadata metadata) {
        return this.delegate.pathOfLocalRepositoryMetadata((org.apache.maven.artifact.metadata.ArtifactMetadata)new ArtifactMetadataAdapter(metadata), this.delegate);
    }

    public String getPathForRemoteMetadata(Metadata metadata, RemoteRepository repository, String context) {
        return this.delegate.pathOfLocalRepositoryMetadata((org.apache.maven.artifact.metadata.ArtifactMetadata)new ArtifactMetadataAdapter(metadata), (ArtifactRepository)new ArtifactRepositoryAdapter(repository));
    }

    public LocalArtifactResult find(RepositorySystemSession session, LocalArtifactRequest request) {
        String path = this.getPathForLocalArtifact(request.getArtifact());
        File file = new File(this.getRepository().getBasedir(), path);
        LocalArtifactResult result = new LocalArtifactResult(request);
        if (file.isFile()) {
            result.setFile(file);
            result.setAvailable(true);
        }
        return result;
    }

    public LocalMetadataResult find(RepositorySystemSession session, LocalMetadataRequest request) {
        Metadata metadata = request.getMetadata();
        String path = request.getRepository() == null ? this.getPathForLocalMetadata(metadata) : this.getPathForRemoteMetadata(metadata, request.getRepository(), request.getContext());
        File file = new File(this.getRepository().getBasedir(), path);
        LocalMetadataResult result = new LocalMetadataResult(request);
        if (file.isFile()) {
            result.setFile(file);
        }
        return result;
    }

    public void add(RepositorySystemSession session, LocalArtifactRegistration request) {
    }

    public void add(RepositorySystemSession session, LocalMetadataRegistration request) {
    }

    static class ArtifactMetadataAdapter
    implements org.apache.maven.artifact.metadata.ArtifactMetadata {
        private final Metadata metadata;

        public ArtifactMetadataAdapter(Metadata metadata) {
            this.metadata = metadata;
        }

        public boolean storedInArtifactVersionDirectory() {
            return this.metadata.getVersion().length() > 0;
        }

        public boolean storedInGroupDirectory() {
            return this.metadata.getArtifactId().length() <= 0;
        }

        public String getGroupId() {
            return this.nullify(this.metadata.getGroupId());
        }

        public String getArtifactId() {
            return this.nullify(this.metadata.getArtifactId());
        }

        public String getBaseVersion() {
            return this.nullify(this.metadata.getVersion());
        }

        private String nullify(String str) {
            return str == null || str.length() <= 0 ? null : str;
        }

        public Object getKey() {
            return this.metadata.toString();
        }

        public String getRemoteFilename() {
            return this.metadata.getType();
        }

        public String getLocalFilename(ArtifactRepository repository) {
            return this.insertRepositoryKey(this.getRemoteFilename(), repository.getKey());
        }

        private String insertRepositoryKey(String filename, String repositoryKey) {
            int idx = filename.indexOf(46);
            String result = idx < 0 ? filename + '-' + repositoryKey : filename.substring(0, idx) + '-' + repositoryKey + filename.substring(idx);
            return result;
        }

        public void merge(ArtifactMetadata metadata) {
        }

        public void merge(org.apache.maven.artifact.metadata.ArtifactMetadata metadata) {
        }

        public void storeInLocalRepository(ArtifactRepository localRepository, ArtifactRepository remoteRepository) throws RepositoryMetadataStoreException {
        }

        public String extendedToString() {
            return this.metadata.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ArtifactRepositoryAdapter
    implements ArtifactRepository {
        private final RemoteRepository repository;

        public ArtifactRepositoryAdapter(RemoteRepository repository) {
            this.repository = repository;
        }

        public String pathOf(Artifact artifact) {
            return null;
        }

        public String pathOfRemoteRepositoryMetadata(org.apache.maven.artifact.metadata.ArtifactMetadata artifactMetadata) {
            return null;
        }

        public String pathOfLocalRepositoryMetadata(org.apache.maven.artifact.metadata.ArtifactMetadata metadata, ArtifactRepository repository) {
            return null;
        }

        public String getUrl() {
            return this.repository.getUrl();
        }

        public void setUrl(String url) {
        }

        public String getBasedir() {
            return null;
        }

        public String getProtocol() {
            return this.repository.getProtocol();
        }

        public String getId() {
            return this.repository.getId();
        }

        public void setId(String id) {
        }

        public ArtifactRepositoryPolicy getSnapshots() {
            return null;
        }

        public void setSnapshotUpdatePolicy(ArtifactRepositoryPolicy policy) {
        }

        public ArtifactRepositoryPolicy getReleases() {
            return null;
        }

        public void setReleaseUpdatePolicy(ArtifactRepositoryPolicy policy) {
        }

        public ArtifactRepositoryLayout getLayout() {
            return null;
        }

        public void setLayout(ArtifactRepositoryLayout layout) {
        }

        public String getKey() {
            return this.getId();
        }

        public boolean isUniqueVersion() {
            return true;
        }

        public boolean isBlacklisted() {
            return false;
        }

        public void setBlacklisted(boolean blackListed) {
        }

        public Artifact find(Artifact artifact) {
            return null;
        }

        public List<String> findVersions(Artifact artifact) {
            return Collections.emptyList();
        }

        public boolean isProjectAware() {
            return false;
        }

        public void setAuthentication(Authentication authentication) {
        }

        public Authentication getAuthentication() {
            return null;
        }

        public void setProxy(Proxy proxy) {
        }

        public Proxy getProxy() {
            return null;
        }
    }
}

