/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric;

import com.fusesource.ide.fabric.FabricNotConnectedException;
import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.actions.FabricDetails;
import com.fusesource.ide.fabric.actions.jclouds.JClouds;
import com.fusesource.ide.fabric.navigator.Fabric;
import com.fusesource.rider.commons.Bundles;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.ContainerProvider;
import org.fusesource.fabric.api.FabricService;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.service.FabricServiceImpl;
import org.fusesource.fabric.service.jclouds.JcloudsContainerProvider;
import org.fusesource.fabric.service.jclouds.firewall.FirewallManagerFactory;
import org.fusesource.fabric.service.jclouds.firewall.ProviderFirewallSupport;
import org.fusesource.fabric.service.jclouds.firewall.internal.Ec2FirewallSupport;
import org.fusesource.fabric.service.jclouds.firewall.internal.FirewallManagerFactoryImpl;
import org.fusesource.fabric.service.jclouds.modules.ZookeeperCredentialStore;
import org.fusesource.fabric.service.ssh.SshContainerProvider;
import org.fusesource.fabric.zookeeper.spring.ZKClientFactoryBean;
import org.jclouds.karaf.core.CredentialStore;
import org.linkedin.zookeeper.client.IZKClient;
import org.linkedin.zookeeper.client.LifecycleListener;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class FabricConnector {
    private final Fabric fabric;
    private final FabricDetails details;
    private final String url;
    private FabricService fabricService;
    private AtomicBoolean initialised = new AtomicBoolean(false);
    private AtomicBoolean connected = new AtomicBoolean(false);
    private boolean blueprintFabricServiceDoesNotWork = true;
    private IZKClient zooKeeper;
    private Watcher watcher = new Watcher(){

        public void process(WatchedEvent event) {
            FabricConnector.this.onWatchEvent(event);
        }
    };

    public FabricConnector(Fabric fabric) {
        this.fabric = fabric;
        this.details = fabric.getDetails();
        this.url = this.details.getUrls();
    }

    protected void initialised() throws Exception {
        FabricServiceImpl impl;
        BundleContext context = this.getBundleContext();
        Bundles.startBundle((BundleContext)context, (String)"org.fusesource.fabric.fabric-core-agent-ssh");
        Bundles.startBundle((BundleContext)context, (String)"org.fusesource.fabric.fabric-core-agent-jclouds");
        Bundles.startBundle((BundleContext)context, (String)"org.fusesource.fabric.fabric-core");
        Bundles.startBundle((BundleContext)context, (String)"org.fusesource.fabric");
        Bundles.startBundle((BundleContext)context, (String)"org.eclipse.osgi.services");
        Bundles.startBundle((BundleContext)context, (String)"org.eclipse.equinox.cm");
        FabricPlugin.getLogger().debug("Starting to connect Fabric on: " + this.url);
        if (this.fabricService == null) {
            this.fabricService = (FabricService)Bundles.lookupService((BundleContext)context, FabricService.class);
            if (this.fabricService != null && this.blueprintFabricServiceDoesNotWork) {
                this.fabricService = null;
            }
        }
        if (this.fabricService == null) {
            impl = new FabricServiceImpl();
            this.zooKeeper = this.createZooKeeper();
            impl.setZooKeeper(this.zooKeeper);
            this.fabricService = impl;
        }
        if (this.fabricService != null) {
            if (this.fabricService instanceof FabricServiceImpl) {
                Object providers;
                ConfigurationAdmin configurationAdmin;
                impl = (FabricServiceImpl)this.fabricService;
                this.zooKeeper = impl.getZooKeeper();
                if (this.zooKeeper == null) {
                    System.out.println("=================== no ZK service so setting it...");
                    this.zooKeeper = this.createZooKeeper();
                    impl.setZooKeeper(this.zooKeeper);
                }
                if ((configurationAdmin = impl.getConfigurationAdmin()) == null) {
                    configurationAdmin = (ConfigurationAdmin)Bundles.lookupService((BundleContext)context, ConfigurationAdmin.class);
                    if (configurationAdmin != null) {
                        Hashtable<String, Object> properties;
                        impl.setConfigurationAdmin(configurationAdmin);
                        Configuration config = configurationAdmin.getConfiguration("org.fusesource.fabric.zookeeper", null);
                        if (config == null) {
                            config = configurationAdmin.createFactoryConfiguration("org.fusesource.fabric.zookeeper");
                        }
                        if ((properties = config.getProperties()) == null) {
                            properties = new Hashtable<String, Object>();
                        }
                        String zooKeeperUrl = (String)((Dictionary)properties).get("zookeeper.url");
                        String u = this.getUrl();
                        ((Dictionary)properties).put("zookeeper.url", u);
                        config.update(properties);
                        System.out.println("Config admin has properties: " + config.getProperties());
                    } else {
                        System.out.println("================ cant find FabricService or ConfigurationAdmin in OSGi registry! Must not be started yet!");
                    }
                }
                System.out.println("Config admin: " + configurationAdmin);
                if (this.blueprintFabricServiceDoesNotWork) {
                    providers = Bundles.lookupServicesMap((BundleContext)context, ContainerProvider.class);
                    Set entrySet = providers.entrySet();
                    for (Map.Entry entry : entrySet) {
                        ContainerProvider provider = (ContainerProvider)entry.getKey();
                        try {
                            impl.registerProvider(provider, (Map)entry.getValue());
                        }
                        catch (Exception e) {
                            FabricPlugin.getLogger().warning("Failed to add FabricAgent provider " + provider + ". " + e, (Throwable)e);
                        }
                    }
                    if (impl.getProviders().size() < 3) {
                        SshContainerProvider ssh = new SshContainerProvider();
                        impl.registerProvider("ssh", (ContainerProvider)ssh);
                        JcloudsContainerProvider jclouds = new JcloudsContainerProvider();
                        ZookeeperCredentialStore credentialStore = new ZookeeperCredentialStore();
                        credentialStore.setZooKeeper(this.getZooKeeper());
                        credentialStore.init();
                        jclouds.setCredentialStore((CredentialStore)credentialStore);
                        FirewallManagerFactoryImpl firewallManagerFactory = new FirewallManagerFactoryImpl();
                        firewallManagerFactory.bind((ProviderFirewallSupport)new Ec2FirewallSupport());
                        jclouds.setFirewallManagerFactory((FirewallManagerFactory)firewallManagerFactory);
                        JClouds.bindProviders(jclouds);
                        impl.registerProvider("jclouds", (ContainerProvider)jclouds);
                    }
                }
                providers = impl.getProviders().values();
                Iterator iterator = providers.iterator();
                while (iterator.hasNext()) {
                    ContainerProvider provider = (ContainerProvider)iterator.next();
                    System.out.println("=================== Fabric Agent Provider: " + provider);
                }
            }
            this.addWatcher();
        } else {
            FabricPlugin.getLogger().warning("Fabric not found on url: " + this.url);
        }
    }

    public IZKClient getZooKeeper() {
        return this.zooKeeper;
    }

    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    public Container[] getAgents() {
        FabricService service = this.getFabricService();
        if (service == null) {
            return null;
        }
        return service.getContainers();
    }

    public Version[] getVersions() {
        FabricService service = this.getFabricService();
        if (service == null) {
            return null;
        }
        return service.getVersions();
    }

    public BundleContext getBundleContext() {
        return FabricPlugin.getDefault().getBundle().getBundleContext();
    }

    public String getName() {
        return this.details.getName();
    }

    public String getUrl() {
        return this.url;
    }

    public String getDefaultVersionId() {
        Version defaultVersion;
        FabricService service = this.getFabricService();
        if (service != null && (defaultVersion = service.getDefaultVersion()) != null) {
            return defaultVersion.getName();
        }
        return null;
    }

    public FabricService getFabricService() {
        this.checkConnected();
        return this.fabricService;
    }

    public void checkConnected() {
        if (this.initialised.compareAndSet(false, true)) {
            try {
                this.initialised();
            }
            catch (Exception e) {
                throw new FabricNotConnectedException(this, e);
            }
        }
    }

    public void setFabricService(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    private IZKClient createZooKeeper() throws Exception {
        IZKClient answer = (IZKClient)Bundles.lookupService((BundleContext)this.getBundleContext(), IZKClient.class);
        if (answer == null || this.blueprintFabricServiceDoesNotWork) {
            ZKClientFactoryBean factory = new ZKClientFactoryBean();
            FabricPlugin.getLogger().info("Trying to connect to fabric on: " + this.url);
            factory.setConnectString(this.url);
            answer = factory.getObject();
            if (answer == null) {
                FabricPlugin.getLogger().warning("No Fabric ZooKeeper found");
            } else {
                answer.registerListener(new LifecycleListener(){

                    public void onDisconnected() {
                        FabricPlugin.getLogger().info("Fabric ZooKeeper disconnected");
                        FabricConnector.this.connected.set(false);
                    }

                    public void onConnected() {
                        FabricPlugin.getLogger().info("Fabric ZooKeeper connected");
                        FabricConnector.this.connected.set(true);
                    }
                });
            }
        }
        return answer;
    }

    public void dispose() {
        if (this.blueprintFabricServiceDoesNotWork && this.fabricService instanceof FabricServiceImpl) {
            FabricServiceImpl impl = (FabricServiceImpl)this.fabricService;
            IZKClient zooKeeper = impl.getZooKeeper();
            try {
                zooKeeper.close();
            }
            catch (Exception e) {
                FabricPlugin.getLogger().warning("Failed to disconnect from ZooKeeper for " + (Object)((Object)this.details) + ". " + e, (Throwable)e);
            }
        }
    }

    protected void onWatchEvent(WatchedEvent event) {
        System.out.println("=================== ZK watcher: " + event);
        this.addWatcher();
        this.fabric.onZooKeeperUpdate();
    }

    protected void addWatcher() {
        if (this.zooKeeper != null) {
            this.addWatcher("/fabric/registry/containers/provision");
            this.addWatcher("/fabric/registry/containers/alive");
            this.addWatcher("/fabric/registry/containers/config");
        } else {
            FabricPlugin.getLogger().warning("No ZooKeeper connection!");
        }
    }

    private boolean addWatcher(String path) {
        try {
            if (this.zooKeeper.exists(path) != null) {
                this.zooKeeper.getChildren(path, this.watcher);
                return true;
            }
        }
        catch (Exception e) {
            FabricPlugin.getLogger().warning("Failed to add watcher: " + e, (Throwable)e);
        }
        return false;
    }
}

