/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric;

import com.fusesource.ide.fabric.navigator.FabricNodeProvider;
import com.fusesource.ide.fabric.navigator.FabricPreferenceInitializer;
import com.fusesource.ide.fabric.navigator.NodeProvider;
import com.fusesource.ide.jmx.core.JMXActivator;
import com.fusesource.rider.commons.Bundles;
import com.fusesource.rider.commons.logging.RiderLogFacade;
import com.fusesource.rider.commons.ui.ImagesActivatorSupport;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanServer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class FabricPlugin
extends ImagesActivatorSupport {
    public static final String PLUGIN_ID = "com.fusesource.ide.fabric";
    public static final String TERMINAL_VIEW_ID = "com.fusesource.rider.server.karaf.view.TerminalView";
    private static IViewPart part;
    private static FabricPlugin plugin;
    private static List<NodeProvider> nodeProviders;
    private static FabricNodeProvider nodeProvider;
    private static AtomicBoolean started;
    public static final IPath ICONS_PATH;

    static {
        nodeProviders = new CopyOnWriteArrayList<NodeProvider>();
        started = new AtomicBoolean(false);
        ICONS_PATH = new Path("$nl$/icons/full");
    }

    public static FabricPlugin getPlugin() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        MBeanServer mbeanServer = (MBeanServer)Bundles.lookupService((BundleContext)context, MBeanServer.class);
        if (mbeanServer == null) {
            System.out.println("================== no MBeanServer in OSGi registry so creating one");
            mbeanServer = ManagementFactory.getPlatformMBeanServer();
            System.out.println("================== found platform MBeanServer: " + mbeanServer);
            context.registerService(MBeanServer.class, (Object)mbeanServer, null);
            System.out.println("================== registered MBeanServer!" + mbeanServer);
        }
        Bundles.stopBundle((BundleContext)context, (String)"jersey-client");
        Bundles.stopBundle((BundleContext)context, (String)"jersey-core");
        Bundles.startBundle((BundleContext)context, (String)"jersey-core");
        Bundles.startBundle((BundleContext)context, (String)"jersey-client");
        Bundles.startBundle((BundleContext)context, (String)"jackson");
        Bundles.startBundle((BundleContext)context, (String)"jsr311");
        Bundles.startBundle((BundleContext)context, (String)"aries.util");
        Bundles.startBundle((BundleContext)context, (String)"aries.jmx");
        Bundles.startBundle((BundleContext)context, (String)"aries.proxy");
        boolean useBlueprint = false;
        if (useBlueprint) {
            Bundles.startBundle((BundleContext)context, (String)"aries.quiesce");
            Bundles.startBundle((BundleContext)context, (String)"blueprint");
        }
        Bundles.startBundle((BundleContext)context, (String)"fabric-core-agent-ssh");
        Bundles.startBundle((BundleContext)context, (String)"fabric-core-agent-jclouds");
        Bundles.startBundle((BundleContext)context, (String)"fabric-core");
        Bundles.startBundle((BundleContext)context, (String)"maven-proxy");
        plugin = this;
        FabricPlugin.registerPlugins();
    }

    public void stop(BundleContext context) throws Exception {
        FabricPlugin.unregisterPlugins();
        plugin = null;
        super.stop(context);
    }

    public static ImagesActivatorSupport getDefault() {
        return plugin;
    }

    public static RiderLogFacade getLogger() {
        return RiderLogFacade.getLog((ILog)FabricPlugin.getDefault().getLog());
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        FabricPlugin.setImageDescriptors(action, "lcl16", iconName);
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        ImageDescriptor id = FabricPlugin.create("d" + type, relPath, false);
        if (id != null) {
            action.setDisabledImageDescriptor(id);
        }
        ImageDescriptor descriptor = FabricPlugin.create("e" + type, relPath, true);
        action.setHoverImageDescriptor(descriptor);
        action.setImageDescriptor(descriptor);
    }

    private static ImageDescriptor create(String prefix, String name, boolean useMissingImageDescriptor) {
        IPath path = ICONS_PATH.append(prefix).append(name);
        return FabricPlugin.createImageDescriptor(FabricPlugin.getDefault().getBundle(), path, useMissingImageDescriptor);
    }

    private static ImageDescriptor createImageDescriptor(Bundle bundle, IPath path, boolean useMissingImageDescriptor) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        if (useMissingImageDescriptor) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return null;
    }

    public static void addNodeProvider(NodeProvider nodeProvider) {
        if (nodeProvider != null && !nodeProviders.contains(nodeProvider)) {
            nodeProviders.add(nodeProvider);
        }
    }

    public static void removeNodeProvider(NodeProvider nodeProvider) {
        if (nodeProvider != null) {
            nodeProviders.remove(nodeProvider);
        }
    }

    public static List<NodeProvider> getNodeProviders() {
        return nodeProviders;
    }

    public static void showUserError(String title, String message, Exception e) {
        FabricPlugin.showUserError((String)PLUGIN_ID, (RiderLogFacade)FabricPlugin.getLogger(), (String)title, (String)message, (Exception)e);
    }

    public static void registerPlugins() {
        if (started.compareAndSet(false, true)) {
            new FabricPreferenceInitializer().initializeDefaultPreferences();
            nodeProvider = new FabricNodeProvider();
            FabricPlugin.addNodeProvider(nodeProvider);
            JMXActivator.addNodeProvider((com.fusesource.ide.jmx.core.tree.NodeProvider)nodeProvider);
        }
    }

    public static void unregisterPlugins() {
        if (nodeProvider != null) {
            JMXActivator.removeNodeProvider((com.fusesource.ide.jmx.core.tree.NodeProvider)nodeProvider);
            FabricPlugin.removeNodeProvider(nodeProvider);
        }
        started.set(false);
    }

    public static IViewPart openTerminalView() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage activePage;
                IWorkbenchWindow activeWindow;
                IWorkbench wb = PlatformUI.getWorkbench();
                if (wb != null && (activeWindow = wb.getActiveWorkbenchWindow()) != null && (activePage = activeWindow.getActivePage()) != null) {
                    try {
                        part = activePage.showView(FabricPlugin.TERMINAL_VIEW_ID);
                    }
                    catch (CoreException ex) {
                        FabricPlugin.getLogger().error("Unable to create the terminal view!", (Throwable)ex);
                    }
                }
            }
        });
        return part;
    }
}

