/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric;

import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.RethrowRuntimeException;
import com.fusesource.ide.jmx.core.IConnectionWrapper;
import com.fusesource.ide.jmx.core.IJMXRunnable;
import com.fusesource.ide.jmx.core.JMXException;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import org.fusesource.fabric.api.FabricException;
import org.fusesource.fabric.service.JmxTemplateSupport;
import org.fusesource.fabric.service.LocalJMXConnector;

public class JmxPluginJmxTemplate
extends JmxTemplateSupport {
    private final IConnectionWrapper connectionWrapper;

    public JmxPluginJmxTemplate(IConnectionWrapper connectionWrapper) {
        this.connectionWrapper = connectionWrapper;
    }

    public <T> T execute(final JmxTemplateSupport.JmxConnectorCallback<T> callback) {
        final Object[] answerHolder = new Object[1];
        try {
            this.connectionWrapper.run(new IJMXRunnable(){

                public void run(MBeanServerConnection connection) throws JMXException {
                    try {
                        Object answer;
                        JMXConnector connector = JmxPluginJmxTemplate.this.connectionWrapper.getConnector();
                        if (connector == null) {
                            connector = new LocalJMXConnector(connection);
                        }
                        answerHolder[0] = answer = callback.doWithJmxConnector(connector);
                    }
                    catch (Exception e) {
                        FabricPlugin.getLogger().warning("Failed to connect to JMX: " + e, (Throwable)e);
                    }
                }
            });
            return (T)answerHolder[0];
        }
        catch (Exception e) {
            throw new FabricException((Throwable)e);
        }
    }

    public <T> T executeAndThrow(final JmxTemplateSupport.JmxConnectorCallback<T> callback) throws Exception {
        final Object[] answerHolder = new Object[1];
        try {
            this.connectionWrapper.run(new IJMXRunnable(){

                public void run(MBeanServerConnection connection) throws JMXException {
                    try {
                        Object answer;
                        JMXConnector connector = JmxPluginJmxTemplate.this.connectionWrapper.getConnector();
                        if (connector == null) {
                            connector = new LocalJMXConnector(connection);
                        }
                        answerHolder[0] = answer = callback.doWithJmxConnector(connector);
                    }
                    catch (Exception e) {
                        throw new RethrowRuntimeException(e);
                    }
                }
            });
            return (T)answerHolder[0];
        }
        catch (RethrowRuntimeException e) {
            e.rethrowCause();
            return null;
        }
    }
}

