/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.actions;

import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.actions.CreateChildContainerDialog;
import com.fusesource.ide.fabric.actions.CreateChildContainerForm;
import com.fusesource.ide.fabric.actions.Messages;
import com.fusesource.ide.fabric.navigator.ContainerNode;
import com.fusesource.ide.fabric.navigator.Fabric;
import com.fusesource.ide.fabric.navigator.ProfileNode;
import com.fusesource.rider.commons.ui.actions.ActionSupport;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;

public class CreateChildContainerAction
extends ActionSupport {
    private ContainerNode containerNode;
    private Fabric fabric;
    private ProfileNode profileNode;

    public CreateChildContainerAction(ContainerNode containerNode) {
        super(Messages.createChildAgentMenuLabel, Messages.createChildAgentToolTip, FabricPlugin.getDefault().getImageDescriptor("add_obj.gif"));
        this.containerNode = containerNode;
        this.setImageDescriptor(FabricPlugin.getDefault().getImageDescriptor("new_child_container.png"));
    }

    public CreateChildContainerAction(Fabric fabric) {
        this((ContainerNode)null);
        this.fabric = fabric;
    }

    public CreateChildContainerAction(ProfileNode profileNode) {
        this(profileNode.getFabric());
        this.profileNode = profileNode;
    }

    public void run() {
        List<ContainerNode> roots;
        ContainerNode node = this.containerNode;
        if (node == null && this.fabric != null && (roots = this.fabric.getRootContainers()).size() > 0) {
            node = roots.get(0);
        }
        if (node == null) {
            FabricPlugin.getLogger().warning("No Roto container node available for fabric: " + this.fabric);
        } else {
            CreateChildContainerForm childContainerForm;
            CreateChildContainerDialog dialog = new CreateChildContainerDialog(node, node.getFabric().getNewAgentName());
            if (this.profileNode != null && (childContainerForm = dialog.getChildContainerForm()) != null) {
                childContainerForm.setInitialProfileSelections(this.profileNode.getProfile());
            }
            dialog.open();
        }
    }

    public static void addIfSingleRootContainer(IMenuManager menu, Fabric fabric) {
        List<ContainerNode> roots = fabric.getRootContainers();
        if (roots.size() == 1) {
            ContainerNode root = roots.get(0);
            menu.add((IAction)new CreateChildContainerAction(root));
        }
    }

    public ContainerNode getContainerNode() {
        return this.containerNode;
    }

    public void setContainerNode(ContainerNode containerNode) {
        this.containerNode = containerNode;
    }

    public void updateEnabled() {
        boolean hasRoot;
        boolean bl = hasRoot = this.containerNode != null;
        if (this.containerNode == null && this.fabric != null) {
            List<ContainerNode> roots = this.fabric.getRootContainers();
            hasRoot = roots.size() == 1;
        }
        this.setEnabled(hasRoot);
    }
}

