/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.actions;

import com.fusesource.ide.fabric.actions.Messages;
import com.fusesource.ide.fabric.actions.ProfileTreeSelectionFormSupport;
import com.fusesource.ide.fabric.navigator.Fabric;
import com.fusesource.ide.fabric.navigator.VersionNode;
import com.fusesource.ide.fabric.navigator.VersionsNode;
import com.fusesource.rider.commons.Viewers;
import com.fusesource.rider.commons.ui.ICanValidate;
import com.fusesource.rider.commons.ui.Selections;
import com.fusesource.rider.commons.ui.form.Forms;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IMessageManager;
import org.fusesource.fabric.api.Version;

public abstract class CreateContainerFormSupport
extends ProfileTreeSelectionFormSupport {
    public static final String AGENT_NAME_PROPERTY = "agentName";
    public static final String AGENT_VERSION_PROPERTY = "agentVersion";
    VersionNode versionNode;
    private String agentName;
    private Text containerNameField;
    private ComboViewer versionCombo;

    public CreateContainerFormSupport(ICanValidate validator, VersionNode versionNode, String defaultAgentName) {
        super(validator);
        this.versionNode = versionNode;
        this.agentName = defaultAgentName;
        this.addMandatoryPropertyNames(new String[]{AGENT_VERSION_PROPERTY});
        this.addMandatoryPropertyNames(new String[]{AGENT_NAME_PROPERTY});
    }

    public abstract void okPressed();

    public String getAgentName() {
        return this.agentName;
    }

    public void setAgentName(String agentName) {
        String oldValue = this.agentName;
        this.agentName = agentName;
        this.firePropertyChange(AGENT_NAME_PROPERTY, oldValue, agentName);
    }

    public VersionNode getAgentVersion() {
        return this.getVersionNode();
    }

    public void setAgentVersion(VersionNode version) {
        VersionNode oldVersion = this.versionNode;
        this.versionNode = version;
        if (version != null) {
            this.setProfilesViewerInput((Object)version);
            this.firePropertyChange(AGENT_VERSION_PROPERTY, (Object)oldVersion, (Object)this.versionNode);
        }
    }

    protected String getFormHeader() {
        return Messages.agentFormHeader;
    }

    public void setFocus() {
        this.containerNameField.setFocus();
    }

    public VersionNode getVersionNode() {
        return this.versionNode;
    }

    public Fabric getFabric() {
        if (this.versionNode != null) {
            return this.versionNode.getFabric();
        }
        return null;
    }

    public Control createDialogArea(Composite parent) {
        Composite outer = this.createWizardArea(parent);
        this.createButtons(outer);
        return parent;
    }

    public Composite createWizardArea(Composite parent) {
        this.createForm(parent);
        Composite inner = this.createSectionComposite(this.getSectionHeader(), new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        this.createTextFields(inner);
        if (this.isSelectProfile()) {
            Composite outer = this.createSectionComposite(Messages.selectedProfiles, new GridData(1808));
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            outer.setLayout((Layout)layout);
            this.createColumnsViewer(outer);
            this.loadPreference();
            return outer;
        }
        return inner;
    }

    protected String getSectionHeader() {
        return Messages.agentFieldsHeader;
    }

    protected void createTextFields(Composite inner) {
        this.containerNameField = this.createBeanPropertyTextField(inner, (Object)this, AGENT_NAME_PROPERTY, Messages.agentNameLabel, Messages.agentNameTooltip);
        if (this.chooseVersion()) {
            this.versionCombo = this.createBeanPropertyCombo(inner, (Object)this, AGENT_VERSION_PROPERTY, Messages.agentVersionLabel, Messages.agentVersionTooltip, 8);
            this.versionCombo.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public Object[] getElements(Object inputElement) {
                    if (inputElement != null && inputElement instanceof VersionsNode) {
                        VersionsNode versions = (VersionsNode)((Object)inputElement);
                        return versions.getChildren();
                    }
                    return null;
                }
            });
            this.versionCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (event.getSelection().isEmpty() || !(event.getSelection() instanceof IStructuredSelection)) {
                        return;
                    }
                    IStructuredSelection isel = (IStructuredSelection)event.getSelection();
                    Object o = isel.getFirstElement();
                    if (o instanceof VersionNode) {
                        CreateContainerFormSupport.this.setAgentVersion((VersionNode)((Object)o));
                    }
                }
            });
            Viewers.async((Runnable)new Runnable(){

                @Override
                public void run() {
                    CreateContainerFormSupport.this.versionCombo.setSelection((ISelection)new StructuredSelection((Object)CreateContainerFormSupport.this.versionNode), true);
                }
            });
        }
    }

    protected boolean chooseVersion() {
        return true;
    }

    public String getNewAgentName() {
        return this.containerNameField.getText();
    }

    protected Version getVersion() {
        if (this.versionCombo != null) {
            return (Version)Selections.getFirstSelection((ISelection)this.versionCombo.getSelection());
        }
        return null;
    }

    @Override
    protected void validateProfiles() {
        IStatus status = this.hasCheckedProfiles() ? ValidationStatus.ok() : ValidationStatus.error((String)Messages.noProfileSelected);
        TreeViewer profilesViewer = this.getProfilesViewer();
        Forms.updateMessageManager((IMessageManager)this.getMessageManager(), (Object)profilesViewer, (Control)profilesViewer.getControl(), (IStatus)status, (String)"selectedProfiles");
    }

    protected void loadPreference() {
        if (this.versionCombo != null) {
            this.versionCombo.setInput((Object)this.getFabric().getVersionsNode());
        }
        VersionNode v = this.versionNode;
        this.setAgentVersion(null);
        if (this.versionCombo != null) {
            this.versionCombo.getCombo().clearSelection();
            int i = 0;
            while (i < this.versionCombo.getCombo().getItemCount()) {
                if (this.versionCombo.getElementAt(i).equals((Object)v)) {
                    this.versionCombo.getCombo().select(i);
                    break;
                }
                ++i;
            }
        }
        this.setAgentVersion(v);
    }
}

