/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.actions;

import com.fusesource.ide.fabric.actions.CreateContainerFormSupport;
import com.fusesource.ide.fabric.actions.CreateSshContainerArgumentsBean;
import com.fusesource.ide.fabric.actions.Messages;
import com.fusesource.ide.fabric.navigator.ContainerNode;
import com.fusesource.ide.fabric.navigator.ProfileNode;
import com.fusesource.ide.fabric.navigator.VersionNode;
import com.fusesource.rider.commons.ui.ICanValidate;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.CreateContainerOptions;
import org.fusesource.fabric.api.Profile;

public class CreateSshContainerForm
extends CreateContainerFormSupport {
    private final ContainerNode selectedAgent;
    private final ProfileNode selectedProfile;
    private Text hostField;
    private Text portField;
    private Text usernameField;
    private Text passwordField;
    private Text pathField;
    private CreateSshContainerArgumentsBean args = new CreateSshContainerArgumentsBean();

    public CreateSshContainerForm(ICanValidate validator, VersionNode versionNode, ContainerNode selectedAgent, String defaultAgentName, ProfileNode selectedProfile) {
        super(validator, versionNode, defaultAgentName);
        this.selectedAgent = selectedAgent;
        this.selectedProfile = selectedProfile;
        this.addMandatoryPropertyNames(new String[]{"host", "path", "username", "password"});
    }

    @Override
    public void setFocus() {
        this.hostField.setFocus();
    }

    @Override
    public void okPressed() {
        if (this.isValid()) {
            String agentName = this.getNewAgentName();
            Profile[] profiles = this.getSelectedProfileArray();
            Container agent = null;
            if (this.selectedAgent != null) {
                agent = this.selectedAgent.getContainer();
            }
            this.getFabric().createContainer(agent, agentName, profiles, (CreateContainerOptions)this.args.delegate());
        }
    }

    @Override
    protected void loadPreference() {
        Profile profile;
        if (this.selectedProfile != null && (profile = this.selectedProfile.getProfile()) != null) {
            this.setCheckedProfiles(profile);
        }
        super.loadPreference();
    }

    @Override
    protected void createTextFields(Composite inner) {
        super.createTextFields(inner);
        this.hostField = this.createBeanPropertyTextField(inner, (Object)this.args, "host", Messages.agentHostLabel, Messages.agentHostLabel);
        this.usernameField = this.createBeanPropertyTextField(inner, (Object)this.args, "username", Messages.agentUserLabel, Messages.agentUserLabel);
        this.passwordField = this.createBeanPropertyTextField(inner, (Object)this.args, "password", Messages.agentPasswordLabel, Messages.agentPasswordLabel, 0x400000);
        this.pathField = this.createBeanPropertyTextField(inner, (Object)this.args, "path", Messages.agentPathLabel, Messages.agentPathTooltip);
        this.portField = this.createBeanPropertyTextField(inner, (Object)this.args, "port", Messages.agentPortLabel, Messages.agentPortLabel);
        this.createBeanPropertyTextField(inner, (Object)this.args, "sshRetries", Messages.agentSshRetriesLabel, Messages.agentSshRetriesTooltip);
        this.createBeanPropertyTextField(inner, (Object)this.args, "retryDelay", Messages.agentRetryDelayLabel, Messages.agentRetryDelayTooltip);
    }
}

