/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.actions;

import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.actions.Messages;
import com.fusesource.ide.fabric.navigator.Fabric;
import com.fusesource.ide.fabric.navigator.Fabrics;
import com.fusesource.ide.fabric.navigator.VersionNode;
import com.fusesource.ide.fabric.navigator.VersionsNode;
import com.fusesource.rider.commons.ui.Shells;
import com.google.common.base.Supplier;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.api.VersionSequence;

public class CreateVersionAction
extends Action {
    private final Supplier<Version> oldVersionSupplier;
    private final Fabric fabric;

    public CreateVersionAction(VersionsNode versionsNode) {
        this.init();
        this.fabric = versionsNode.getFabric();
        this.oldVersionSupplier = new Supplier<Version>(){

            public Version get() {
                return CreateVersionAction.this.getLatestVersion();
            }
        };
    }

    public CreateVersionAction(final VersionNode versionNode) {
        this.init();
        this.fabric = versionNode.getFabric();
        this.oldVersionSupplier = new Supplier<Version>(){

            public Version get() {
                return versionNode.getVersion();
            }
        };
    }

    private void init() {
        this.setText(Messages.createVersionMenuLabel);
        this.setToolTipText(Messages.createVersionDescription);
        this.setImageDescriptor(FabricPlugin.getDefault().getImageDescriptor("new_version.png"));
    }

    public void run() {
        InputDialog dialog;
        int result;
        VersionSequence next;
        String defaultValue = "";
        Version latestVersion = this.getLatestVersion();
        if (latestVersion != null && (next = latestVersion.getSequence().next()) != null) {
            defaultValue = next.getName();
        }
        if ((result = (dialog = new InputDialog(Shells.getShell(), Messages.createVersionDialogTitle, Messages.createVersionDialogMessage, defaultValue, null)).open()) == 0) {
            String newVersion = dialog.getValue();
            this.createVersion(newVersion);
        }
    }

    protected void createVersion(String newVersion) {
        Version oldVersion = (Version)this.oldVersionSupplier.get();
        System.out.println("Creating new version " + newVersion + " from old " + Fabrics.getVersionName(oldVersion));
        if (oldVersion != null) {
            this.fabric.getFabricService().createVersion(oldVersion, newVersion);
        } else {
            this.fabric.getFabricService().createVersion(newVersion);
        }
        this.fabric.getVersionsNode().refresh();
    }

    public Version getLatestVersion() {
        return Fabrics.getLatestVersion(this.fabric.getFabricService());
    }
}

