/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.actions;

import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.actions.FabricDetails;
import com.fusesource.ide.fabric.actions.FabricDetailsDialog;
import com.fusesource.ide.fabric.actions.Messages;
import com.fusesource.rider.commons.util.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.jface.action.Action;

public abstract class FabricDetailsEditAction
extends Action {
    public FabricDetailsEditAction() {
        super(Messages.fabricEditButton);
        this.setToolTipText(Messages.fabricEditButtonTooktip);
        this.setImageDescriptor(FabricPlugin.getPlugin().getImageDescriptor("prop_ps.gif"));
    }

    protected abstract FabricDetails getSelectedFabricDetails();

    protected abstract void onFabricDetailsEdited(FabricDetails var1);

    public void run() {
        FabricDetailsDialog dialog = new FabricDetailsDialog(){

            protected void okPressed() {
                FabricDetails details = this.getFabricDetails();
                super.okPressed();
                FabricDetailsEditAction.this.editCloud(details);
            }
        };
        FabricDetails selectedCloud = this.getSelectedFabricDetails();
        if (selectedCloud != null) {
            FabricDetails copy = FabricDetails.copy(selectedCloud);
            dialog.getForm().setDetails(copy);
        }
        dialog.open();
    }

    protected void editCloud(final FabricDetails cloudDetails) {
        cloudDetails.flush();
        try {
            FabricDetails.reloadDetailList();
        }
        catch (Exception e) {
            FabricPlugin.getLogger().error((Throwable)e);
        }
        Object found = Iterables.find((Iterable)FabricDetails.getDetailList(), (Predicate)new Predicate<FabricDetails>(){

            public boolean apply(FabricDetails details) {
                return Objects.equal((Object)cloudDetails.getId(), (Object)details.getId());
            }
        });
        if (found instanceof FabricDetails) {
            this.onFabricDetailsEdited((FabricDetails)((Object)found));
        }
    }
}

