/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.actions;

import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.actions.Messages;
import com.fusesource.ide.fabric.navigator.ProfileNode;
import com.fusesource.ide.fabric.navigator.VersionNode;
import com.fusesource.rider.commons.ui.Shells;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.fusesource.fabric.api.Profile;

public class ProfileAddAction
extends Action {
    private final VersionNode versionNode;
    private ProfileNode profileNode;

    public ProfileAddAction(VersionNode versionNode) {
        super(Messages.profileAddLabel);
        this.versionNode = versionNode;
        this.setToolTipText(Messages.profileAddTooltip);
        this.setImageDescriptor(FabricPlugin.getPlugin().getImageDescriptor("new_profile.png"));
    }

    public ProfileAddAction(ProfileNode profileNode) {
        this(profileNode.getVersionNode());
        this.profileNode = profileNode;
    }

    public void run() {
        InputDialog dialog = new InputDialog(Shells.getShell(), Messages.profileAddDialogTitle, Messages.profileAddDialogMessage, "", null);
        int result = dialog.open();
        if (result == 0) {
            String name = dialog.getValue();
            this.createProfile(name);
        }
    }

    protected void createProfile(String name) {
        String versionId = this.versionNode.getVersionId();
        Profile profile = this.versionNode.getFabric().getFabricService().createProfile(versionId, name);
        if (this.profileNode != null) {
            profile.setParents(new Profile[]{this.profileNode.getProfile()});
        }
        this.versionNode.refresh();
    }
}

