/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.actions;

import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.actions.Messages;
import com.fusesource.ide.fabric.navigator.ProfileNode;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.ui.Shells;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.fusesource.fabric.api.Profile;

public class ProfileDeleteAction
extends Action {
    private final ProfileNode node;

    public ProfileDeleteAction(ProfileNode node) {
        super(Messages.profileDeleteLabel);
        this.node = node;
        this.setToolTipText(Messages.profileDeleteTooltip);
        this.setImageDescriptor(FabricPlugin.getPlugin().getImageDescriptor("delete.gif"));
    }

    public void run() {
        Profile profile = this.node.getProfile();
        String message = Messages.bind((String)Messages.deleteProfileMessage, (Object)profile.getId());
        boolean confirm = MessageDialog.openConfirm((Shell)Shells.getShell(), (String)Messages.deleteProfileDialogTitle, (String)message);
        if (confirm) {
            this.node.getFabric().getFabricService().deleteProfile(profile);
            Node parent = this.node.getParent();
            if (parent != null) {
                parent.removeChild((Node)this.node);
            }
        }
    }
}

