/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.actions;

import com.fusesource.ide.fabric.actions.ProfilesContentProvider;
import com.fusesource.ide.fabric.navigator.ProfileNode;
import com.fusesource.ide.fabric.navigator.Profiles;
import com.fusesource.ide.fabric.navigator.VersionNode;
import com.fusesource.rider.commons.Viewers;
import com.fusesource.rider.commons.ui.ICanValidate;
import com.fusesource.rider.commons.ui.Selections;
import com.fusesource.rider.commons.ui.form.FormSupport;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.fusesource.fabric.api.Profile;

public abstract class ProfileTreeSelectionFormSupport
extends FormSupport {
    private List<Profile> selectedProfiles;
    private TreeViewer profilesViewer;
    private Button selectAllButton;
    private Button deselectAllButton;
    private List<Profile> initialProfileSelections;

    public ProfileTreeSelectionFormSupport() {
    }

    public ProfileTreeSelectionFormSupport(ICanValidate validator) {
        super(validator);
    }

    public boolean isValid() {
        return super.isValid() && (this.hasCheckedProfiles() || !this.isSelectProfile());
    }

    public TreeViewer getProfilesViewer() {
        return this.profilesViewer;
    }

    public void createColumnsViewer(Composite parent) {
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        this.profilesViewer = new TreeViewer(parent, 67586);
        this.profilesViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.profilesViewer.setContentProvider((IContentProvider)new ProfilesContentProvider());
        Control profilesControl = this.profilesViewer.getControl();
        this.getToolkit().adapt(profilesControl, true, true);
        this.profilesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProfileTreeSelectionFormSupport.this.onProfileSelectionChanged();
            }
        });
    }

    public void setProfilesViewerInput(Object input) {
        if (this.profilesViewer != null) {
            this.profilesViewer.setInput(input);
            this.profilesViewer.expandAll();
            if (this.initialProfileSelections != null) {
                this.setCheckedProfiles(this.initialProfileSelections.toArray(new Profile[this.initialProfileSelections.size()]));
            }
        }
    }

    public void setInitialProfileSelections(Profile ... profiles) {
        this.initialProfileSelections = Arrays.asList(profiles);
    }

    protected void validateProfiles() {
    }

    public boolean hasCheckedProfiles() {
        return this.getSelectedProfileList().size() > 0;
    }

    protected void createButtons(Composite parent) {
        this.createButtonComposite(parent);
    }

    protected Composite createButtonComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1040));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        return composite;
    }

    public void setCheckedProfiles(Profile ... selected) {
        ArrayList<ProfileNode> selectedProfiles = new ArrayList<ProfileNode>();
        Object input = this.profilesViewer.getInput();
        if (input instanceof VersionNode) {
            VersionNode node = (VersionNode)((Object)input);
            Profile[] profileArray = selected;
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                Profile profile = profileArray[n2];
                ProfileNode profileNode = node.getProfileNode(profile);
                if (profileNode != null) {
                    selectedProfiles.add(profileNode);
                }
                ++n2;
            }
        }
        this.profilesViewer.setSelection((ISelection)new StructuredSelection(selectedProfiles));
        Viewers.async((Runnable)new Runnable(){

            @Override
            public void run() {
                ProfileTreeSelectionFormSupport.this.onProfileSelectionChanged();
            }
        });
    }

    public List<Profile> getSelectedProfileList() {
        ArrayList answer = Lists.newArrayList();
        if (this.profilesViewer != null) {
            List list = Selections.getSelectionList((Viewer)this.profilesViewer);
            for (Object object : list) {
                Profile profile = Profiles.toProfile(object);
                if (profile == null) continue;
                answer.add(profile);
            }
        }
        return answer;
    }

    public Profile[] getSelectedProfileArray() {
        List<Profile> selectedProfiles = this.getSelectedProfileList();
        Profile[] profiles = selectedProfiles.toArray(new Profile[selectedProfiles.size()]);
        return profiles;
    }

    protected boolean isSelectProfile() {
        return true;
    }

    protected void onProfileSelectionChanged() {
        this.validateProfiles();
        this.validate();
    }
}

