/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.actions.jclouds;

import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.actions.jclouds.CloudDetailsKey;
import com.fusesource.ide.fabric.actions.jclouds.JClouds;
import com.fusesource.rider.commons.ui.config.ConfigurationDetails;
import com.fusesource.rider.commons.util.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.fusesource.fabric.service.jclouds.modules.ZookeeperCredentialStore;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.ComputeServiceContextFactory;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.linkedin.zookeeper.client.IZKClient;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CloudDetails
extends ConfigurationDetails {
    private static final String PROPERTY_SETTINGS_PREFIX = "settings_";
    private static final String PROPERTY_PROVIDER_ID = "providerId";
    private static final String PROPERTY_OWNER_ID = "ownerId";
    private static final String PROPERTY_CREDENTIAL = "credential";
    private static final String PROPERTY_IDENTITY = "identity";
    private static final String PROPERTY_NAME = "name";
    private static WritableList cloudDetailList = WritableList.withElementType(CloudDetails.class);
    private static AtomicBoolean loadedCloudDetails = new AtomicBoolean(false);
    private static CloudDetails exemplar = new CloudDetails();
    private String name;
    private ProviderMetadata provider;
    private String identity;
    private String credential;
    private String ownerId;
    private boolean storeCredential = true;
    private String providerId;
    private CloudDetailsKey key;
    private IZKClient izkClient;
    private HashMap<String, String> settings = new HashMap();

    public static void reloadCloudDetailList() {
        cloudDetailList.clear();
        CloudDetails.load((Collection<CloudDetails>)cloudDetailList);
    }

    public static WritableList getCloudDetailList() {
        if (loadedCloudDetails.compareAndSet(false, true)) {
            CloudDetails.load((Collection<CloudDetails>)cloudDetailList);
        }
        return cloudDetailList;
    }

    public static CloudDetails asCloudDetails(Object element) {
        if (element instanceof CloudDetails) {
            return (CloudDetails)((Object)element);
        }
        return null;
    }

    protected static void load(Collection<CloudDetails> cloudDetailList) {
        Preferences node = exemplar.getConfigurationNode();
        try {
            String[] childrenNames;
            String[] stringArray = childrenNames = node.childrenNames();
            int n = childrenNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                cloudDetailList.add(new CloudDetails(name, node.node(name)));
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            FabricPlugin.showUserError("Failed to load cloud providers", e.getMessage(), (Exception)((Object)e));
        }
    }

    public static CloudDetails copy(CloudDetails copy) {
        Preferences node = exemplar.getConfigurationNode();
        String id = copy.getId();
        return new CloudDetails(id, node.node(id));
    }

    public CloudDetails() {
    }

    public CloudDetails(String id, Preferences node) {
        super(id);
        this.name = node.get(PROPERTY_NAME, "");
        this.identity = node.get(PROPERTY_IDENTITY, "");
        this.credential = node.get(PROPERTY_CREDENTIAL, "");
        if (Strings.isBlank((String)this.credential)) {
            this.storeCredential = false;
        }
        this.ownerId = node.get(PROPERTY_OWNER_ID, "");
        this.setProvider(JClouds.getProvider(node.get(PROPERTY_PROVIDER_ID, null)));
        this.settings.clear();
        try {
            String[] stringArray = node.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String keyName = stringArray[n2];
                if (keyName.startsWith(PROPERTY_SETTINGS_PREFIX)) {
                    this.settings.put(keyName, node.get(keyName, ""));
                }
                ++n2;
            }
        }
        catch (BackingStoreException ex) {
            FabricPlugin.showUserError("Settings Error", "Unable to restore settings...", (Exception)((Object)ex));
        }
    }

    public CloudDetailsKey getCacheKey() {
        if (this.key == null) {
            this.key = new CloudDetailsKey(this.identity, this.credential, this.ownerId, this.providerId);
        }
        return this.key;
    }

    protected String getConfigurationNodeId() {
        return "com.fusesource.ide.jclouds.provider";
    }

    protected void store(Preferences node) {
        node.put(PROPERTY_NAME, this.name);
        node.put(PROPERTY_IDENTITY, this.identity);
        node.put(PROPERTY_PROVIDER_ID, this.providerId);
        if (this.storeCredential) {
            node.put(PROPERTY_CREDENTIAL, this.credential);
        } else {
            node.remove(PROPERTY_CREDENTIAL);
        }
        if (Strings.isBlank((String)this.ownerId)) {
            node.remove(PROPERTY_OWNER_ID);
        } else {
            node.put(PROPERTY_OWNER_ID, this.ownerId);
        }
        for (String keyName : this.settings.keySet()) {
            String value = this.settings.get(keyName);
            node.put(keyName, value);
        }
    }

    public String toString() {
        return "ColumnConfiguration(" + this.name + ", " + this.provider + ", " + this.identity + ")";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProviderMetadata getProvider() {
        return this.provider;
    }

    public void setProvider(ProviderMetadata provider) {
        this.providerId = JClouds.getId(provider);
        if (provider != this.provider) {
            ProviderMetadata oldValue = this.provider;
            this.provider = provider;
            this.firePropertyChange("provider", oldValue, provider);
        }
    }

    public void addSetting(String key, String value) {
        this.settings.put(PROPERTY_SETTINGS_PREFIX + key, value);
        this.firePropertyChange("settings", value, value);
    }

    public String getSetting(String key, String defaultValue) {
        String retVal = defaultValue;
        if (this.settings.containsKey(PROPERTY_SETTINGS_PREFIX + key)) {
            retVal = this.settings.get(PROPERTY_SETTINGS_PREFIX + key);
        }
        return retVal;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        if (this.identity != identity) {
            String oldValue = this.identity;
            this.identity = identity;
            this.firePropertyChange(PROPERTY_IDENTITY, oldValue, identity);
        }
    }

    public String getCredential() {
        return this.credential;
    }

    public void setCredential(String credential) {
        if (this.credential != credential) {
            String oldValue = this.credential;
            this.credential = credential;
            this.firePropertyChange(PROPERTY_CREDENTIAL, oldValue, credential);
        }
    }

    public boolean isStoreCredential() {
        return this.storeCredential;
    }

    public void setStoreCredential(boolean storeCredential) {
        this.storeCredential = storeCredential;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        if (this.ownerId != ownerId) {
            String oldValue = this.ownerId;
            this.ownerId = ownerId;
            this.firePropertyChange(PROPERTY_OWNER_ID, oldValue, ownerId);
        }
    }

    public String getProviderName() {
        return JClouds.text(this.getProvider());
    }

    public String getProviderId() {
        return this.providerId;
    }

    public static ComputeService createComputeService(CloudDetails details) {
        ProviderMetadata selectedProvider = details.getProvider();
        String providerId = selectedProvider.getId();
        String identity = details.getIdentity();
        String credential = details.getCredential();
        String owner = details.getOwnerId();
        ComputeService computeClient = null;
        if (selectedProvider != null && !Strings.isBlank((String)identity) && !Strings.isBlank((String)credential)) {
            ImmutableSet modules;
            IZKClient izkClient;
            Properties props = new Properties();
            props.put("provider", providerId);
            props.put(PROPERTY_IDENTITY, identity);
            props.put(PROPERTY_CREDENTIAL, credential);
            if (!Strings.isBlank((String)owner)) {
                props.put("jclouds.ec2.ami-query=owner-id", String.valueOf(owner) + ";state=available;image-type=machine");
            }
            if ((izkClient = details.getIzkClient()) != null) {
                ZookeeperCredentialStore credentialStore = new ZookeeperCredentialStore();
                credentialStore.setZooKeeper(izkClient);
                credentialStore.init();
                modules = ImmutableSet.of((Object)new Log4JLoggingModule(), (Object)new SshjSshClientModule(), (Object)credentialStore);
            } else {
                modules = ImmutableSet.of((Object)new Log4JLoggingModule(), (Object)new SshjSshClientModule());
            }
            ComputeServiceContextFactory factory = new ComputeServiceContextFactory();
            ComputeServiceContext context = factory.createContext(providerId, identity, credential, (Iterable)modules, props);
            computeClient = context.getComputeService();
        }
        return computeClient;
    }

    protected IZKClient getIzkClient() {
        return this.izkClient;
    }

    protected void setIzkClient(IZKClient izkClient) {
        this.izkClient = izkClient;
    }

    public void setZooKeeper(IZKClient izkClient) {
        this.izkClient = izkClient;
    }
}

