/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.actions.jclouds;

import com.fusesource.ide.fabric.actions.Messages;
import com.fusesource.ide.fabric.actions.jclouds.CloudDetails;
import com.fusesource.ide.fabric.actions.jclouds.CloudDetailsCachedData;
import com.fusesource.ide.fabric.actions.jclouds.JClouds;
import com.fusesource.ide.fabric.actions.jclouds.JCloudsLabelProvider;
import com.fusesource.rider.commons.ui.ICanValidate;
import com.fusesource.rider.commons.ui.form.FormSupport;
import com.google.common.base.Objects;
import java.util.List;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jclouds.providers.ProviderMetadata;

public class CloudDetailsForm
extends FormSupport {
    private ComboViewer providerNameField;
    private Text identityField;
    private CloudDetails details = new CloudDetails();
    private Text nameField;

    public CloudDetailsForm(ICanValidate validator) {
        super(validator);
    }

    protected boolean isMandatory(Object bean, String propertyName) {
        return !Objects.equal((Object)propertyName, (Object)"ownerId");
    }

    public CloudDetails getDetails() {
        return this.details;
    }

    public void setDetails(CloudDetails details) {
        this.details = details;
    }

    public void setFocus() {
        this.nameField.setFocus();
    }

    public void createTextFields(Composite parent) {
        Composite inner = this.createSectionComposite(Messages.jclouds_cloudDetails, new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        this.nameField = this.createBeanPropertyTextField(inner, (Object)this.details, "name", Messages.jclouds_nameLabel, Messages.jclouds_nameTooltip);
        this.providerNameField = this.createBeanPropertyCombo(inner, (Object)this.details, "provider", Messages.jclouds_providerNameLabel, Messages.jclouds_providerNameTooltip, JClouds.getProviders());
        ProviderMetadata provider = this.details.getProvider();
        if (provider != null) {
            this.providerNameField.setSelection((ISelection)new StructuredSelection((Object)provider));
        }
        this.identityField = this.createBeanPropertyTextField(inner, (Object)this.details, "identity", Messages.jclouds_identityLabel, Messages.jclouds_identityTooltip);
        this.createBeanPropertyTextField(inner, (Object)this.details, "credential", Messages.jclouds_credentialLabel, Messages.jclouds_credentialTooltip, 0x400000);
        this.createBeanPropertyTextField(inner, (Object)this.details, "ownerId", Messages.jclouds_ownerLabel, Messages.jclouds_ownerTooltip, 0x400000);
    }

    protected ComboViewer createBeanPropertyCombo(Composite parent, Object bean, String propertyName, String labelText, String tooltip, List<?> input) {
        ComboViewer answer = this.createBeanPropertyCombo(parent, bean, propertyName, labelText, tooltip, 8);
        answer.setInput(input);
        answer.setLabelProvider((IBaseLabelProvider)JCloudsLabelProvider.getInstance());
        return answer;
    }

    public void okPressed() {
        CloudDetailsCachedData.getInstance(this.details).startLoadingDataJobs();
    }
}

