/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.actions.jclouds;

import com.fusesource.ide.fabric.actions.jclouds.CloudDetails;
import com.fusesource.ide.fabric.actions.jclouds.CloudDetailsAddAction;
import com.fusesource.ide.fabric.actions.jclouds.CloudDetailsDeleteAction;
import com.fusesource.ide.fabric.actions.jclouds.CloudDetailsEditAction;
import com.fusesource.rider.commons.ui.Selections;
import com.fusesource.rider.commons.ui.Widgets;
import com.fusesource.rider.commons.ui.config.ConfigurationDetails;
import com.fusesource.rider.commons.ui.views.TableViewSupport;
import com.fusesource.rider.commons.util.Function1;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class CloudDetailsTable
extends TableViewSupport {
    private Button addButton;
    private Button editButton;
    private Button deleteButton;
    private Action editAction;
    private final IChangeListener changeListener = new IChangeListener(){

        public void handleChange(ChangeEvent event) {
            Widgets.refresh((Viewer)CloudDetailsTable.this.getViewer());
        }
    };
    private CloudDetailsAddAction addAction;
    private CloudDetailsDeleteAction deleteAction;
    private CloudDetails selectedCloud;

    public CloudDetailsTable() {
        this.setShowSearchBox(false);
    }

    public void dispose() {
        CloudDetails.getCloudDetailList().removeChangeListener(this.changeListener);
        super.dispose();
    }

    protected void createColumns() {
        this.clearColumns();
        int bounds = 150;
        int column = 0;
        Object function = new Function1(){

            public Object apply(Object element) {
                CloudDetails exchange = CloudDetails.asCloudDetails(element);
                if (exchange != null) {
                    return exchange.getName();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Name");
        function = new Function1(){

            public Object apply(Object element) {
                CloudDetails exchange = CloudDetails.asCloudDetails(element);
                if (exchange != null) {
                    return exchange.getProviderName();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Provider");
        function = new Function1(){

            public Object apply(Object element) {
                CloudDetails exchange = CloudDetails.asCloudDetails(element);
                if (exchange != null) {
                    return exchange.getIdentity();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Identity");
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CloudDetailsTable.this.selectedCloud = CloudDetails.asCloudDetails(Selections.getFirstSelection((ISelection)event.getSelection()));
                CloudDetailsTable.this.selectionUpdated();
            }
        });
        Composite buttonBar = new Composite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalAlignment = 0x1000000;
        buttonBar.setLayoutData((Object)gridData);
        RowLayout layout = new RowLayout();
        layout.center = true;
        buttonBar.setLayout((Layout)layout);
        this.addAction = new CloudDetailsAddAction(){

            @Override
            protected void onCloudDetailsAdded(ConfigurationDetails details) {
                CloudDetailsTable.this.getViewer().setSelection((ISelection)new StructuredSelection((Object)details));
            }
        };
        this.editAction = new CloudDetailsEditAction(){

            @Override
            protected CloudDetails getSelectedCloudDetails() {
                return CloudDetailsTable.this.getSelectedCloud();
            }

            @Override
            protected void onCloudDetailsEdited(Object found) {
                if (found != null) {
                    CloudDetailsTable.this.getViewer().setSelection((ISelection)new StructuredSelection(found));
                }
            }
        };
        this.setDoubleClickAction(this.editAction);
        this.deleteAction = new CloudDetailsDeleteAction(){

            @Override
            protected CloudDetails getSelectedCloudDetails() {
                return CloudDetailsTable.this.getSelectedCloud();
            }
        };
        this.addButton = Widgets.createActionButton((Composite)buttonBar, (Action)this.addAction);
        this.editButton = Widgets.createActionButton((Composite)buttonBar, (Action)this.editAction);
        this.deleteButton = Widgets.createActionButton((Composite)buttonBar, (Action)this.deleteAction);
        this.selectionUpdated();
        CloudDetails.getCloudDetailList().addChangeListener(this.changeListener);
    }

    protected void configureViewer() {
        this.reload();
    }

    public void reload() {
        this.getViewer().setInput((Object)CloudDetails.getCloudDetailList());
    }

    protected IStructuredContentProvider createContentProvider() {
        return ArrayContentProvider.getInstance();
    }

    protected String getHelpID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public CloudDetails getSelectedCloud() {
        return this.selectedCloud;
    }

    protected void selectionUpdated() {
        boolean selected = this.getSelectedCloud() != null;
        this.editAction.setEnabled(selected);
        this.editButton.setEnabled(selected);
        this.deleteAction.setEnabled(selected);
        this.deleteButton.setEnabled(selected);
    }
}

