/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.actions.jclouds;

import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.actions.Messages;
import com.fusesource.ide.fabric.actions.jclouds.CloudContainerDetailsForm;
import com.fusesource.ide.fabric.actions.jclouds.CloudContainerDetailsWizardPage;
import com.fusesource.ide.fabric.actions.jclouds.CloudDetails;
import com.fusesource.ide.fabric.actions.jclouds.CloudDetailsWizardPage;
import com.fusesource.ide.fabric.navigator.ContainerNode;
import com.fusesource.ide.fabric.navigator.Fabric;
import com.fusesource.ide.fabric.navigator.ProfileNode;
import com.fusesource.ide.fabric.navigator.VersionNode;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.CreateContainerOptions;
import org.fusesource.fabric.api.CreateJCloudsContainerOptions;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.zookeeper.utils.ZooKeeperUtils;
import org.linkedin.zookeeper.client.IZKClient;

public class CreateJCloudsContainerWizard
extends Wizard {
    private final VersionNode versionNode;
    private final ContainerNode selectedAgent;
    private final String defaultAgentName;
    private final ProfileNode selectedProfile;
    private IStructuredSelection selection;
    private CloudDetailsWizardPage page1;
    private CloudContainerDetailsWizardPage page2;

    public CreateJCloudsContainerWizard(VersionNode versionNode, ContainerNode selectedAgent, String defaultAgentName, ProfileNode selectedProfile) {
        this.versionNode = versionNode;
        this.selectedAgent = selectedAgent;
        this.defaultAgentName = defaultAgentName;
        this.selectedProfile = selectedProfile;
        super.setWindowTitle(Messages.createJCloudsAgentTitle);
    }

    public VersionNode getVersionNode() {
        return this.versionNode;
    }

    public ContainerNode getSelectedAgent() {
        return this.selectedAgent;
    }

    public String getDefaultAgentName() {
        return this.defaultAgentName;
    }

    public ProfileNode getSelectedProfile() {
        return this.selectedProfile;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public CloudDetailsWizardPage getPage1() {
        return this.page1;
    }

    public CloudContainerDetailsWizardPage getPage2() {
        return this.page2;
    }

    public void addPages() {
        this.page1 = new CloudDetailsWizardPage();
        this.addPage((IWizardPage)this.page1);
        this.page2 = new CloudContainerDetailsWizardPage(this);
        this.addPage((IWizardPage)this.page2);
    }

    public boolean performFinish() {
        String zkUrl;
        Map config;
        Profile profile;
        CloudContainerDetailsForm form = this.getPage2().getForm();
        form.saveSettings();
        String agentName = form.getAgentName();
        CreateJCloudsContainerOptions args = form.getCreateCloudArguments();
        args.setName(agentName);
        args.setResolver("publicip");
        Fabric fabric = this.getFabric();
        ProfileNode defaultProfile = this.getVersionNode().getProfileNode("default");
        if (defaultProfile != null && fabric != null && (profile = defaultProfile.getProfile()) != null && (config = (Map)profile.getConfigurations().get("org.fusesource.fabric.zookeeper")) != null && (zkUrl = (String)config.get("zookeeper.url")) != null) {
            try {
                IZKClient zooKeeper = fabric.getZooKeeper();
                zkUrl = ZooKeeperUtils.getSubstitutedData((IZKClient)zooKeeper, (String)zkUrl);
                args.setZookeeperUrl(zkUrl);
            }
            catch (Exception e) {
                FabricPlugin.getLogger().warning("Failed to get ZooKeeperURL: " + e, (Throwable)e);
            }
        }
        Container agent = null;
        if (this.selectedAgent != null) {
            agent = this.selectedAgent.getContainer();
        }
        Profile[] profiles = form.getSelectedProfileArray();
        this.versionNode.getFabric().createContainer(agent, agentName, profiles, (CreateContainerOptions)args);
        return true;
    }

    public Fabric getFabric() {
        return this.versionNode != null ? this.versionNode.getFabric() : (this.selectedProfile != null ? this.selectedProfile.getFabric() : (this.selectedAgent != null ? this.selectedAgent.getFabric() : null));
    }

    public CloudDetails getSelectedCloud() {
        return this.page1.getSelectedCloud();
    }
}

