/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.actions.jclouds;

import com.fusesource.ide.fabric.actions.Messages;
import com.fusesource.ide.fabric.actions.jclouds.CloudDetails;
import com.fusesource.ide.fabric.actions.jclouds.CloudDetailsWizardPage;
import com.fusesource.ide.fabric.actions.jclouds.CloudFabricDetailsForm;
import com.fusesource.ide.fabric.actions.jclouds.CloudFabricDetailsWizardPage;
import com.fusesource.ide.fabric.navigator.Fabrics;
import com.fusesource.rider.commons.Viewers;
import com.fusesource.rider.commons.jobs.Jobs;
import com.fusesource.rider.commons.util.Strings;
import java.net.URI;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.fusesource.fabric.api.CreateJCloudsContainerMetadata;
import org.fusesource.fabric.api.CreateJCloudsContainerOptions;
import org.fusesource.fabric.api.CreationStateListener;
import org.fusesource.fabric.service.jclouds.JcloudsContainerProvider;
import org.fusesource.fabric.service.jclouds.firewall.FirewallManagerFactory;
import org.fusesource.fabric.service.jclouds.firewall.ProviderFirewallSupport;
import org.fusesource.fabric.service.jclouds.firewall.internal.Ec2FirewallSupport;
import org.fusesource.fabric.service.jclouds.firewall.internal.FirewallManagerFactoryImpl;

public class CreateJCloudsFabricWizard
extends Wizard {
    private final Fabrics fabrics;
    private final String defaultAgentName;
    private IStructuredSelection selection;
    private CloudDetailsWizardPage page1;
    private CloudFabricDetailsWizardPage page2;

    public CreateJCloudsFabricWizard(Fabrics fabrics, String defaultAgentName) {
        this.fabrics = fabrics;
        this.defaultAgentName = defaultAgentName;
        super.setWindowTitle(Messages.createJCloudsFabricTitle);
    }

    public String getDefaultAgentName() {
        return this.defaultAgentName;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public CloudDetailsWizardPage getPage1() {
        return this.page1;
    }

    public CloudFabricDetailsWizardPage getPage2() {
        return this.page2;
    }

    public void addPages() {
        this.page1 = new CloudDetailsWizardPage();
        this.addPage((IWizardPage)this.page1);
        this.page2 = new CloudFabricDetailsWizardPage(this);
        this.addPage((IWizardPage)this.page2);
    }

    public boolean performFinish() {
        final CloudFabricDetailsForm form = this.getPage2().getForm();
        form.saveSettings();
        Jobs.schedule((Job[])new Job[]{new Job("Create container"){

            protected IStatus run(final IProgressMonitor monitor) {
                final String fabricName = form.getFabricName();
                try {
                    String agentName = form.getAgentName();
                    CreateJCloudsContainerOptions args = form.getCreateCloudArguments();
                    args.setName(agentName);
                    args.setEnsembleServer(true);
                    String proxyUri = "http://repo.fusesource.com/nexus/content/groups/ea";
                    if (form instanceof CloudFabricDetailsForm) {
                        CloudFabricDetailsForm fabricForm = form;
                        proxyUri = fabricForm.getProxyUri();
                    }
                    if (!Strings.isBlank((String)proxyUri)) {
                        args.setProxyUri(new URI(proxyUri));
                    }
                    System.out.println("============ proxy URI: " + args.getProxyUri());
                    args.setCreationStateListener(new CreationStateListener(){

                        public void onStateChange(String message) {
                            monitor.subTask(message);
                        }
                    });
                    System.out.println("Create cloud fabric: " + fabricName + " container: " + agentName);
                    JcloudsContainerProvider provider = new JcloudsContainerProvider();
                    FirewallManagerFactoryImpl firewallManagerFactory = new FirewallManagerFactoryImpl();
                    String providerName = args.getProviderName();
                    System.out.println("Creating Jclouds provider type: " + providerName);
                    if ("aws-ec2".equals(providerName)) {
                        firewallManagerFactory.bind((ProviderFirewallSupport)new Ec2FirewallSupport());
                    }
                    provider.setFirewallManagerFactory((FirewallManagerFactory)firewallManagerFactory);
                    Set metadatas = provider.create(args);
                    final StringBuilder urisBuilder = new StringBuilder();
                    for (CreateJCloudsContainerMetadata metadata : metadatas) {
                        Throwable failure = metadata.getFailure();
                        if (failure != null) {
                            return new Status(4, "com.fusesource.ide.fabric", "Failed to create Fabric: " + fabricName, failure);
                        }
                        for (String address : metadata.getPublicAddresses()) {
                            urisBuilder.append(address).append(",");
                        }
                    }
                    Viewers.async((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            String uris = urisBuilder.toString();
                            if (uris.endsWith(",")) {
                                uris = uris.substring(0, uris.length() - 1);
                            }
                            System.out.println("Creating fabric with uris: " + uris);
                            CreateJCloudsFabricWizard.this.fabrics.addFabric(fabricName, uris);
                        }
                    });
                    return Status.OK_STATUS;
                }
                catch (Throwable e) {
                    return new Status(4, "com.fusesource.ide.fabric", "Failed to create Fabric: " + fabricName, e);
                }
            }
        }});
        return true;
    }

    public CloudDetails getSelectedCloud() {
        return this.page1.getSelectedCloud();
    }
}

