/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.actions.jclouds;

import com.fusesource.rider.commons.util.Objects;
import com.fusesource.rider.commons.util.Strings;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.fusesource.fabric.service.jclouds.JcloudsContainerProvider;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.domain.Location;
import org.jclouds.domain.ResourceMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.ProviderPredicates;

public class JClouds {
    private static List<ProviderMetadata> providers;

    public static List<ProviderMetadata> getProviders() {
        if (providers == null) {
            ServiceLoader<ProviderMetadata> services = ServiceLoader.load(ProviderMetadata.class, JClouds.getJCloudsClassLoader());
            if (Iterables.isEmpty(services)) {
                services = ServiceLoader.load(ProviderMetadata.class, JClouds.class.getClassLoader());
            }
            Iterable computeProviders = Iterables.filter(services, (Predicate)ProviderPredicates.type((String)"compute"));
            providers = Lists.newArrayList((Iterable)computeProviders);
            Collections.sort(providers, new Comparator<ProviderMetadata>(){

                @Override
                public int compare(ProviderMetadata o1, ProviderMetadata o2) {
                    return Objects.compare((Object)o1.getName(), (Object)o2.getName());
                }
            });
        }
        return providers;
    }

    public static ClassLoader getJCloudsClassLoader() {
        return ProviderMetadata.class.getClassLoader();
    }

    public static String text(ComputeMetadata md) {
        return Strings.getOrElse((Object)md.getName(), (String)md.getId());
    }

    public static String text(Hardware md) {
        return Strings.getOrElse((Object)md.getName(), (String)md.getId());
    }

    public static String text(OperatingSystem md) {
        return Strings.getOrElse((Object)md.getDescription(), (String)md.getName());
    }

    public static String text(ResourceMetadata<?> rm) {
        return Strings.getOrElse((Object)rm.getName(), (String)rm.getProviderId());
    }

    public static String text(Location location) {
        return Strings.getOrElse((Object)location.getDescription(), (String)location.getId());
    }

    public static String text(ProviderMetadata provider) {
        return Strings.getOrElse((Object)provider.getName(), (String)provider.getId());
    }

    public static ProviderMetadata getProvider(String providerId) {
        if (!Strings.isBlank((String)providerId)) {
            return (ProviderMetadata)Iterables.find(JClouds.getProviders(), (Predicate)ProviderPredicates.id((String)providerId));
        }
        return null;
    }

    public static String getId(ProviderMetadata provider) {
        if (provider != null) {
            return provider.getId();
        }
        return null;
    }

    public static void bindProviders(JcloudsContainerProvider jclouds) {
        List<ProviderMetadata> list = JClouds.getProviders();
        Iterator<ProviderMetadata> iterator = list.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    public static <T extends ResourceMetadata<?>> List<T> sortedList(Collection<T> coll) {
        ArrayList answer = Lists.newArrayList(coll);
        Collections.sort(answer, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return Objects.compare((Object)JClouds.text(o1), (Object)JClouds.text(o2));
            }
        });
        return answer;
    }

    public static <T extends Location> List<T> sortedLocationList(Collection<T> coll) {
        ArrayList answer = Lists.newArrayList(coll);
        Collections.sort(answer, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return Objects.compare((Object)JClouds.text(o1), (Object)JClouds.text(o2));
            }
        });
        return answer;
    }

    public static ComputeMetadata asComputeMetadata(Object element) {
        if (element instanceof ComputeMetadata) {
            return (ComputeMetadata)element;
        }
        return null;
    }

    public static NodeMetadata asNodeMetadata(Object element) {
        if (element instanceof NodeMetadata) {
            return (NodeMetadata)element;
        }
        return null;
    }

    public static Location asLocation(Object element) {
        if (element instanceof Location) {
            return (Location)element;
        }
        ComputeMetadata value = JClouds.asComputeMetadata(element);
        if (value != null) {
            return value.getLocation();
        }
        return null;
    }

    public static String id(ComputeMetadata node) {
        if (node != null) {
            return node.getId();
        }
        return null;
    }

    public static NodeState getState(ComputeMetadata n) {
        NodeMetadata node = JClouds.asNodeMetadata(n);
        if (node != null) {
            return node.getState();
        }
        return NodeState.ERROR;
    }
}

