/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.navigator;

import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.actions.CreateChildContainerAction;
import com.fusesource.ide.fabric.actions.CreateSshContainerAction;
import com.fusesource.ide.fabric.actions.Messages;
import com.fusesource.ide.fabric.actions.jclouds.CreateJCloudsContainerAction;
import com.fusesource.ide.fabric.navigator.ContainerTabViewPage;
import com.fusesource.ide.fabric.navigator.ContainerViewBean;
import com.fusesource.ide.fabric.navigator.ContainersNode;
import com.fusesource.ide.fabric.navigator.Fabric;
import com.fusesource.ide.fabric.navigator.FabricNodeSupport;
import com.fusesource.ide.fabric.navigator.Fabrics;
import com.fusesource.ide.fabric.navigator.IdBasedFabricNode;
import com.fusesource.ide.fabric.navigator.ProfileNode;
import com.fusesource.ide.fabric.navigator.VersionNode;
import com.fusesource.ide.fabric.navigator.jmx.FabricConnectionWrapper;
import com.fusesource.ide.fabric.views.logs.ContainerLogBrowser;
import com.fusesource.ide.fabric.views.logs.HasLogBrowser;
import com.fusesource.ide.fabric.views.logs.ILogBrowser;
import com.fusesource.ide.fabric.views.logs.Logs;
import com.fusesource.ide.jmx.ui.internal.views.navigator.ContextMenuProvider;
import com.fusesource.rider.commons.Activator;
import com.fusesource.rider.commons.tree.GraphableNode;
import com.fusesource.rider.commons.tree.GraphableNodeConnected;
import com.fusesource.rider.commons.tree.HasOwner;
import com.fusesource.rider.commons.tree.HasRefreshableUI;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.tree.RefreshableNode;
import com.fusesource.rider.commons.tree.RefreshableUI;
import com.fusesource.rider.commons.ui.ImageProvider;
import com.fusesource.rider.commons.ui.actions.ActionSupport;
import com.fusesource.rider.commons.util.Objects;
import com.fusesource.rider.server.karaf.view.ITerminalConnectionListener;
import com.fusesource.rider.server.karaf.view.SshView;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.CreateContainerBasicOptions;
import org.fusesource.fabric.api.CreateContainerChildOptions;
import org.fusesource.fabric.api.CreateContainerMetadata;
import org.fusesource.fabric.api.CreateContainerOptions;
import org.fusesource.fabric.api.CreateContainerOptionsBuilder;
import org.fusesource.fabric.api.FabricService;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.service.ContainerTemplate;
import org.fusesource.fabric.service.Containers;
import org.fusesource.fabric.service.JmxTemplateSupport;
import scala.actors.threadpool.Arrays;

public class ContainerNode
extends IdBasedFabricNode
implements HasRefreshableUI,
ImageProvider,
GraphableNode,
GraphableNodeConnected,
ContextMenuProvider,
ITerminalConnectionListener,
HasLogBrowser {
    private final Container container;
    private JmxTemplateSupport jmxTemplate;
    private ILogBrowser logBrowser;
    private ContainerTemplate containerTemplate;
    private FabricConnectionWrapper connectionWrapper;

    public static ContainerNode toContainerNode(Object object) {
        if (object instanceof ContainerNode) {
            return (ContainerNode)object;
        }
        if (object instanceof HasOwner) {
            HasOwner ho = (HasOwner)object;
            return ContainerNode.toContainerNode(ho.getOwner());
        }
        return null;
    }

    public static Container toContainer(Object object) {
        if (object instanceof Container) {
            return (Container)object;
        }
        ContainerNode node = ContainerNode.toContainerNode(object);
        if (node != null) {
            return node.getContainer();
        }
        return null;
    }

    public ContainerNode(RefreshableNode parent, Container agent, Fabric fabric) {
        super((Node)parent, fabric, agent.getId());
        Profile[] profiles;
        this.container = agent;
        this.setPropertyBean(new ContainerViewBean(agent));
        Joiner joiner = Joiner.on((String)"\n    ");
        Profile[] profileArray = profiles = agent.getProfiles();
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            Profile profile;
            Profile overlay = profile = profileArray[n2];
            System.out.println("Profile: " + overlay);
            System.out.println("  bundles: " + joiner.join((Iterable)overlay.getBundles()));
            System.out.println("  features: " + joiner.join((Iterable)overlay.getFeatures()));
            System.out.println("  repos:   " + joiner.join((Iterable)overlay.getRepositories()));
            ++n2;
        }
    }

    public ContainerNode(RefreshableNode parent, ContainerNode agentNode) {
        this(parent, agentNode.getContainer(), agentNode.getFabric());
    }

    public ContainerNode(FabricNodeSupport agents, Container agent) {
        this((RefreshableNode)agents, agent, agents.getFabric());
    }

    public VersionNode getVersionNode() {
        return this.getFabric().getVersionNode(this.container.getVersion().getName());
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            this.checkLoaded();
            VersionNode versionNode = this.getVersionNode();
            if (versionNode != null) {
                versionNode.getChildren();
                return new ContainerTabViewPage(this);
            }
        }
        return super.getAdapter(adapter);
    }

    public List<Node> getChildrenGraph() {
        HashSet<Node> answer = new HashSet<Node>();
        answer.add((Node)this);
        Profile[] profiles = this.getContainer().getProfiles();
        Collection<ProfileNode> profileNodes = this.getFabric().getProfileNodes(profiles);
        for (ProfileNode profileNode : profileNodes) {
            profileNode.addAndDescendants(answer);
        }
        return new ArrayList<Node>(answer);
    }

    @Override
    public ILogBrowser getLogBrowser() {
        if (this.logBrowser == null) {
            if (this.connectionWrapper != null) {
                this.logBrowser = Logs.toLogBrowser((Object)this.connectionWrapper);
            }
            if (this.logBrowser == null) {
                this.logBrowser = new ContainerLogBrowser(this);
            }
        }
        return this.logBrowser;
    }

    public Collection<Node> getGraphConnectedTo() {
        ContainersNode containersNode = this.getFabric().getContainersNode();
        if (this.getContainer().isRoot() && containersNode != null) {
            Container[] list;
            ArrayList<Node> answer = new ArrayList<Node>();
            Container[] containerArray = list = this.getContainer().getChildren();
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                Container container = containerArray[n2];
                ContainerNode containerNode = containersNode.getContainerNode(container.getId());
                if (containerNode != null) {
                    answer.add((Node)containerNode);
                }
                ++n2;
            }
            return answer;
        }
        return Collections.emptyList();
    }

    public RefreshableUI getRefreshableUI() {
        return super.getRefreshableUI();
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("container.png");
    }

    public String getSshUrl() {
        return this.getContainer().getSshUrl();
    }

    protected void checkLoaded() {
        if (this.hasJmxConnector()) {
            super.checkLoaded();
        }
    }

    protected void refreshUIAfterLazyLoad() {
        this.refreshUI();
    }

    protected void loadChildren() {
        if (this.hasJmxConnector()) {
            this.connectionWrapper = new FabricConnectionWrapper(this);
            this.addChild((Node)this.connectionWrapper);
        }
    }

    protected boolean hasJmxConnector() {
        boolean provisioned;
        Container a = this.getContainer();
        String jmxUrl = a.getJmxUrl();
        String provisionResult = a.getProvisionResult();
        String provisionException = a.getProvisionException();
        System.out.println("=============== PROVISION: " + provisionResult + " exception: " + provisionException + " alive: " + a.isAlive() + " provisoned: " + a.isProvisioningComplete());
        boolean bl = provisioned = a.isAlive() && a.isProvisioningComplete();
        return !Strings.isNullOrEmpty((String)jmxUrl) && (provisioned || a.isRoot());
    }

    public Container getContainer() {
        return this.container;
    }

    public ContainerTemplate getContainerTemplate() {
        if (this.containerTemplate == null) {
            this.containerTemplate = Containers.newContainerTemplate((Container)this.container);
            Fabric fabric = this.getFabric();
            this.containerTemplate.setLogin(fabric.getUserName());
            this.containerTemplate.setPassword(fabric.getPassword());
        }
        return this.containerTemplate;
    }

    public void setContainerTemplate(ContainerTemplate agentTemplate) {
        this.containerTemplate = agentTemplate;
    }

    public JmxTemplateSupport getJmxTemplate() {
        if (this.jmxTemplate == null) {
            this.jmxTemplate = this.getContainerTemplate().getJmxTemplate();
        }
        return this.jmxTemplate;
    }

    public boolean supportsJmxDomain(String domain) {
        return this.container.getJmxDomains().contains(domain);
    }

    public boolean matches(Profile profile) {
        Profile[] profiles;
        Container ag = this.getContainer();
        Profile[] profileArray = profiles = ag.getProfiles();
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            Profile prof = profileArray[n2];
            if (Objects.equal((Object)prof.getId(), (Object)profile.getId()) && Objects.equal((Object)Fabrics.getVersionName(ag.getVersion()), (Object)profile.getVersion())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean matches(Version version) {
        return Objects.equal((Object)Fabrics.getVersionName(this.getContainer().getVersion()), (Object)Fabrics.getVersionName(version));
    }

    public void provideContextMenu(IMenuManager menu) {
        Action startStopAction;
        ActionSupport openTerminalAction = new ActionSupport(Messages.openTerminalLabel, Messages.openTerminalToolTip, FabricPlugin.getDefault().getImageDescriptor("terminal_view.gif")){

            public void run() {
                ContainerNode.this.openTerminal();
            }
        };
        menu.add((IAction)openTerminalAction);
        final ImageDescriptor versionImage = FabricPlugin.getDefault().getImageDescriptor("version.png");
        final MenuManager subMenu = new MenuManager("Set Version", versionImage, "com.fusesource.rider.actions.update");
        menu.add((IContributionItem)subMenu);
        subMenu.setRemoveAllWhenShown(true);
        subMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Version[] versions;
                Version[] versionArray = versions = ContainerNode.this.getFabricService().getVersions();
                int n = versions.length;
                int n2 = 0;
                while (n2 < n) {
                    final Version version = versionArray[n2];
                    Action action = new Action(version.getName(), versionImage){

                        public void run() {
                            ContainerNode.this.getContainer().setVersion(version);
                            ContainerNode.this.refresh();
                            ContainerNode.this.getFabric().getVersionsNode().refresh();
                        }
                    };
                    if (ContainerNode.this.matches(version)) {
                        action.setEnabled(false);
                    }
                    subMenu.add((IAction)action);
                    ++n2;
                }
                subMenu.setVisible(true);
            }
        });
        if (this.getContainer().isAlive()) {
            startStopAction = new Action(Messages.StopAgentAction, 32){

                public void run() {
                    ContainerNode.this.stop();
                }
            };
            startStopAction.setToolTipText(Messages.StopAgentActionToolTip);
            startStopAction.setImageDescriptor(FabricPlugin.getDefault().getImageDescriptor("stop_task.gif"));
        } else {
            startStopAction = new Action(Messages.StartAgentAction, 32){

                public void run() {
                    ContainerNode.this.start();
                }
            };
            startStopAction.setToolTipText(Messages.StartAgentActionToolTip);
            startStopAction.setImageDescriptor(FabricPlugin.getDefault().getImageDescriptor("start_task.gif"));
        }
        menu.add((IAction)startStopAction);
        menu.add((IContributionItem)new Separator());
        if (this.getContainer().isRoot()) {
            menu.add((IAction)new CreateChildContainerAction(this));
        }
        menu.add((IAction)new CreateJCloudsContainerAction(this.getVersionNode(), this, null));
        menu.add((IAction)new CreateSshContainerAction(this.getVersionNode(), this, null));
    }

    protected void openTerminal() {
        ContainerNode.openTerminal(this.getFabric(), this.getContainer(), this);
    }

    public static void openTerminal(Fabric theFabric, Container theContainer, ITerminalConnectionListener listener) {
        String url = theContainer.getSshUrl();
        String user = theFabric.getUserName();
        String password = theFabric.getPassword();
        if (!url.contains("://")) {
            url = "http://" + url;
        }
        URL sshUrl = null;
        try {
            sshUrl = new URL(url);
        }
        catch (Exception e) {
            Activator.getLogger().warning("Failed to parse URI: '" + url + "'. " + e, (Throwable)e);
            return;
        }
        String host = sshUrl.getHost();
        int port = sshUrl.getPort();
        IViewPart vp = FabricPlugin.openTerminalView();
        if (vp == null || !(vp instanceof SshView)) {
            FabricPlugin.getLogger().error("Unable to open the terminal view!");
            return;
        }
        SshView connectorView = (SshView)vp;
        connectorView.setPartName(theContainer.getId());
        if (listener != null) {
            connectorView.addConnectionListener(listener);
        }
        try {
            System.out.println("Creating the connection if it doesn't exist for host: " + host + " port " + port + " user " + user + " pwd " + password);
            connectorView.createConnectionIfNotExists(host, port, user, password);
        }
        catch (Exception ex) {
            FabricPlugin.getLogger().error("Unable to connect via SSH", (Throwable)ex);
        }
    }

    public void onConnect() {
        FabricPlugin.openTerminalView().setFocus();
    }

    public void onDisconnect() {
        IViewPart vp = FabricPlugin.openTerminalView();
        if (vp == null || !(vp instanceof SshView)) {
            FabricPlugin.getLogger().error("Unable to open the terminal view!");
            return;
        }
        SshView connectorView = (SshView)vp;
        connectorView.setPartName(Messages.shellViewLabel);
        connectorView.removeConnectionListener((ITerminalConnectionListener)this);
    }

    public void createContainer(String name, Profile[] profiles) {
        try {
            CreateContainerMetadata[] newContainers;
            System.out.println("About to create child container of " + this + " with name: " + name + " and profiles: " + Arrays.asList((Object[])profiles));
            FabricService fabricService = this.getFabricService();
            String url = "child:" + this.getId();
            CreateContainerBasicOptions options = ((CreateContainerChildOptions)((CreateContainerChildOptions)((CreateContainerChildOptions)((CreateContainerChildOptions)CreateContainerOptionsBuilder.child().providerUri(url)).name(name)).parent(this.getId())).zookeeperUrl(fabricService.getZookeeperUrl())).proxyUri(fabricService.getMavenRepoURI());
            CreateContainerMetadata[] createContainerMetadataArray = newContainers = fabricService.createContainers((CreateContainerOptions)options);
            int n = newContainers.length;
            int n2 = 0;
            while (n2 < n) {
                CreateContainerMetadata metadata = createContainerMetadataArray[n2];
                Container newContainer = metadata.getContainer();
                this.getFabric().setContainerProfiles(newContainer, profiles);
                this.getFabric().refreshCreatedAgent(name);
                ++n2;
            }
        }
        catch (Exception e) {
            FabricPlugin.showUserError("Failed to create new child container of " + this, e.getMessage(), e);
        }
    }

    public void start() {
        try {
            this.getContainer().start();
            this.getFabric().refresh();
        }
        catch (Exception e) {
            FabricPlugin.showUserError("Failed to start container " + this, e.getMessage(), e);
        }
    }

    public void stop() {
        try {
            this.getContainer().stop();
            this.getFabric().refresh();
        }
        catch (Exception e) {
            FabricPlugin.showUserError("Failed to stop container " + this, e.getMessage(), e);
        }
    }

    public void destroy() {
        try {
            this.getContainer().destroy();
            this.getFabric().refresh();
        }
        catch (Exception e) {
            FabricPlugin.showUserError("Failed to destroy container " + this, e.getMessage(), e);
        }
    }

    public RefreshableNode getParent() {
        return (RefreshableNode)super.getParent();
    }

    public FabricService getFabricService() {
        return this.getFabric().getFabricService();
    }
}

