/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.navigator;

import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.navigator.ContainerViewBean;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.fusesource.fabric.api.Container;

public class ContainerStatusLabelProvider
extends StyledCellLabelProvider {
    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        ContainerViewBean bean = ContainerViewBean.toContainerViewBean(element);
        if (bean != null) {
            Container container = bean.container();
            boolean managed = container.isManaged();
            String image = "yellow-dot.png";
            String status = bean.getStatus();
            System.out.println("Container: " + container.getId() + " alive: " + container.isAlive() + " managed: " + container.isManaged() + " pending: " + container.isProvisioningPending() + " complete: " + container.isProvisioningComplete() + " status: " + container.getProvisionStatus());
            if (!bean.isAlive()) {
                image = "gray-dot.png";
            }
            if (container.isProvisioningPending()) {
                image = "yellow-dot.png";
                managed = true;
            } else if (status != null) {
                String lowerStatus = status.toLowerCase();
                if (lowerStatus.startsWith("success") || lowerStatus.length() == 0) {
                    if (bean.isAlive()) {
                        image = "green-dot.png";
                    } else {
                        status = "stopped";
                    }
                    if (lowerStatus.length() == 0 && !managed && bean.isRoot()) {
                        status = "root";
                    }
                } else if (lowerStatus.startsWith("error")) {
                    image = "red-dot.png";
                }
            }
            if (status != null) {
                StyledString.Styler style = null;
                StyledString styledString = new StyledString(status, style);
                cell.setText(styledString.toString());
                cell.setStyleRanges(styledString.getStyleRanges());
            }
            if (image != null) {
                cell.setImage(FabricPlugin.getDefault().getImage(image));
            }
        }
        super.update(cell);
    }
}

