/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.navigator;

import com.fusesource.ide.fabric.FabricConnector;
import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.actions.CreateChildContainerAction;
import com.fusesource.ide.fabric.actions.CreateSshContainerAction;
import com.fusesource.ide.fabric.actions.FabricConnectAction;
import com.fusesource.ide.fabric.actions.FabricDetails;
import com.fusesource.ide.fabric.actions.FabricDetailsDeleteAction;
import com.fusesource.ide.fabric.actions.FabricDetailsEditAction;
import com.fusesource.ide.fabric.actions.FabricDisconnectAction;
import com.fusesource.ide.fabric.actions.jclouds.CreateJCloudsContainerAction;
import com.fusesource.ide.fabric.navigator.ContainerNode;
import com.fusesource.ide.fabric.navigator.ContainersNode;
import com.fusesource.ide.fabric.navigator.FabricTabViewPage;
import com.fusesource.ide.fabric.navigator.Fabrics;
import com.fusesource.ide.fabric.navigator.ProfileNode;
import com.fusesource.ide.fabric.navigator.VersionNode;
import com.fusesource.ide.fabric.navigator.VersionsNode;
import com.fusesource.ide.fabric.views.logs.FabricLogBrowser;
import com.fusesource.ide.fabric.views.logs.HasLogBrowser;
import com.fusesource.ide.fabric.views.logs.ILogBrowser;
import com.fusesource.ide.jmx.ui.internal.views.navigator.ContextMenuProvider;
import com.fusesource.rider.commons.Viewers;
import com.fusesource.rider.commons.jobs.Jobs;
import com.fusesource.rider.commons.tree.GraphableNode;
import com.fusesource.rider.commons.tree.HasRefreshableUI;
import com.fusesource.rider.commons.tree.HasViewer;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.tree.RefreshableCollectionNode;
import com.fusesource.rider.commons.tree.RefreshableUI;
import com.fusesource.rider.commons.ui.ImageProvider;
import com.fusesource.rider.commons.ui.actions.HasDoubleClickAction;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.CreateContainerMetadata;
import org.fusesource.fabric.api.CreateContainerOptions;
import org.fusesource.fabric.api.CreationStateListener;
import org.fusesource.fabric.api.FabricService;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.ProfileStatus;
import org.fusesource.fabric.api.Version;
import org.linkedin.zookeeper.client.IZKClient;
import scala.actors.threadpool.Arrays;

public class Fabric
extends RefreshableCollectionNode
implements ImageProvider,
HasRefreshableUI,
GraphableNode,
HasLogBrowser,
ContextMenuProvider,
HasDoubleClickAction {
    public static final String DEFAULT_NAME = "Fabric";
    private static final boolean changeSelectionOnCreate = false;
    private String userName = "admin";
    private String password = "admin";
    private FabricConnector connector;
    private final Fabrics fabrics;
    private ContainersNode containersNode;
    private VersionsNode versionsNode;
    private FabricLogBrowser logBrowser;
    private FabricDetailsEditAction editAction;
    private FabricDetailsDeleteAction deleteAction;
    private FabricDetails details;
    private boolean connected = false;
    private boolean selectContainersOnCreate = true;
    private Set<Runnable> fabricUpdateTasks = new HashSet<Runnable>();

    public Fabric(Fabrics fabrics, FabricDetails details) {
        super((Node)fabrics);
        this.fabrics = fabrics;
        this.details = details;
        this.userName = details.getUserName();
        this.password = details.getPassword();
        this.connected = false;
        this.editAction = new FabricDetailsEditAction(){

            @Override
            protected FabricDetails getSelectedFabricDetails() {
                return Fabric.this.getDetails();
            }

            @Override
            protected void onFabricDetailsEdited(FabricDetails found) {
                Fabric.this.setDetails(found);
            }
        };
        this.deleteAction = new FabricDetailsDeleteAction(){

            @Override
            protected FabricDetails getSelectedFabricDetails() {
                return Fabric.this.getDetails();
            }
        };
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return new FabricTabViewPage(this);
        }
        return super.getAdapter(adapter);
    }

    public FabricService getFabricService() {
        if (this.connector != null) {
            return this.connector.getFabricService();
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public FabricDetails getDetails() {
        return this.details;
    }

    public void addFabricUpdateRunnable(Runnable runnable) {
        this.fabricUpdateTasks.add(runnable);
        System.out.println("=============== Now have " + this.fabricUpdateTasks.size() + " runnables");
    }

    public void removeFabricUpdateRunnable(Runnable runnable) {
        this.fabricUpdateTasks.remove(runnable);
    }

    public void setDetails(FabricDetails details) {
        String oldUrls = this.details.getUrls();
        this.details = details;
        String newUrls = details.getUrls();
        if (!Objects.equal((Object)oldUrls, (Object)newUrls)) {
            if (this.connector != null) {
                this.connector.dispose();
            }
            this.connector = new FabricConnector(this);
            this.setPropertyBean(this.connector);
        }
    }

    public RefreshableUI getRefreshableUI() {
        return this.fabrics.getRefreshableUI();
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("fabric.png");
    }

    protected void loadChildren() {
        if (!this.connected) {
            return;
        }
        this.containersNode = new ContainersNode(this);
        this.versionsNode = new VersionsNode(this);
        this.addChild((Node)this.containersNode);
        this.addChild((Node)this.versionsNode);
    }

    public void provideContextMenu(IMenuManager menu) {
        menu.add((IAction)new FabricConnectAction(this));
        menu.add((IAction)new FabricDisconnectAction(this));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.editAction);
        menu.add((IAction)this.deleteAction);
        if (this.connected) {
            menu.add((IContributionItem)new Separator());
            CreateChildContainerAction.addIfSingleRootContainer(menu, this);
            menu.add((IAction)new CreateJCloudsContainerAction(this));
            menu.add((IAction)new CreateSshContainerAction(this));
        }
    }

    public VersionNode getDefaultVersionNode() {
        if (!this.connected) {
            return null;
        }
        return this.versionsNode.getDefaultVersionNode();
    }

    public List<Node> getChildrenGraph() {
        HashSet answer = new HashSet();
        if (this.connected) {
            answer.addAll(this.getContainersNode().getChildrenList());
        }
        return new ArrayList<Node>(answer);
    }

    @Override
    public ILogBrowser getLogBrowser() {
        return this.logBrowser;
    }

    public Action getDoubleClickAction() {
        return new FabricConnectAction(this);
    }

    protected void addChildren(Set<Node> set, Node node, boolean showVersions) {
        if (node != null && this.connected) {
            List childrenList = node.getChildrenList();
            for (Node child : childrenList) {
                if (child instanceof ProfileNode || child instanceof VersionNode) {
                    this.addChildren(set, child, showVersions);
                } else if (!(child instanceof ContainerNode) && !showVersions && child instanceof VersionNode) continue;
                set.add(child);
            }
        }
    }

    public List<ContainerNode> getAgentsFor(Profile profile) {
        ArrayList<ContainerNode> answer = new ArrayList<ContainerNode>();
        if (this.containersNode != null && this.connected) {
            Node[] children;
            Node[] nodeArray = children = this.containersNode.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ContainerNode agent;
                Node node = nodeArray[n2];
                if (node instanceof ContainerNode && (agent = (ContainerNode)node).matches(profile)) {
                    answer.add(agent);
                }
                ++n2;
            }
        }
        return answer;
    }

    public ContainersNode getContainersNode() {
        return this.containersNode;
    }

    public VersionsNode getVersionsNode() {
        return this.versionsNode;
    }

    public String getName() {
        return this.details.getName();
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public FabricConnector getConnector() {
        return this.connector;
    }

    public void setConnector(FabricConnector conn) {
        if (conn == null) {
            this.connector.dispose();
        }
        this.connector = conn;
        this.setPropertyBean(this.connector);
    }

    public boolean isConnected() {
        try {
            this.connector.checkConnected();
        }
        catch (Exception e) {
            FabricPlugin.getLogger().debug("Fabric " + this + " is not connected  " + e);
            return false;
        }
        return true;
    }

    public Collection<ProfileNode> getProfileNodes(Profile[] profiles) {
        HashSet<ProfileNode> answer = new HashSet<ProfileNode>();
        if (this.connected) {
            Profile[] profileArray = profiles;
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                ProfileNode profileNode;
                Profile profile = profileArray[n2];
                VersionNode version = this.getVersionNode(profile.getVersion());
                if (version != null && (profileNode = version.getProfileNode(profile)) != null) {
                    answer.add(profileNode);
                }
                ++n2;
            }
        }
        return answer;
    }

    public VersionNode getVersionNode(String version) {
        if (this.versionsNode != null) {
            return this.versionsNode.getVersionNode(version);
        }
        return null;
    }

    public Version getVersion(String versionName) {
        VersionNode node = this.getVersionNode(versionName);
        if (node != null) {
            return node.getVersion();
        }
        return null;
    }

    public void createContainer(final Container agent, final String agentName, final Profile[] profiles, final CreateContainerOptions args) {
        if (!this.connected) {
            return;
        }
        try {
            System.out.println("About to create container with name: " + agentName + " arguments: " + args + " and profiles: " + Arrays.asList((Object[])profiles));
            if (agent != null) {
                args.setParent(agent.getId());
            }
            Jobs.schedule((Job[])new Job[]{new Job("Create container"){

                protected IStatus run(final IProgressMonitor monitor) {
                    try {
                        args.setCreationStateListener(new CreationStateListener(){

                            public void onStateChange(String message) {
                                monitor.subTask(message);
                            }
                        });
                        FabricService fabricService = Fabric.this.getFabricService();
                        final CreateContainerMetadata[] newAgents = agent != null ? fabricService.createContainers(args) : fabricService.createContainers(args);
                        Viewers.async((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                CreateContainerMetadata[] createContainerMetadataArray = newAgents;
                                int n = newAgents.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    CreateContainerMetadata metadata = createContainerMetadataArray[n2];
                                    Container newContainer = metadata.getContainer();
                                    if (newContainer != null) {
                                        Fabric.this.setContainerProfiles(newContainer, profiles);
                                        Fabric.this.refreshCreatedAgent(agentName);
                                    }
                                    ++n2;
                                }
                            }
                        });
                        return Status.OK_STATUS;
                    }
                    catch (Throwable e) {
                        return new Status(4, "com.fusesource.ide.fabric", "Failed to create container: " + e, e);
                    }
                }
            }});
        }
        catch (Exception e) {
            FabricPlugin.showUserError("Failed to create new child container of " + this, e.getMessage(), e);
        }
    }

    public void setContainerProfiles(Container newContainer, Profile[] profiles) {
        if (!this.connected) {
            return;
        }
        Version version = this.getProfilesVersion(profiles);
        if (version != null) {
            newContainer.setVersion(version);
        }
        newContainer.setProfiles(profiles);
    }

    public Version getProfilesVersion(Profile[] profiles) {
        Version version = null;
        if (this.connected) {
            Profile[] profileArray = profiles;
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                Profile profile = profileArray[n2];
                String versionName = profile.getVersion();
                if (versionName != null) {
                    version = this.getVersion(versionName);
                }
                ++n2;
            }
        }
        return version;
    }

    public void refreshCreatedAgent(String agentName) {
        if (!this.connected) {
            return;
        }
        Fabric fabric = this;
        ContainersNode containers = this.getContainersNode();
        if (containers != null) {
            containers.refresh();
        }
    }

    public String getNewAgentName() {
        return "container" + (this.getContainersNode().getChildCount() + 1);
    }

    public void onConnect() {
        this.connected = true;
        RefreshableUI refreshableUI = this.getRefreshableUI();
        if (refreshableUI instanceof HasViewer) {
            HasViewer hv = (HasViewer)refreshableUI;
            Viewer viewer = hv.getViewer();
            final Fabric fabric = this;
            if (viewer instanceof CommonViewer) {
                final CommonViewer cv = (CommonViewer)viewer;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ContainersNode containersNode = Fabric.this.getContainersNode();
                        Fabric.this.getVersionsNode();
                        cv.setExpandedElements(new Object[]{fabric, containersNode});
                        cv.setSelection((ISelection)new StructuredSelection((Object)containersNode));
                    }
                });
            }
        }
    }

    public void onDisconnect() {
        this.connected = false;
    }

    public List<ContainerNode> getRootContainers() {
        ArrayList<ContainerNode> answer = new ArrayList<ContainerNode>();
        if (this.containersNode != null) {
            for (ContainerNode node : this.containersNode.getContainerNodes()) {
                if (!node.getContainer().isRoot()) continue;
                answer.add(node);
            }
        }
        return answer;
    }

    public void onZooKeeperUpdate() {
        Viewers.async((Runnable)new Runnable(){

            @Override
            public void run() {
                System.out.println("Refreshing Fabric " + this + " due to ZK change!");
                Fabric.this.getContainersNode().refresh();
                for (Runnable task : Fabric.this.fabricUpdateTasks) {
                    task.run();
                }
            }
        });
    }

    public IZKClient getZooKeeper() {
        if (this.connector != null) {
            return this.connector.getZooKeeper();
        }
        return null;
    }

    public Collection<ProfileStatus> getProfileStatuses() {
        FabricService service = this.getFabricService();
        if (service == null || !this.isConnected()) {
            return new ArrayList<ProfileStatus>();
        }
        return service.getFabricStatus().getProfileStatusMap().values();
    }
}

