/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.navigator;

import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.navigator.Fabric;
import com.fusesource.ide.fabric.navigator.Fabrics;
import com.fusesource.ide.fabric.navigator.ProfileNode;
import com.fusesource.ide.fabric.navigator.VersionNode;
import com.fusesource.ide.fabric.navigator.VersionsNode;
import com.fusesource.ide.fabric.navigator.cloud.CloudsNode;
import com.fusesource.ide.jmx.ui.internal.actions.RefreshAction;
import com.fusesource.ide.jmx.ui.internal.views.navigator.Navigator;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.ui.drop.DelegateDropListener;
import com.fusesource.rider.commons.ui.drop.DropHandler;
import com.fusesource.rider.deployment.maven.ProjectDropHandler;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.part.ResourceTransfer;

public class FabricNavigator
extends Navigator {
    public static String ID = "com.fusesource.ide.fabric.navigator";
    private Fabrics fabrics;
    private CloudsNode clouds;

    public FabricNavigator() {
        this.fabrics = new Fabrics(this.refreshableUI);
        this.clouds = new CloudsNode(this.refreshableUI);
    }

    protected IAdaptable getInitialInput() {
        return this;
    }

    public void createPartControl(Composite aParent) {
        super.createPartControl(aParent);
        CommonViewer viewer = this.getCommonViewer();
        viewer.setExpandedElements(new Object[]{this.clouds, this.fabrics});
    }

    protected CommonViewer createCommonViewer(Composite aParent) {
        return new CommonViewer(this.getViewSite().getId(), aParent, 772){

            public void addDragSupport(int operations, Transfer[] transferTypes, DragSourceListener listener) {
                super.addDragSupport(operations, transferTypes, listener);
            }

            public void addDropSupport(int operations, Transfer[] transferTypes, DropTargetListener listener) {
                Transfer[] newTransferTypes = new Transfer[]{LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance(), ResourceTransfer.getInstance(), TextTransfer.getInstance()};
                super.addDropSupport(operations, newTransferTypes, (DropTargetListener)new DelegateDropListener((Viewer)this, listener));
            }
        };
    }

    public CloudsNode getCloudsNode() {
        return this.clouds;
    }

    public Fabrics getFabrics() {
        this.ensureDeployViewRegistered();
        return this.fabrics;
    }

    public void fillActionBars() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IAction)this.fabrics.getAddAction());
        toolBarManager.add((IAction)new RefreshAction(this.getViewSite().getId()));
        toolBarManager.add((IContributionItem)new Separator());
        this.getViewSite().getActionBars().updateActionBars();
    }

    public void appendDeployActions(Menu menu, IResource resource) {
        if (resource instanceof IProject) {
            final IProject project = (IProject)resource;
            boolean added = false;
            List<Fabric> list = this.fabrics.getFabrics();
            for (Fabric fabric : list) {
                VersionsNode versionsNode;
                if (!fabric.isConnected() || (versionsNode = fabric.getVersionsNode()) == null) continue;
                Menu fabricMenu = null;
                List versions = versionsNode.getChildrenList();
                for (Node node : versions) {
                    if (!(node instanceof VersionNode)) continue;
                    Menu versionMenu = null;
                    VersionNode versionNode = (VersionNode)node;
                    List<ProfileNode> profiles = versionNode.getAllProfileNodes();
                    for (ProfileNode profileNode : profiles) {
                        DropHandler handler = profileNode.createDropHandler(null);
                        if (!(handler instanceof ProjectDropHandler)) continue;
                        final ProjectDropHandler projectHandler = (ProjectDropHandler)handler;
                        if (fabricMenu == null) {
                            fabricMenu = new Menu(menu);
                            MenuItem fabricMenuItem = new MenuItem(menu, 64);
                            fabricMenuItem.setMenu(fabricMenu);
                            fabricMenuItem.setText(fabric.getName());
                            fabricMenuItem.setImage(FabricPlugin.getDefault().getImage("fabric.png"));
                        }
                        if (versionMenu == null) {
                            versionMenu = new Menu(fabricMenu);
                            MenuItem versionMenuItem = new MenuItem(fabricMenu, 64);
                            versionMenuItem.setMenu(versionMenu);
                            versionMenuItem.setText(versionNode.getVersionId());
                            versionMenuItem.setImage(FabricPlugin.getDefault().getImage("version_folder.png"));
                        }
                        final MenuItem profileItem = new MenuItem(versionMenu, 8);
                        profileItem.setText(profileNode.getId());
                        profileItem.setImage(FabricPlugin.getDefault().getImage("profile.png"));
                        profileItem.setData((Object)profileNode);
                        profileItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                System.out.println("================= profile: widgetSelected " + profileItem);
                                projectHandler.dropProject(project);
                            }

                            public void widgetDefaultSelected(SelectionEvent e) {
                                System.out.println("================= profile: widgetDefaultSelected " + profileItem);
                            }
                        });
                        added = true;
                    }
                }
            }
            if (added) {
                new MenuItem(menu, 2);
            }
        }
    }

    protected String getViewId() {
        return ID;
    }
}

