/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.navigator;

import com.fusesource.ide.fabric.actions.CreateChildContainerAction;
import com.fusesource.ide.fabric.actions.CreateSshContainerAction;
import com.fusesource.ide.fabric.actions.jclouds.CreateJCloudsContainerAction;
import com.fusesource.ide.fabric.navigator.Fabric;
import com.fusesource.rider.commons.Viewers;
import com.fusesource.rider.commons.tree.Refreshables;
import com.fusesource.rider.commons.ui.Selections;
import com.fusesource.rider.commons.ui.actions.SeparatorFactory;
import com.fusesource.rider.commons.ui.label.Health;
import com.fusesource.rider.commons.ui.label.HealthLabelProvider;
import com.fusesource.rider.commons.ui.label.PercentFunctionLabelProvider;
import com.fusesource.rider.commons.ui.views.TableViewSupport;
import com.fusesource.rider.commons.util.Function1;
import com.fusesource.rider.commons.util.FunctionInteger;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.fusesource.fabric.api.ProfileStatus;
import org.fusesource.fabric.api.Version;

public class FabricStatusTableSheetPage
extends TableViewSupport
implements IPropertySheetPage {
    public static final String VIEW_ID = FabricStatusTableSheetPage.class.getName();
    protected static SeparatorFactory separatorFactory = new SeparatorFactory(VIEW_ID);
    private boolean showPercentOnStatusColumn;
    private final Fabric fabric;
    private Action openTerminalAction;
    private Action startAction;
    private Action stopAction;
    private Action destroyAction;
    private CreateChildContainerAction createChildContainerAction;
    private CreateJCloudsContainerAction createCloudContainerAction;
    private CreateSshContainerAction createSshContainerAction;
    private MenuManager setVersionMenu;
    private Separator separator1 = separatorFactory.createSeparator();
    private Separator separator2 = separatorFactory.createSeparator();
    private Separator separator3 = separatorFactory.createSeparator();
    private Separator separator4 = separatorFactory.createSeparator();
    private Runnable refreshRunnable = new Runnable(){

        @Override
        public void run() {
            FabricStatusTableSheetPage.this.refresh();
        }
    };

    public static ProfileStatus asProfileStatus(Object element) {
        if (element instanceof ProfileStatus) {
            return (ProfileStatus)element;
        }
        return null;
    }

    public FabricStatusTableSheetPage(Fabric fabric) {
        this.fabric = fabric;
        this.updateActionStatus();
    }

    public void dispose() {
        super.dispose();
        this.fabric.removeFabricUpdateRunnable(this.refreshRunnable);
    }

    protected void configureViewer() {
        this.updateData();
    }

    public void refresh() {
        Viewers.async((Runnable)new Runnable(){

            @Override
            public void run() {
                FabricStatusTableSheetPage.this.updateData();
                Refreshables.refresh((Object)FabricStatusTableSheetPage.this.getViewer());
                FabricStatusTableSheetPage.this.updateActionStatus();
            }
        });
    }

    protected void updateData() {
        this.setInput(this.getProfileStatuses());
    }

    protected Collection<ProfileStatus> getProfileStatuses() {
        return this.fabric.getProfileStatuses();
    }

    protected void createColumns() {
        this.clearColumns();
        int bounds = 100;
        int column = 0;
        Object function = new Function1(){

            public Object apply(Object element) {
                ProfileStatus status = FabricStatusTableSheetPage.asProfileStatus(element);
                if (status != null) {
                    return status.getProfile();
                }
                return null;
            }
        };
        column = this.addColumnFunction(250, column, (Function1)function, "Profile");
        function = new FunctionInteger(){

            public Integer apply(Object element) {
                ProfileStatus status = FabricStatusTableSheetPage.asProfileStatus(element);
                if (status != null) {
                    return status.getCount();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Count");
        function = new FunctionInteger(){

            public Integer apply(Object element) {
                ProfileStatus status = FabricStatusTableSheetPage.asProfileStatus(element);
                if (status != null) {
                    return status.getMinimumInstances();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Minumum");
        function = new FunctionInteger(){

            public Integer apply(Object element) {
                ProfileStatus status = FabricStatusTableSheetPage.asProfileStatus(element);
                if (status != null) {
                    return status.getMaximumInstances();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Maximum");
        function = new Function1(){

            public Object apply(Object element) {
                ProfileStatus status = FabricStatusTableSheetPage.asProfileStatus(element);
                if (status != null) {
                    return FabricStatusTableSheetPage.this.toHealth(status);
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Status", (CellLabelProvider)new HealthLabelProvider(function));
        function = new Function1(){

            public Double apply(Object element) {
                ProfileStatus status = FabricStatusTableSheetPage.asProfileStatus(element);
                if (status != null) {
                    return status.getHealth(status.getCount());
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Health", (CellLabelProvider)new PercentFunctionLabelProvider(function));
        function = new Function1(){

            public Object apply(Object element) {
                ProfileStatus status = FabricStatusTableSheetPage.asProfileStatus(element);
                if (status != null) {
                    return status.getDependentProfiles();
                }
                return null;
            }
        };
        column = this.addColumnFunction(250, column, (Function1)function, "Dependencies");
    }

    protected Health toHealth(ProfileStatus status) {
        int count = status.getCount();
        String text = null;
        if (this.showPercentOnStatusColumn) {
            text = NumberFormat.getPercentInstance().format(status.getHealth(count));
        }
        return Health.newInstance((String)text, (Number)count, (Number)status.getMinimumInstances(), (Number)status.getMaximumInstances());
    }

    protected IStructuredContentProvider createContentProvider() {
        return ArrayContentProvider.getInstance();
    }

    protected String getHelpID() {
        return VIEW_ID;
    }

    public Fabric getFabric() {
        return this.fabric;
    }

    public void setActionBars(IActionBars actionBars) {
        super.setActionBars(actionBars);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FabricStatusTableSheetPage.this.updateActionStatus();
            }
        });
        this.fabric.addFabricUpdateRunnable(this.refreshRunnable);
    }

    protected IStructuredSelection getSelection() {
        return Selections.getStructuredSelection((Viewer)this.getViewer());
    }

    protected boolean hasVersionApartFrom(Set<String> names, Version version) {
        int minSize;
        int n = minSize = names.contains(version.getName()) ? 2 : 1;
        return names.size() >= minSize;
    }

    protected CreateChildContainerAction getCreateChildContainerAction() {
        if (this.createChildContainerAction == null) {
            this.createChildContainerAction = this.createChildContainerAction(this.fabric);
            this.createChildContainerAction.updateEnabled();
        }
        return this.createChildContainerAction;
    }

    protected void setCreateChildContainerAction(CreateChildContainerAction createChildContainerAction) {
        this.createChildContainerAction = createChildContainerAction;
    }

    protected CreateJCloudsContainerAction getCreateCloudContainerAction() {
        if (this.createCloudContainerAction == null) {
            this.createCloudContainerAction = this.createCloudContainerAction(this.fabric);
        }
        return this.createCloudContainerAction;
    }

    protected void setCreateCloudContainerAction(CreateJCloudsContainerAction createCloudContainerAction) {
        this.createCloudContainerAction = createCloudContainerAction;
    }

    protected CreateSshContainerAction getCreateSshContainerAction() {
        if (this.createSshContainerAction == null) {
            this.createSshContainerAction = this.createSshContainerAction(this.fabric);
        }
        return this.createSshContainerAction;
    }

    protected void setCreateSshContainerAction(CreateSshContainerAction createSshContainerAction) {
        this.createSshContainerAction = createSshContainerAction;
    }

    protected CreateJCloudsContainerAction createCloudContainerAction(Fabric fabric) {
        return new CreateJCloudsContainerAction(fabric);
    }

    protected CreateSshContainerAction createSshContainerAction(Fabric fabric) {
        return new CreateSshContainerAction(fabric);
    }

    protected CreateChildContainerAction createChildContainerAction(Fabric fabric) {
        return new CreateChildContainerAction(fabric);
    }

    protected void updateActionStatus() {
    }
}

