/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.navigator;

import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.actions.FabricDetails;
import com.fusesource.ide.fabric.actions.FabricDetailsAddAction;
import com.fusesource.ide.fabric.actions.jclouds.CreateJCloudsFabricAction;
import com.fusesource.ide.fabric.navigator.Fabric;
import com.fusesource.ide.fabric.navigator.FabricEvent;
import com.fusesource.ide.fabric.navigator.FabricListener;
import com.fusesource.ide.jmx.ui.internal.views.navigator.ContextMenuProvider;
import com.fusesource.rider.commons.Viewers;
import com.fusesource.rider.commons.tree.HasRefreshableUI;
import com.fusesource.rider.commons.tree.HasViewer;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.tree.RefreshableCollectionNode;
import com.fusesource.rider.commons.tree.RefreshableUI;
import com.fusesource.rider.commons.ui.ImageProvider;
import com.fusesource.rider.commons.util.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jdt.internal.ui.preferences.formatter.WhiteSpaceOptions;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.fusesource.fabric.api.FabricService;
import org.fusesource.fabric.api.Version;

public class Fabrics
extends RefreshableCollectionNode
implements ImageProvider,
HasRefreshableUI,
HasViewer,
ContextMenuProvider {
    public static final String DEFAULT_FABRIC_URL = "localhost:2181";
    public static final String DEFAULT_USERNAME = "karaf";
    public static final String DEFAULT_PASSWORD = "karaf";
    public static final String DEFAULT_MAVEN_PROXY_URI = "http://repo.fusesource.com/nexus/content/groups/ea";
    private final RefreshableUI refreshableUI;
    private List<Fabric> fabrics = new CopyOnWriteArrayList<Fabric>();
    private List<FabricListener> listeners = new ArrayList<FabricListener>();
    private boolean createLocalFabric;
    private FabricDetailsAddAction addAction;

    public Fabrics(RefreshableUI refreshableUI) {
        super(null);
        this.refreshableUI = refreshableUI;
        this.addAction = new FabricDetailsAddAction(this);
    }

    public FabricDetailsAddAction getAddAction() {
        return this.addAction;
    }

    public RefreshableUI getRefreshableUI() {
        return this.refreshableUI;
    }

    public Viewer getViewer() {
        return Viewers.getViewer((Object)this.getRefreshableUI());
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("fabric_folder.png");
    }

    protected void loadChildren() {
        WritableList list = this.getFabricDetailList();
        for (FabricDetails details : list) {
            this.addFabric(details);
        }
        if (this.createLocalFabric && list.isEmpty()) {
            this.addFabric("Local Fabric", DEFAULT_FABRIC_URL);
        }
        this.getFabricDetailList().addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                Fabrics.this.refresh();
            }
        });
    }

    public WritableList getFabricDetailList() {
        return FabricDetails.getDetailList();
    }

    public String toString() {
        return "Fabrics";
    }

    public List<Fabric> getFabrics() {
        return this.fabrics;
    }

    public Fabric getFabric(String name) {
        for (Fabric fabric : this.fabrics) {
            if (!fabric.getName().equals(name)) continue;
            return fabric;
        }
        return null;
    }

    protected void checkLoaded() {
        super.checkLoaded();
        this.checkConnected();
    }

    private void checkConnected() {
        for (Fabric fabric : this.fabrics) {
            fabric.isConnected();
        }
    }

    public void addFabricListener(FabricListener listener) {
        this.listeners.add(listener);
    }

    public void removeFabricListener(FabricListener listener) {
        this.listeners.remove(listener);
    }

    public Fabric addFabric(Fabric fabric) {
        this.fabrics.add(fabric);
        super.addChild((Node)fabric);
        if (!this.isLoading()) {
            this.fireFabricChanged(new FabricEvent(fabric));
        }
        return fabric;
    }

    public Fabric addFabric(FabricDetails details) {
        details.flush();
        Fabric fabric = new Fabric(this, details);
        return this.addFabric(fabric);
    }

    public Fabric addFabric(String fabricName, String uris) {
        FabricDetails details = FabricDetails.newInstance(fabricName, uris);
        System.out.println("Created fabric details: " + (Object)((Object)details));
        return this.addFabric(details);
    }

    public void provideContextMenu(IMenuManager menu) {
        menu.add((IAction)this.addAction);
        menu.add((IAction)new CreateJCloudsFabricAction(this));
    }

    protected void fireFabricChanged(FabricEvent fabricEvent) {
        for (FabricListener listener : this.listeners) {
            listener.onFabricEvent(fabricEvent);
        }
        this.refreshUI();
    }

    public static String getVersionName(Version version) {
        String text = null;
        if (version != null) {
            text = version.getName();
        }
        return Strings.getOrElse((Object)text, (String)"");
    }

    public static Fabric toFabric(Object object) {
        if (object instanceof Fabric) {
            return (Fabric)object;
        }
        if (object instanceof WhiteSpaceOptions.Node) {
            WhiteSpaceOptions.Node n = (WhiteSpaceOptions.Node)object;
            return Fabrics.toFabric(n.getParent());
        }
        return null;
    }

    public static Version getLatestVersion(FabricService fabricService) {
        Version[] versions = fabricService.getVersions();
        if (versions != null && versions.length > 0) {
            return versions[versions.length - 1];
        }
        return null;
    }
}

