/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.navigator;

import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.navigator.MessageDropTarget;
import com.fusesource.ide.fabric.views.MessagesView;
import com.fusesource.rider.commons.ui.Workbenches;
import com.fusesource.rider.commons.ui.drop.DropHandlerSupport;
import com.fusesource.rider.commons.ui.views.ColumnViewSupport;
import com.fusesource.rider.commons.util.IFiles;
import java.io.File;
import java.io.InputStream;
import javax.xml.bind.JAXBException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.fusesource.fon.util.messages.Exchanges;
import org.fusesource.fon.util.messages.IMessage;
import org.fusesource.fon.util.messages.Message;
import org.fusesource.fon.util.messages.contenttype.MessagesNamespaceXmlContentDescriber;
import org.fusesource.scalate.util.IOUtil;

public class MessageDropHandler
extends DropHandlerSupport {
    private final MessageDropTarget target;

    public MessageDropHandler(MessageDropTarget target) {
        this.target = target;
    }

    public void dropIFile(IFile resource) {
        try {
            IMessage message = MessageDropHandler.fileToMessage(resource);
            if (message != null) {
                this.dropMessage(message);
            }
        }
        catch (Exception e) {
            FabricPlugin.showUserError("Failed to send message to " + this.target, "Failed to load resource " + resource + " as a Message. ", e);
        }
    }

    public static IMessage fileToMessage(IFile resource) throws CoreException, JAXBException {
        IMessage message;
        IContentDescription contentDescription = resource.getContentDescription();
        resource.getFileExtension();
        if (MessagesNamespaceXmlContentDescriber.isXmlFormat((IFile)resource)) {
            message = Exchanges.loadMessage((Object)resource, (InputStream)resource.getContents());
        } else {
            File file = IFiles.toFile((IFile)resource);
            if (file != null) {
                IContentType contentType;
                Message m = new Message();
                message = m;
                MessageDropHandler.setMessageBody(m, file, !IFiles.isTextContentType((IFile)resource));
                if (contentDescription != null && (contentType = contentDescription.getContentType()) != null) {
                    m.setHeader("EclipseContentType", contentType.getId());
                }
            } else {
                message = null;
            }
        }
        return message;
    }

    public static void setMessageBody(Message m, File file, boolean binary) {
        Object body = null;
        if (binary) {
            body = IOUtil.loadBinaryFile((File)file);
        } else {
            String text = IOUtil.loadTextFile((File)file, (String)"UTF-8");
            body = text;
        }
        m.setBody(body);
    }

    public void dropFile(File file) {
        try {
            IMessage message = Exchanges.loadMessage((File)file);
            this.dropMessage(message);
        }
        catch (Exception e) {
            FabricPlugin.showUserError("Failed to send message to " + this.target, "Failed to load file " + file + " as a Message. ", e);
        }
    }

    public void dropMessage(IMessage message) {
        if (message != null) {
            IViewPart view;
            this.target.dropMessage(message);
            IWorkbenchPage activeWorkbenchPage = Workbenches.getActiveWorkbenchPage();
            if (activeWorkbenchPage != null && (view = activeWorkbenchPage.findView("com.fusesource.ide.fabric.views.MessagesView")) instanceof MessagesView) {
                ColumnViewSupport messageView = (ColumnViewSupport)view;
                messageView.refresh();
            }
        }
    }
}

