/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.navigator;

import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.actions.CreateChildContainerAction;
import com.fusesource.ide.fabric.actions.CreateSshContainerAction;
import com.fusesource.ide.fabric.actions.ProfileAddAction;
import com.fusesource.ide.fabric.actions.ProfileDeleteAction;
import com.fusesource.ide.fabric.actions.jclouds.CreateJCloudsContainerAction;
import com.fusesource.ide.fabric.navigator.ContainerNode;
import com.fusesource.ide.fabric.navigator.Fabric;
import com.fusesource.ide.fabric.navigator.IdBasedFabricNode;
import com.fusesource.ide.fabric.navigator.ProfileBean;
import com.fusesource.ide.fabric.navigator.ProfileTabViewPage;
import com.fusesource.ide.fabric.navigator.VersionNode;
import com.fusesource.ide.fabric.navigator.maven.FabricDeployAction;
import com.fusesource.ide.jmx.ui.internal.views.navigator.ContextMenuProvider;
import com.fusesource.rider.commons.properties.PropertySources;
import com.fusesource.rider.commons.tree.GraphableNode;
import com.fusesource.rider.commons.tree.HasRefreshableUI;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.tree.RefreshableUI;
import com.fusesource.rider.commons.ui.ImageProvider;
import com.fusesource.rider.commons.ui.drop.DropHandler;
import com.fusesource.rider.commons.ui.drop.DropHandlerFactory;
import com.fusesource.rider.commons.util.Objects;
import com.fusesource.rider.deployment.maven.MavenUtils;
import com.fusesource.rider.deployment.maven.ProjectDropHandler;
import com.fusesource.rider.deployment.maven.ProjectDropTarget;
import com.fusesource.rider.launcher.ui.ExecutePomActionPostProcessor;
import com.fusesource.rider.launcher.ui.ExecutePomActionSupport;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.model.Model;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.fusesource.fabric.api.Profile;

public class ProfileNode
extends IdBasedFabricNode
implements HasRefreshableUI,
ImageProvider,
GraphableNode,
ContextMenuProvider,
ProjectDropTarget,
DropHandlerFactory {
    private static final String AGENT_PID = "org.fusesource.fabric.agent";
    private static final boolean addContainersToTree = false;
    private Map<String, ProfileNode> map = new HashMap<String, ProfileNode>();
    private final Fabric fabric;
    private final Profile profile;
    private final VersionNode versionNode;

    public ProfileNode getProfileNode(String profileId) {
        this.checkLoaded();
        ProfileNode answer = this.map.get(profileId);
        if (answer == null) {
            answer = ProfileNode.getProfileNode(profileId, this.getProfileChildren());
        }
        return answer;
    }

    public ProfileNode(VersionNode versionNode, Node parent, Profile profile) {
        super(parent, versionNode.getFabric(), profile.getId());
        this.versionNode = versionNode;
        this.fabric = versionNode.getFabric();
        this.profile = profile;
        this.setPropertyBean((Object)new ProfileBean(profile));
    }

    public ProfileNode(VersionNode parent, Profile profile) {
        this(parent, (Node)parent, profile);
    }

    public List<Node> getChildrenGraph() {
        HashSet answer = new HashSet();
        answer.addAll(this.getChildrenList());
        return new ArrayList<Node>(answer);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            this.checkLoaded();
            this.getVersionNode().getChildren();
            return new ProfileTabViewPage(this);
        }
        return super.getAdapter(adapter);
    }

    public RefreshableUI getRefreshableUI() {
        return super.getRefreshableUI();
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("profile.png");
    }

    protected void loadChildren() {
        Map configurations = this.getProfile().getConfigurations();
        System.out.println("Configuration of " + (Object)((Object)this) + " = " + configurations);
        Set<Profile> childProfiles = this.versionNode.getChildProfiles(this.getProfileId());
        if (childProfiles != null) {
            for (Profile profile : childProfiles) {
                this.addChild((Node)this.versionNode.createProfile((Node)this, profile));
            }
        }
    }

    public List<ContainerNode> getContainerNodes() {
        return this.getFabric().getAgentsFor(this.getProfile());
    }

    public static ProfileNode getProfileNode(String profileId, ProfileNode[] children) {
        ProfileNode answer = null;
        ProfileNode[] profileNodeArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ProfileNode child = profileNodeArray[n2];
            answer = child.getProfileNode(profileId);
            if (answer != null) {
                return answer;
            }
            ++n2;
        }
        return answer;
    }

    public ProfileNode[] getProfileChildren() {
        return (ProfileNode[])Objects.getArrayOf((Collection)this.getChildrenList(), ProfileNode.class);
    }

    public DropHandler createDropHandler(DropTargetEvent event) {
        return new ProjectDropHandler((ProjectDropTarget)this);
    }

    @Override
    public Fabric getFabric() {
        return this.fabric;
    }

    public void dropProject(IProject project, final Model mavenModel) {
        if (mavenModel != null) {
            FabricDeployAction action = new FabricDeployAction(this);
            action.setPostProcessor(new ExecutePomActionPostProcessor(){

                public void executeOnFailure() {
                }

                public void executeOnSuccess() {
                    if (ProfileNode.this.profile != null) {
                        HashMap<String, String> agentConfig;
                        HashMap<String, HashMap<String, String>> config;
                        String uri = MavenUtils.getBundleURI((Model)mavenModel);
                        if (uri != null) {
                            List list;
                            if (uri.startsWith("fab:")) {
                                uri = uri.substring(4);
                                list = ProfileNode.this.profile.getFabs();
                                if (list != null && !list.contains(uri)) {
                                    list.add(uri);
                                    ProfileNode.this.profile.setFabs(list);
                                }
                            } else {
                                list = ProfileNode.this.profile.getBundles();
                                if (list != null && !list.contains(uri)) {
                                    list.add(uri);
                                    ProfileNode.this.profile.setBundles(list);
                                }
                            }
                        }
                        if ((config = ProfileNode.this.profile.getConfigurations()) == null) {
                            config = new HashMap<String, HashMap<String, String>>();
                        }
                        if ((agentConfig = (HashMap<String, String>)config.get(ProfileNode.AGENT_PID)) == null) {
                            agentConfig = new HashMap<String, String>();
                            config.put(ProfileNode.AGENT_PID, agentConfig);
                        }
                        agentConfig.put("org.fusesource.fabric.buildTime", uri + " at " + new Date());
                        ProfileNode.this.profile.setConfigurations(config);
                        ProfileNode.this.refresh();
                    }
                }
            });
            MavenUtils.launch((ExecutePomActionSupport)action);
        }
    }

    public String getMavenDeployParameter() {
        Fabric theFabric = this.getFabric();
        URI u = theFabric.getFabricService().getMavenRepoUploadURI();
        try {
            String uriText;
            boolean addUserPasswordToUrl = false;
            if (addUserPasswordToUrl) {
                String userInfo = String.valueOf(theFabric.getUserName()) + ":" + theFabric.getPassword();
                URI mavenRepoURI = new URI(u.getScheme(), userInfo, u.getHost(), u.getPort(), u.getPath(), u.getQuery(), u.getFragment());
                uriText = mavenRepoURI.toString();
            } else {
                uriText = u.toString();
            }
            System.out.println("===== deploying to the mavenRepoURL: " + uriText + " based on the URI from Fabric: " + u);
            return String.valueOf(this.getFabricNameWithoutSpaces()) + "::default::" + uriText;
        }
        catch (URISyntaxException e) {
            FabricPlugin.getLogger().error("Failed to create upload URI from " + u + ". Reason: " + e, (Throwable)e);
            return null;
        }
    }

    public String getFabricNameWithoutSpaces() {
        return this.getFabric().getName().replace(' ', '_');
    }

    public Profile getProfile() {
        return this.profile;
    }

    public String getProfileId() {
        return this.profile.getId();
    }

    public VersionNode getVersionNode() {
        return this.versionNode;
    }

    public void addAndDescendants(Set<Node> answer) {
        answer.add((Node)this);
        Node p = this.getParent();
        if (p instanceof ProfileNode) {
            ProfileNode parentNode = (ProfileNode)p;
            parentNode.addAndDescendants(answer);
        }
    }

    public void provideContextMenu(IMenuManager menu) {
        menu.add((IAction)new CreateChildContainerAction(this));
        menu.add((IAction)new CreateJCloudsContainerAction(this.getVersionNode(), null, this));
        menu.add((IAction)new CreateSshContainerAction(this.getVersionNode(), null, this));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)new ProfileAddAction(this));
        menu.add((IAction)new ProfileDeleteAction(this));
    }

    public List<IPropertySource> getContainerPropertySourceList() {
        return PropertySources.toPropertySourceList(this.getContainerNodes());
    }
}

